/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPEvent;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPIdentifierCase;
import org.jkiss.dbeaver.model.DBPInheritedObject;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPUniqueObject;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingCustom;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingMeta;
import org.jkiss.dbeaver.model.data.DBDAttributeBindingType;
import org.jkiss.dbeaver.model.data.DBDAttributeFilter;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDPreferences;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeType;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.data.DBDValueHandlerProvider;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCEntityMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCResultSetSampleProvider;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.data.DBDValueError;
import org.jkiss.dbeaver.model.impl.data.DefaultValueHandler;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithResult;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryType;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAlias;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSEntityReferrer;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSInstanceLazy;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKeyColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntityConstraint;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public final class DBUtils {
    private static final Log log = Log.getLog(DBUtils.class);
    private static final int MAX_SAMPLE_ROWS = 1000;

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBPNamedObject object) {
        return object instanceof DBSObject ? DBUtils.getQuotedIdentifier(((DBSObject)object).getDataSource(), object.getName()) : object.getName();
    }

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBSObject object) {
        return DBUtils.getQuotedIdentifier(object.getDataSource(), object.getName());
    }

    public static boolean isQuotedIdentifier(@NotNull DBPDataSource dataSource, @NotNull String str) {
        String[][] quoteStrings = dataSource.getSQLDialect().getIdentifierQuoteStrings();
        if (ArrayUtils.isEmpty((Object[])quoteStrings)) {
            return false;
        }
        int i = 0;
        while (i < quoteStrings.length) {
            if (str.startsWith(quoteStrings[i][0]) && str.endsWith(quoteStrings[i][1])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @NotNull
    public static String getUnQuotedIdentifier(@NotNull DBPDataSource dataSource, @NotNull String str) {
        return DBUtils.getUnQuotedIdentifier(str, dataSource.getSQLDialect().getIdentifierQuoteStrings());
    }

    @NotNull
    public static String getUnQuotedIdentifier(@NotNull String str, String[][] quoteStrings) {
        if (ArrayUtils.isEmpty((Object[])quoteStrings)) {
            quoteStrings = BasicSQLDialect.DEFAULT_IDENTIFIER_QUOTES;
        }
        int i = 0;
        while (i < quoteStrings.length) {
            str = DBUtils.getUnQuotedIdentifier(str, quoteStrings[i][0], quoteStrings[i][1]);
            ++i;
        }
        return str;
    }

    @NotNull
    public static String getUnQuotedIdentifier(@NotNull String str, @NotNull String quote) {
        return DBUtils.getUnQuotedIdentifier(str, quote, quote);
    }

    @NotNull
    public static String getUnQuotedIdentifier(@NotNull String str, @NotNull String quote1, @NotNull String quote2) {
        if (quote1 != null && quote2 != null && str.length() >= quote1.length() + quote2.length() && str.startsWith(quote1) && str.endsWith(quote2)) {
            return str.substring(quote1.length(), str.length() - quote2.length());
        }
        return str;
    }

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBPDataSource dataSource, @NotNull String str) {
        return DBUtils.getQuotedIdentifier(dataSource, str, true, false);
    }

    @NotNull
    public static String getQuotedIdentifier(@NotNull DBPDataSource dataSource, @NotNull String str, boolean caseSensitiveNames, boolean quoteAlways) {
        int i;
        boolean hasBadChars;
        if (DBUtils.isQuotedIdentifier(dataSource, str)) {
            return str;
        }
        SQLDialect sqlDialect = dataSource.getSQLDialect();
        String[][] quoteStrings = sqlDialect.getIdentifierQuoteStrings();
        if (ArrayUtils.isEmpty((Object[])quoteStrings)) {
            return str;
        }
        DBPKeywordType keywordType = sqlDialect.getKeywordType(str);
        boolean bl = hasBadChars = quoteAlways || (keywordType == DBPKeywordType.KEYWORD || keywordType == DBPKeywordType.TYPE) && sqlDialect.isQuoteReservedWords();
        if (!hasBadChars && !str.isEmpty()) {
            boolean bl2 = hasBadChars = !sqlDialect.validIdentifierStart(str.charAt(0));
        }
        if (!hasBadChars && caseSensitiveNames) {
            if (sqlDialect.storesUnquotedCase() == DBPIdentifierCase.UPPER) {
                hasBadChars = !str.equals(str.toUpperCase());
            } else if (sqlDialect.storesUnquotedCase() == DBPIdentifierCase.LOWER) {
                boolean bl3 = hasBadChars = !str.equals(str.toLowerCase());
            }
        }
        if (!hasBadChars && !str.isEmpty()) {
            i = 0;
            while (i < str.length()) {
                if (!sqlDialect.validIdentifierPart(str.charAt(i), false)) {
                    hasBadChars = true;
                    break;
                }
                ++i;
            }
        }
        if (!hasBadChars) {
            return str;
        }
        i = 0;
        while (i < quoteStrings.length) {
            String q1 = quoteStrings[i][0];
            String q2 = quoteStrings[i][1];
            if (q1.equals(q2) && (q1.equals("\"") || q1.equals("'")) && str.contains(q1)) {
                str = str.replace(q1, String.valueOf(q1) + q1);
            }
            ++i;
        }
        return String.valueOf(quoteStrings[0][0]) + str + quoteStrings[0][1];
    }

    @NotNull
    public static String getFullQualifiedName(@Nullable DBPDataSource dataSource, DBPNamedObject ... path) {
        StringBuilder name = new StringBuilder(20 * path.length);
        if (dataSource == null) {
            DBPNamedObject[] dBPNamedObjectArray = path;
            int n = path.length;
            int n2 = 0;
            while (n2 < n) {
                DBPNamedObject namePart = dBPNamedObjectArray[n2];
                if (name.length() > 0) {
                    name.append('.');
                }
                name.append(namePart.getName());
                ++n2;
            }
        } else {
            SQLDialect sqlDialect = dataSource.getSQLDialect();
            DBPNamedObject parent = null;
            DBPNamedObject[] dBPNamedObjectArray = path;
            int n = path.length;
            int n3 = 0;
            while (n3 < n) {
                DBPNamedObject namePart = dBPNamedObjectArray[n3];
                if (!(namePart == null || namePart instanceof DBSCatalog && (sqlDialect.getCatalogUsage() & 1) == 0 || namePart instanceof DBSSchema && (sqlDialect.getSchemaUsage() & 1) == 0 || !DBUtils.isValidObjectName(namePart.getName()))) {
                    if (name.length() > 0) {
                        if (parent instanceof DBSCatalog) {
                            if (!sqlDialect.isCatalogAtStart()) {
                                log.warn("Catalog name should be at the start of full-qualified name!");
                            }
                            name.append(sqlDialect.getCatalogSeparator());
                        } else {
                            name.append(sqlDialect.getStructSeparator());
                        }
                    }
                    name.append(DBUtils.getQuotedIdentifier(dataSource, namePart.getName()));
                    parent = namePart;
                }
                ++n3;
            }
        }
        return name.toString();
    }

    @NotNull
    public static String getSimpleQualifiedName(Object ... names) {
        StringBuilder name = new StringBuilder(names.length * 16);
        Object[] objectArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            Object namePart = objectArray[n2];
            if (namePart != null) {
                if (name.length() > 0 && name.charAt(name.length() - 1) != '.') {
                    name.append('.');
                }
                name.append(namePart);
            }
            ++n2;
        }
        return name.toString();
    }

    @NotNull
    public static String getFullyQualifiedName(@NotNull DBPDataSource dataSource, String ... names) {
        SQLDialect dialect = SQLUtils.getDialectFromDataSource(dataSource);
        StringBuilder name = new StringBuilder(names.length * 16);
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String namePart = stringArray[n2];
            if (namePart != null) {
                if (name.length() > 0) {
                    name.append(dialect.getStructSeparator());
                }
                name.append(DBUtils.getQuotedIdentifier(dataSource, namePart));
            }
            ++n2;
        }
        return name.toString();
    }

    public static boolean isValidObjectName(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (Character.isLetterOrDigit(name.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Nullable
    public static DBSObject getObjectByPath(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer rootSC, @Nullable String catalogName, @Nullable String schemaName, @Nullable String objectName) throws DBException {
        Class<? extends DBSObject> childType;
        if (!CommonUtils.isEmpty((String)catalogName) && (DBSSchema.class.isAssignableFrom(childType = rootSC.getChildType(monitor)) || DBSEntity.class.isAssignableFrom(childType))) {
            catalogName = null;
        }
        if (!CommonUtils.isEmpty((String)catalogName) && !CommonUtils.isEmpty((String)schemaName)) {
            DBSObject catalog = rootSC.getChild(monitor, catalogName);
            if (!(catalog instanceof DBSObjectContainer)) {
                return null;
            }
            rootSC = (DBSObjectContainer)catalog;
            DBSObject schema = rootSC.getChild(monitor, schemaName);
            if (!(schema instanceof DBSObjectContainer)) {
                return null;
            }
            rootSC = (DBSObjectContainer)schema;
        } else if (!CommonUtils.isEmpty((String)catalogName) || !CommonUtils.isEmpty((String)schemaName)) {
            String containerName = !CommonUtils.isEmpty((String)catalogName) ? catalogName : schemaName;
            DBSObject sc = rootSC.getChild(monitor, containerName);
            if (!(sc instanceof DBSObjectContainer)) {
                DBSObject selectedObject = DBUtils.getSelectedObject(executionContext);
                if (selectedObject instanceof DBSObjectContainer) {
                    sc = ((DBSObjectContainer)selectedObject).getChild(monitor, containerName);
                }
                if (!(sc instanceof DBSObjectContainer)) {
                    return null;
                }
            }
            rootSC = (DBSObjectContainer)sc;
        }
        if (objectName == null) {
            return rootSC;
        }
        DBSObject object = rootSC.getChild(monitor, objectName);
        if (object instanceof DBSEntity) {
            return object;
        }
        DBSObject selectedObject = DBUtils.getSelectedObject(executionContext);
        if (selectedObject instanceof DBSObjectContainer) {
            return ((DBSObjectContainer)selectedObject).getChild(monitor, objectName);
        }
        return object;
    }

    @Nullable
    public static DBSObject findNestedObject(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer parent, @NotNull List<String> names) throws DBException {
        int i = 0;
        while (i < names.size()) {
            String childName = names.get(i);
            DBSObject child = parent.getChild(monitor, childName);
            if (child == null) {
                executionContext.getContextDefaults();
                DBSObjectContainer container = DBUtils.getSelectedObject(executionContext, DBSObjectContainer.class);
                if (container != null) {
                    parent = container;
                    child = parent.getChild(monitor, childName);
                }
            }
            if (child == null) break;
            if (i == names.size() - 1) {
                return child;
            }
            if (!(child instanceof DBSObjectContainer)) break;
            parent = (DBSObjectContainer)child;
            ++i;
        }
        return null;
    }

    @Nullable
    public static <T extends DBPNamedObject> T findObject(@Nullable Collection<T> theList, String objectName) {
        return DBUtils.findObject(theList, objectName, false);
    }

    @Nullable
    public static <T extends DBPNamedObject> T findObject(@Nullable Collection<T> theList, String objectName, boolean caseInsensitive) {
        if (theList != null && !theList.isEmpty()) {
            for (DBPNamedObject object : theList) {
                if (!(caseInsensitive ? object.getName().equalsIgnoreCase(objectName) : object.getName().equals(objectName))) continue;
                return (T)object;
            }
        }
        return null;
    }

    @Nullable
    public static <T extends DBPNamedObject> T findObject(@Nullable T[] theList, String objectName) {
        if (theList != null && theList.length > 0) {
            T[] TArray = theList;
            int n = theList.length;
            int n2 = 0;
            while (n2 < n) {
                T object = TArray[n2];
                if (object.getName().equals(objectName)) {
                    return object;
                }
                ++n2;
            }
        }
        return null;
    }

    @Nullable
    public static <T extends DBPNamedObject> List<T> findObjects(@Nullable Collection<T> theList, @Nullable String objectName) {
        if (theList != null && !theList.isEmpty()) {
            ArrayList<DBPNamedObject> result = new ArrayList<DBPNamedObject>();
            for (DBPNamedObject object : theList) {
                if (!object.getName().equalsIgnoreCase(objectName)) continue;
                result.add(object);
            }
            return result;
        }
        return null;
    }

    @Nullable
    public static <T> T getAdapter(@NotNull Class<T> adapterType, @Nullable Object object) {
        if (object instanceof DBPDataSourceContainer) {
            object = ((DBPDataSourceContainer)object).getDataSource();
        }
        if (object == null) {
            return null;
        }
        if (adapterType.isAssignableFrom(object.getClass())) {
            return adapterType.cast(object);
        }
        if (object instanceof IAdaptable) {
            return (T)((IAdaptable)object).getAdapter(adapterType);
        }
        return null;
    }

    @Nullable
    public static <T> T getParentAdapter(@NotNull Class<T> i, DBSObject object) {
        if (object == null) {
            return null;
        }
        DBSObject parent = object.getParentObject();
        if (parent == null) {
            return null;
        }
        T adapter = DBUtils.getAdapter(i, parent);
        return adapter == object ? null : (T)adapter;
    }

    @Nullable
    public static <T> T getParentOfType(@NotNull Class<T> type, DBSObject object) {
        if (object == null) {
            return null;
        }
        DBSObject parent = object.getParentObject();
        while (parent != null) {
            if (type.isInstance(parent)) {
                return type.cast(parent);
            }
            if (parent instanceof DBPDataSource || parent instanceof DBPDataSourceContainer) break;
            parent = parent.getParentObject();
        }
        return null;
    }

    @NotNull
    public static DBSObject[] getObjectPath(@NotNull DBSObject object, boolean includeSelf) {
        DBSObject root;
        int depth = 0;
        DBSObject obj = root = includeSelf ? object : object.getParentObject();
        while (obj != null) {
            obj = DBUtils.getPublicObjectContainer(obj);
            ++depth;
            obj = obj.getParentObject();
        }
        DBSObject[] path = new DBSObject[depth];
        DBSObject obj2 = root;
        while (obj2 != null) {
            obj2 = DBUtils.getPublicObjectContainer(obj2);
            path[depth-- - 1] = obj2;
            obj2 = obj2.getParentObject();
        }
        return path;
    }

    public static String getObjectFullId(@NotNull DBSObject object) {
        DBSObject[] path = DBUtils.getObjectPath(object, true);
        StringBuilder pathStr = new StringBuilder();
        DBSObject[] dBSObjectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObject obj = dBSObjectArray[n2];
            if (pathStr.length() > 0) {
                pathStr.append('/');
            }
            if ((obj = DBUtils.getPublicObjectContainer(obj)) instanceof DBPDataSourceContainer) {
                pathStr.append(((DBPDataSourceContainer)obj).getId());
            } else {
                pathStr.append(obj.getName());
            }
            ++n2;
        }
        return pathStr.toString();
    }

    public static DBSObject findObjectById(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project, @NotNull String objectId) throws DBException {
        DBPDataSource dataSource;
        String[] names = objectId.split("/");
        DBPDataSourceContainer dataSourceContainer = project.getDataSourceRegistry().getDataSource(names[0]);
        if (dataSourceContainer == null) {
            log.debug("Can't find datasource '" + names[0] + "' in project " + project.getName());
            dataSourceContainer = DBUtils.findDataSource(names[0]);
            if (dataSourceContainer == null) {
                log.debug("Can't find datasource '" + names[0] + "' in any project");
                return null;
            }
        }
        if (names.length == 1) {
            return dataSourceContainer;
        }
        if (!dataSourceContainer.isConnected()) {
            dataSourceContainer.connect(monitor, true, true);
        }
        if ((dataSource = dataSourceContainer.getDataSource()) == null) {
            log.debug("Null datasource in container " + dataSourceContainer.getId());
            return null;
        }
        DBSObjectContainer sc = DBUtils.getAdapter(DBSObjectContainer.class, dataSource);
        if (sc != null) {
            int i = 1;
            while (i < names.length - 1) {
                String name = names[i];
                DBSObject child = sc.getChild(monitor, name);
                if (child == null) {
                    log.debug("Can't find child container " + name + " in container " + DBUtils.getObjectFullName(sc, DBPEvaluationContext.UI));
                    return null;
                }
                if (!(child instanceof DBSObjectContainer)) {
                    log.debug("Child object '" + name + "' is not a container");
                    return null;
                }
                sc = (DBSObjectContainer)child;
                ++i;
            }
        }
        if (sc != null) {
            String objectName = names[names.length - 1];
            DBSObject object = sc.getChild(monitor, objectName);
            if (object == null) {
                log.debug("Child object '" + objectName + "' not found in container " + DBUtils.getObjectFullName(sc, DBPEvaluationContext.UI));
                return null;
            }
            return object;
        }
        return null;
    }

    public static boolean isNullValue(@Nullable Object value) {
        return value == null || value instanceof DBDValue && ((DBDValue)value).isNull();
    }

    public static boolean isErrorValue(@Nullable Object value) {
        return value instanceof DBDValueError;
    }

    @Nullable
    public static Object makeNullValue(@NotNull DBCSession session, @NotNull DBDValueHandler valueHandler, @NotNull DBSTypedObject type) throws DBCException {
        return valueHandler.getValueFromObject(session, type, null, false);
    }

    @NotNull
    public static DBDAttributeBindingMeta getAttributeBinding(@NotNull DBSDataContainer dataContainer, @NotNull DBCSession session, @NotNull DBCAttributeMetaData attributeMeta) {
        return new DBDAttributeBindingMeta(dataContainer, session, attributeMeta);
    }

    @NotNull
    public static DBDAttributeBinding[] getAttributeBindings(@NotNull DBCSession session, @NotNull DBSDataContainer dataContainer, @NotNull DBCResultSetMetaData metaData) {
        List<DBCAttributeMetaData> metaAttributes = metaData.getAttributes();
        int columnsCount = metaAttributes.size();
        DBDAttributeBinding[] bindings = new DBDAttributeBinding[columnsCount];
        int i = 0;
        while (i < columnsCount) {
            bindings[i] = DBUtils.getAttributeBinding(dataContainer, session, metaAttributes.get(i));
            ++i;
        }
        return DBUtils.injectAndFilterAttributeBindings(session.getDataSource(), dataContainer, bindings, false);
    }

    public static DBDAttributeBinding[] injectAndFilterAttributeBindings(@NotNull DBPDataSource dataSource, @NotNull DBSDataContainer dataContainer, DBDAttributeBinding[] bindings, boolean filterAttributes) {
        List<DBVEntityAttribute> customAttributes;
        DBVEntity vEntity = DBVUtils.getVirtualEntity(dataContainer, false);
        if (vEntity != null && !CommonUtils.isEmpty(customAttributes = DBVUtils.getCustomAttributes(vEntity))) {
            DBDAttributeBinding[] customBindings = new DBDAttributeBinding[customAttributes.size()];
            int i = 0;
            while (i < customAttributes.size()) {
                customBindings[i] = new DBDAttributeBindingCustom(null, dataContainer, dataSource, customAttributes.get(i), bindings.length + i);
                ++i;
            }
            DBDAttributeBinding[] combinedAttrs = new DBDAttributeBinding[bindings.length + customBindings.length];
            System.arraycopy(bindings, 0, combinedAttrs, 0, bindings.length);
            System.arraycopy(customBindings, 0, combinedAttrs, bindings.length, customBindings.length);
            bindings = combinedAttrs;
        }
        if (filterAttributes && dataContainer instanceof DBDAttributeFilter) {
            return ((DBDAttributeFilter)dataContainer).filterAttributeBindings(bindings);
        }
        return bindings;
    }

    @NotNull
    public static DBDAttributeBinding[] makeLeafAttributeBindings(@NotNull DBCSession session, @NotNull DBSDataContainer dataContainer, @NotNull DBCResultSet resultSet) throws DBCException {
        ArrayList<DBDAttributeBinding> metaColumns = new ArrayList<DBDAttributeBinding>();
        List<DBCAttributeMetaData> attributes = resultSet.getMeta().getAttributes();
        if (attributes.size() == 1 && attributes.get(0).getDataKind() == DBPDataKind.DOCUMENT) {
            DBCAttributeMetaData attributeMeta = attributes.get(0);
            DBDAttributeBindingMeta docBinding = DBUtils.getAttributeBinding(dataContainer, session, attributeMeta);
            try {
                List<Object[]> sampleRows = Collections.emptyList();
                if (resultSet instanceof DBCResultSetSampleProvider) {
                    session.getProgressMonitor().subTask("Read sample rows");
                    sampleRows = ((DBCResultSetSampleProvider)resultSet).getSampleRows(session, 1000);
                }
                session.getProgressMonitor().subTask("Discover attribute structure");
                docBinding.lateBinding(session, sampleRows);
            }
            catch (Exception e) {
                log.error("Document attribute '" + docBinding.getName() + "' binding error", e);
            }
            List<DBDAttributeBinding> nested = docBinding.getNestedBindings();
            if (!CommonUtils.isEmpty(nested)) {
                metaColumns.addAll(nested);
            } else {
                try {
                    Collection<? extends DBSEntityAttribute> entityAttrs;
                    DBSEntity docEntity = DBUtils.getEntityFromMetaData(session.getProgressMonitor(), session.getExecutionContext(), attributeMeta.getEntityMetaData());
                    if (docEntity != null && !CommonUtils.isEmpty(entityAttrs = docEntity.getAttributes(session.getProgressMonitor()))) {
                        for (DBSEntityAttribute dBSEntityAttribute : entityAttrs) {
                            metaColumns.add(new DBDAttributeBindingType((DBDAttributeBinding)docBinding, dBSEntityAttribute));
                        }
                    }
                }
                catch (DBException e) {
                    log.debug("Error getting attributes from document entity", e);
                }
            }
        }
        if (metaColumns.isEmpty()) {
            for (DBCAttributeMetaData attribute : attributes) {
                DBDAttributeBindingMeta columnBinding = DBUtils.getAttributeBinding(dataContainer, session, attribute);
                metaColumns.add(columnBinding);
            }
        }
        ArrayList<DBDAttributeBinding> result = new ArrayList<DBDAttributeBinding>(metaColumns.size());
        for (DBDAttributeBinding binding : metaColumns) {
            DBUtils.addLeafBindings(result, binding);
        }
        return DBUtils.injectAndFilterAttributeBindings(session.getDataSource(), dataContainer, result.toArray(new DBDAttributeBinding[0]), true);
    }

    private static void addLeafBindings(List<DBDAttributeBinding> result, DBDAttributeBinding binding) {
        List<DBDAttributeBinding> nestedBindings = binding.getNestedBindings();
        if (CommonUtils.isEmpty(nestedBindings)) {
            result.add(binding);
        } else {
            for (DBDAttributeBinding nested : nestedBindings) {
                DBUtils.addLeafBindings(result, nested);
            }
        }
    }

    @Nullable
    public static Object getAttributeValue(@NotNull DBDAttributeBinding attribute, DBDAttributeBinding[] allAttributes, Object[] row) {
        if (attribute.isCustom()) {
            return DBVUtils.executeExpression(((DBDAttributeBindingCustom)attribute).getEntityAttribute(), allAttributes, row);
        }
        int depth = attribute.getLevel();
        if (depth == 0) {
            int index = attribute.getOrdinalPosition();
            if (index >= row.length) {
                log.debug("Bad attribute '" + attribute.getName() + "' index: " + index + " is out of row values' bounds (" + row.length + ")");
                return null;
            }
            return row[index];
        }
        Object curValue = row[attribute.getTopParent().getOrdinalPosition()];
        int i = 0;
        while (i < depth) {
            if (curValue == null) break;
            DBDAttributeBinding attr = attribute.getParent(depth - i - 1);
            assert (attr != null);
            try {
                curValue = attr.extractNestedValue(curValue);
            }
            catch (DBCException e) {
                log.debug("Error reading nested value of [" + attr.getName() + "]", e);
                curValue = null;
                break;
            }
            ++i;
        }
        return curValue;
    }

    @NotNull
    public static DBDValueHandler findValueHandler(@NotNull DBCSession session, @NotNull DBSTypedObject column) {
        return DBUtils.findValueHandler(session.getDataSource(), session, column);
    }

    @NotNull
    public static DBDValueHandler findValueHandler(@NotNull DBPDataSource dataSource, @NotNull DBSTypedObject column) {
        return DBUtils.findValueHandler(dataSource, dataSource.getContainer(), column);
    }

    @NotNull
    public static DBDValueHandler findValueHandler(@Nullable DBPDataSource dataSource, @Nullable DBDPreferences preferences, @NotNull DBSTypedObject column) {
        DBDValueHandler valueHandler = null;
        DBDValueHandlerProvider handlerProvider = DBUtils.getAdapter(DBDValueHandlerProvider.class, dataSource);
        if (handlerProvider != null && (valueHandler = handlerProvider.getValueHandler(dataSource, preferences, column)) != null) {
            return valueHandler;
        }
        if (dataSource != null && (handlerProvider = dataSource.getContainer().getPlatform().getValueHandlerRegistry().getValueHandlerProvider(dataSource, column)) != null) {
            valueHandler = handlerProvider.getValueHandler(dataSource, preferences, column);
        }
        if (valueHandler == null) {
            valueHandler = preferences == null ? DefaultValueHandler.INSTANCE : preferences.getDefaultValueHandler();
        }
        return valueHandler;
    }

    public static boolean isIdentifyingAssociation(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAssociation association) throws DBException {
        if (!(association instanceof DBSEntityReferrer)) {
            return false;
        }
        DBSEntityReferrer referrer = (DBSEntityReferrer)((Object)association);
        DBSEntity refEntity = association.getAssociatedEntity();
        DBSEntity ownerEntity = association.getParentObject();
        assert (ownerEntity != null);
        if (refEntity == ownerEntity) {
            return false;
        }
        List<DBSEntityAttribute> ownAttrs = DBUtils.getEntityAttributes(monitor, referrer);
        Collection<? extends DBSEntityConstraint> constraints = ownerEntity.getConstraints(monitor);
        if (constraints != null) {
            boolean hasPrimaryKey = false;
            for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                if (dBSEntityConstraint.getConstraintType() != DBSEntityConstraintType.PRIMARY_KEY) continue;
                hasPrimaryKey = true;
                break;
            }
            for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                if (!(dBSEntityConstraint instanceof DBSEntityReferrer) || (!hasPrimaryKey || dBSEntityConstraint.getConstraintType() != DBSEntityConstraintType.PRIMARY_KEY) && (hasPrimaryKey || !dBSEntityConstraint.getConstraintType().isUnique())) continue;
                List<DBSEntityAttribute> constAttrs = DBUtils.getEntityAttributes(monitor, (DBSEntityReferrer)dBSEntityConstraint);
                boolean included = true;
                for (DBSEntityAttribute attr : ownAttrs) {
                    if (constAttrs.contains(attr)) continue;
                    included = false;
                    break;
                }
                if (!included) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String getDefaultDataTypeName(@NotNull DBSObject objectContainer, DBPDataKind dataKind) {
        if (objectContainer instanceof DBPDataTypeProvider) {
            return ((DBPDataTypeProvider)((Object)objectContainer)).getDefaultDataTypeName(dataKind);
        }
        return "?";
    }

    @Nullable
    public static DBDAttributeBinding findBinding(@NotNull Collection<DBDAttributeBinding> bindings, @NotNull DBSAttributeBase attribute) {
        for (DBDAttributeBinding binding : bindings) {
            DBDAttributeBinding subBinding;
            if (binding.matches(attribute, true)) {
                return binding;
            }
            List<DBDAttributeBinding> nestedBindings = binding.getNestedBindings();
            if (nestedBindings == null || (subBinding = DBUtils.findBinding(nestedBindings, attribute)) == null) continue;
            return subBinding;
        }
        return null;
    }

    @Nullable
    public static DBDAttributeBinding findBinding(@NotNull DBDAttributeBinding[] bindings, @Nullable DBSAttributeBase attribute) {
        if (attribute == null) {
            return null;
        }
        DBDAttributeBinding[] dBDAttributeBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding subBinding;
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            if (binding.matches(attribute, true)) {
                return binding;
            }
            List<DBDAttributeBinding> nestedBindings = binding.getNestedBindings();
            if (nestedBindings != null && (subBinding = DBUtils.findBinding(nestedBindings, attribute)) != null) {
                return subBinding;
            }
            ++n2;
        }
        return null;
    }

    @NotNull
    public static List<DBSEntityReferrer> getAttributeReferrers(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAttribute entityAttribute, boolean includeVirtual) throws DBException {
        Collection<DBSEntityAssociation> associations;
        DBSEntity entity = entityAttribute.getParentObject();
        Collection<DBSEntityAssociation> collection = associations = includeVirtual ? DBVUtils.getAllAssociations(monitor, entity) : entity.getAssociations(monitor);
        if (associations != null) {
            ArrayList<DBSEntityReferrer> refs = new ArrayList<DBSEntityReferrer>();
            for (DBSEntityAssociation fk : associations) {
                if (!(fk instanceof DBSEntityReferrer) || DBUtils.getConstraintAttribute(monitor, (DBSEntityReferrer)((Object)fk), entityAttribute) == null) continue;
                refs.add((DBSEntityReferrer)((Object)fk));
            }
            return refs;
        }
        return Collections.emptyList();
    }

    @NotNull
    public static Collection<? extends DBSEntityAttribute> getBestTableIdentifier(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity) throws DBException {
        Collection<? extends DBSEntityConstraint> uniqueKeys;
        if (entity instanceof DBSTable && ((DBSTable)entity).isView()) {
            return Collections.emptyList();
        }
        if (CommonUtils.isEmpty(entity.getAttributes(monitor))) {
            return Collections.emptyList();
        }
        ArrayList<DBSEntityConstraint> identifiers = new ArrayList<DBSEntityConstraint>();
        ArrayList<DBSEntityConstraint> nonIdentifyingConstraints = null;
        if (entity instanceof DBSTable) {
            try {
                Collection<? extends DBSTableIndex> indexes = ((DBSTable)entity).getIndexes(monitor);
                if (!CommonUtils.isEmpty(indexes)) {
                    for (DBSTableIndex dBSTableIndex : indexes) {
                        if (!DBUtils.isIdentifierIndex(monitor, dBSTableIndex)) continue;
                        identifiers.add(dBSTableIndex);
                    }
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        if (identifiers.isEmpty() && (uniqueKeys = entity.getConstraints(monitor)) != null) {
            for (DBSEntityConstraint dBSEntityConstraint : uniqueKeys) {
                if (DBUtils.isIdentifierConstraint(monitor, dBSEntityConstraint)) {
                    identifiers.add(dBSEntityConstraint);
                    continue;
                }
                if (nonIdentifyingConstraints == null) {
                    nonIdentifyingConstraints = new ArrayList<DBSEntityConstraint>();
                }
                nonIdentifyingConstraints.add(dBSEntityConstraint);
            }
        }
        if (!identifiers.isEmpty()) {
            DBSEntityConstraint uniqueId = null;
            for (DBSEntityConstraint dBSEntityConstraint : identifiers) {
                if (dBSEntityConstraint instanceof DBSEntityReferrer && dBSEntityConstraint.getConstraintType() == DBSEntityConstraintType.PRIMARY_KEY) {
                    return DBUtils.getEntityAttributes(monitor, (DBSEntityReferrer)dBSEntityConstraint);
                }
                if (dBSEntityConstraint.getConstraintType().isUnique()) {
                    uniqueId = dBSEntityConstraint;
                    continue;
                }
                if (!(dBSEntityConstraint instanceof DBSTableIndex) || !((DBSTableIndex)dBSEntityConstraint).isUnique()) continue;
                uniqueId = dBSEntityConstraint;
            }
            return uniqueId instanceof DBSEntityReferrer ? DBUtils.getEntityAttributes(monitor, (DBSEntityReferrer)uniqueId) : Collections.emptyList();
        }
        if (nonIdentifyingConstraints != null) {
            return DBUtils.getEntityAttributes(monitor, (DBSEntityReferrer)nonIdentifyingConstraints.get(0));
        }
        return Collections.emptyList();
    }

    public static boolean isIdentifierIndex(DBRProgressMonitor monitor, DBSTableIndex index) throws DBException {
        if (!index.isUnique()) {
            return false;
        }
        List<? extends DBSTableIndexColumn> attrs = index.getAttributeReferences(monitor);
        if (attrs == null || attrs.isEmpty()) {
            return false;
        }
        for (DBSTableIndexColumn dBSTableIndexColumn : attrs) {
            if (dBSTableIndexColumn.getTableColumn() != null && dBSTableIndexColumn.getTableColumn().isRequired()) continue;
            return false;
        }
        return true;
    }

    public static boolean isIdentifierConstraint(DBRProgressMonitor monitor, DBSEntityConstraint constraint) throws DBException {
        if (constraint.getConstraintType().isUnique()) {
            if (constraint instanceof DBSEntityReferrer) {
                List<? extends DBSEntityAttributeRef> attrs = ((DBSEntityReferrer)constraint).getAttributeReferences(monitor);
                if (attrs == null || attrs.isEmpty()) {
                    return false;
                }
                for (DBSEntityAttributeRef dBSEntityAttributeRef : attrs) {
                    if (dBSEntityAttributeRef.getAttribute() != null && dBSEntityAttributeRef.getAttribute().isRequired()) continue;
                    return false;
                }
                return true;
            }
            return true;
        }
        return false;
    }

    public static DBSEntityConstraint findEntityConstraint(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntity entity, @NotNull Collection<? extends DBSEntityAttribute> attributes) throws DBException {
        Collection<? extends DBSTableIndex> collection;
        Collection<? extends DBSEntityConstraint> constraints = entity.getConstraints(monitor);
        if (!CommonUtils.isEmpty(constraints)) {
            for (DBSEntityConstraint dBSEntityConstraint : constraints) {
                if (!(dBSEntityConstraint instanceof DBSEntityReferrer) || !DBUtils.referrerMatches(monitor, (DBSEntityReferrer)dBSEntityConstraint, attributes)) continue;
                return dBSEntityConstraint;
            }
        }
        if (entity instanceof DBSTable && !CommonUtils.isEmpty(collection = ((DBSTable)entity).getIndexes(monitor))) {
            for (DBSTableIndex dBSTableIndex : collection) {
                if (!dBSTableIndex.isUnique() || !DBUtils.referrerMatches(monitor, dBSTableIndex, attributes)) continue;
                return dBSTableIndex;
            }
        }
        return null;
    }

    public static boolean referrerMatches(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityReferrer referrer, @NotNull Collection<? extends DBSEntityAttribute> attributes) throws DBException {
        List<? extends DBSEntityAttributeRef> refs = referrer.getAttributeReferences(monitor);
        if (refs != null && !refs.isEmpty()) {
            Iterator<? extends DBSEntityAttribute> attrIterator = attributes.iterator();
            for (DBSEntityAttributeRef dBSEntityAttributeRef : refs) {
                if (!attrIterator.hasNext()) {
                    return false;
                }
                if (dBSEntityAttributeRef.getAttribute() != null && CommonUtils.equalObjects((Object)dBSEntityAttributeRef.getAttribute().getName(), (Object)attrIterator.next().getName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static List<DBSEntityAttribute> getEntityAttributes(@NotNull DBRProgressMonitor monitor, @Nullable DBSEntityReferrer referrer) {
        try {
            DBSEntity realEntity;
            if (referrer instanceof DBVEntityConstraint && ((DBVEntityConstraint)referrer).isUseAllColumns() && (realEntity = ((DBVEntityConstraint)referrer).getEntity().getRealEntity(monitor)) != null) {
                Collection<? extends DBSEntityAttribute> attributes = realEntity.getAttributes(monitor);
                return attributes == null ? Collections.emptyList() : new ArrayList<DBSEntityAttribute>(attributes);
            }
        }
        catch (DBException e) {
            log.error("Error discovering virtual constraint attributes", e);
        }
        List<? extends DBSEntityAttributeRef> constraintColumns = null;
        if (referrer != null) {
            try {
                constraintColumns = referrer.getAttributeReferences(monitor);
            }
            catch (DBException e) {
                log.warn("Error reading reference attributes", e);
            }
        }
        if (constraintColumns == null) {
            return Collections.emptyList();
        }
        ArrayList<DBSEntityAttribute> attributes = new ArrayList<DBSEntityAttribute>(constraintColumns.size());
        for (DBSEntityAttributeRef dBSEntityAttributeRef : constraintColumns) {
            DBSEntityAttribute attribute = dBSEntityAttributeRef.getAttribute();
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    @Nullable
    public static DBSEntityAttributeRef getConstraintAttribute(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityReferrer constraint, @NotNull DBSEntityAttribute tableColumn) throws DBException {
        List<? extends DBSEntityAttributeRef> columns = constraint.getAttributeReferences(monitor);
        if (columns != null) {
            for (DBSEntityAttributeRef dBSEntityAttributeRef : columns) {
                if (dBSEntityAttributeRef.getAttribute() != tableColumn) continue;
                return dBSEntityAttributeRef;
            }
        }
        return null;
    }

    @Nullable
    public static DBSEntityAttributeRef getConstraintAttribute(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityReferrer constraint, @NotNull String columnName) throws DBException {
        List<? extends DBSEntityAttributeRef> columns = constraint.getAttributeReferences(monitor);
        if (columns != null) {
            for (DBSEntityAttributeRef dBSEntityAttributeRef : columns) {
                DBSEntityAttribute attribute = dBSEntityAttributeRef.getAttribute();
                if (attribute == null || !attribute.getName().equals(columnName)) continue;
                return dBSEntityAttributeRef;
            }
        }
        return null;
    }

    @Nullable
    public static DBSEntityAttribute getReferenceAttribute(@NotNull DBRProgressMonitor monitor, @NotNull DBSEntityAssociation association, @NotNull DBSEntityAttribute tableColumn, boolean reference) throws DBException {
        DBSEntityConstraint refConstr = association.getReferencedConstraint();
        if (association instanceof DBSEntityReferrer && refConstr instanceof DBSEntityReferrer) {
            List<? extends DBSEntityAttributeRef> ownAttrs = ((DBSEntityReferrer)((Object)association)).getAttributeReferences(monitor);
            List<? extends DBSEntityAttributeRef> refAttrs = ((DBSEntityReferrer)refConstr).getAttributeReferences(monitor);
            if (ownAttrs == null || refAttrs == null || ownAttrs.size() != refAttrs.size()) {
                log.error("Invalid internal state of referrer association");
                return null;
            }
            Iterator ownIterator = ownAttrs.iterator();
            Iterator refIterator = refAttrs.iterator();
            while (ownIterator.hasNext()) {
                DBSEntityAttributeRef ownAttr = (DBSEntityAttributeRef)ownIterator.next();
                if (reference ? ownAttr instanceof DBSTableForeignKeyColumn && ((DBSTableForeignKeyColumn)ownAttr).getReferencedColumn() == tableColumn : ownAttr.getAttribute() == tableColumn) {
                    return ((DBSEntityAttributeRef)refIterator.next()).getAttribute();
                }
                refIterator.next();
            }
        }
        return null;
    }

    @NotNull
    public static DBCStatement makeStatement(@NotNull DBCExecutionSource executionSource, @NotNull DBCSession session, @NotNull DBCStatementType statementType, @NotNull String query, long offset, long maxRows) throws DBCException {
        SQLQuery sqlQuery = new SQLQuery(session.getDataSource(), query);
        return DBUtils.makeStatement(executionSource, session, statementType, sqlQuery, offset, maxRows);
    }

    @NotNull
    public static DBCStatement makeStatement(@NotNull DBCExecutionSource executionSource, @NotNull DBCSession session, @NotNull DBCStatementType statementType, @NotNull SQLQuery sqlQuery, long offset, long maxRows) throws DBCException {
        String queryText;
        DBCQueryTransformProvider transformProvider;
        boolean selectQuery = sqlQuery.getType() == SQLQueryType.SELECT && sqlQuery.isPlainSelect();
        boolean hasLimits = (offset > 0L || selectQuery) && maxRows > 0L;
        boolean possiblySelect = sqlQuery.getType() == SQLQueryType.SELECT || sqlQuery.getType() == SQLQueryType.UNKNOWN;
        boolean limitAffectsDML = Boolean.TRUE.equals(session.getDataSource().getDataSourceFeature("datasource.limit-affects-dml"));
        DBCQueryTransformer limitTransformer = null;
        DBCQueryTransformer fetchAllTransformer = null;
        if (selectQuery && (transformProvider = DBUtils.getAdapter(DBCQueryTransformProvider.class, session.getDataSource())) != null) {
            if (hasLimits) {
                if (session.getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.maxrows.sql")) {
                    limitTransformer = transformProvider.createQueryTransformer(DBCQueryTransformType.RESULT_SET_LIMIT);
                }
            } else {
                fetchAllTransformer = transformProvider.createQueryTransformer(DBCQueryTransformType.FETCH_ALL_TABLE);
            }
        }
        try {
            if (hasLimits && limitTransformer != null) {
                limitTransformer.setParameters(offset, maxRows);
                queryText = limitTransformer.transformQueryString(sqlQuery);
            } else {
                queryText = fetchAllTransformer != null ? fetchAllTransformer.transformQueryString(sqlQuery) : sqlQuery.getText();
            }
        }
        catch (Exception e) {
            log.debug("Error transforming SQL query", e);
            queryText = sqlQuery.getText();
        }
        DBCStatement dbStat = statementType == DBCStatementType.SCRIPT ? DBUtils.createStatement(session, queryText, hasLimits) : DBUtils.makeStatement(session, queryText, hasLimits);
        dbStat.setStatementSource(executionSource);
        if (offset > 0L || hasLimits || possiblySelect && maxRows > 0L && !limitAffectsDML) {
            if (limitTransformer == null) {
                dbStat.setLimit(offset, maxRows);
            } else {
                limitTransformer.transformStatement(dbStat, 0);
            }
        } else if (fetchAllTransformer != null) {
            fetchAllTransformer.transformStatement(dbStat, 0);
        }
        return dbStat;
    }

    @NotNull
    public static DBCStatement createStatement(@NotNull DBCSession session, @NotNull String query, boolean scrollable) throws DBCException {
        SQLDialect dialect = SQLUtils.getDialectFromObject(session.getDataSource());
        DBCStatementType statementType = DBCStatementType.SCRIPT;
        query = SQLUtils.makeUnifiedLineFeeds(session.getDataSource(), query);
        if (SQLUtils.isExecQuery(dialect, query)) {
            statementType = DBCStatementType.EXEC;
            query = dialect.formatStoredProcedureCall(session.getDataSource(), query);
        }
        return session.prepareStatement(statementType, query, scrollable && session.getDataSource().getInfo().supportsResultSetScroll(), false, false);
    }

    @NotNull
    public static DBCStatement makeStatement(@NotNull DBCSession session, @NotNull String query, boolean scrollable) throws DBCException {
        DBCStatementType statementType = DBCStatementType.QUERY;
        query = SQLUtils.makeUnifiedLineFeeds(session.getDataSource(), query);
        if (SQLUtils.isExecQuery(SQLUtils.getDialectFromObject(session.getDataSource()), query)) {
            statementType = DBCStatementType.EXEC;
        }
        return session.prepareStatement(statementType, query, scrollable && session.getDataSource().getInfo().supportsResultSetScroll(), false, false);
    }

    public static void fireObjectUpdate(@NotNull DBSObject object) {
        DBUtils.fireObjectUpdate(object, null, null);
    }

    public static void fireObjectUpdate(DBSObject object, boolean enabled) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            container.fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, object, enabled));
        }
    }

    public static void fireObjectUpdate(DBSObject object, @Nullable Map<String, Object> options, @Nullable Object data) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            DBPEvent event = new DBPEvent(DBPEvent.Action.OBJECT_UPDATE, object, data);
            event.setOptions(options);
            container.fireEvent(event);
        }
    }

    public static void fireObjectUpdate(DBSObject object, @Nullable Object data) {
        DBUtils.fireObjectUpdate(object, null, data);
    }

    public static void fireObjectAdd(DBSObject object, Map<String, Object> options) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            DBPEvent event = new DBPEvent(DBPEvent.Action.OBJECT_ADD, object);
            event.setOptions(options);
            container.fireEvent(event);
        }
    }

    public static void fireObjectRemove(DBSObject object) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            container.fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_REMOVE, object));
        }
    }

    public static void fireObjectSelect(DBSObject object, boolean select) {
        DBPDataSourceContainer container = DBUtils.getContainer(object);
        if (container != null) {
            container.fireEvent(new DBPEvent(DBPEvent.Action.OBJECT_SELECT, object, select));
        }
    }

    public static void fireObjectRefresh(DBSObject object) {
        DBUtils.fireObjectSelect(object, true);
    }

    @NotNull
    public static String getObjectUniqueName(@NotNull DBSObject object) {
        if (object instanceof DBPUniqueObject) {
            return ((DBPUniqueObject)((Object)object)).getUniqueName();
        }
        return object.getName();
    }

    @Nullable
    public static DBSDataType findBestDataType(@NotNull Collection<? extends DBSDataType> allTypes, String ... typeNames) {
        String[] stringArray = typeNames;
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String testType = stringArray[n2];
            for (DBSDataType dBSDataType : allTypes) {
                if (!dBSDataType.getName().equalsIgnoreCase(testType)) continue;
                return dBSDataType;
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    public static DBSDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String fullTypeName) throws DBException {
        DBPDataTypeProvider dataTypeProvider = DBUtils.getAdapter(DBPDataTypeProvider.class, dataSource);
        if (dataTypeProvider == null) {
            return null;
        }
        return dataTypeProvider.resolveDataType(monitor, fullTypeName);
    }

    @Nullable
    public static DBSDataType getLocalDataType(@NotNull DBPDataSource dataSource, @NotNull String fullTypeName) {
        DBPDataTypeProvider dataTypeProvider = DBUtils.getAdapter(DBPDataTypeProvider.class, dataSource);
        if (dataTypeProvider == null) {
            return null;
        }
        return dataTypeProvider.getLocalDataType(fullTypeName);
    }

    public static DBPObject getPublicObject(@Nullable DBPObject object) {
        if (object instanceof DBPDataSourceContainer) {
            return ((DBPDataSourceContainer)object).getDataSource();
        }
        return object;
    }

    public static DBSObject getPublicObjectContainer(@NotNull DBSObject object) {
        if (object instanceof DBPDataSource) {
            return ((DBPDataSource)object).getContainer();
        }
        return object;
    }

    @Nullable
    public static DBPDataSourceContainer getContainer(@Nullable DBSObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DBPDataSourceContainer) {
            return (DBPDataSourceContainer)object;
        }
        DBPDataSource dataSource = object.getDataSource();
        return dataSource == null ? null : dataSource.getContainer();
    }

    @NotNull
    public static DBPDataSourceRegistry getObjectRegistry(@NotNull DBSObject object) {
        DBPDataSourceContainer container;
        if (object instanceof DBPDataSourceContainer) {
            container = (DBPDataSourceContainer)object;
        } else {
            DBPDataSource dataSource = object.getDataSource();
            container = dataSource.getContainer();
        }
        return container.getRegistry();
    }

    @NotNull
    public static DBPProject getObjectOwnerProject(DBSObject object) {
        return DBUtils.getObjectRegistry(object).getProject();
    }

    @NotNull
    public static String getObjectShortName(Object object) {
        String strValue = object instanceof DBPNamedObject ? ((DBPNamedObject)object).getName() : String.valueOf(object);
        return strValue;
    }

    @NotNull
    public static String getObjectFullName(@NotNull DBPNamedObject object, DBPEvaluationContext context) {
        if (object instanceof DBPQualifiedObject) {
            return ((DBPQualifiedObject)((Object)object)).getFullyQualifiedName(context);
        }
        if (object instanceof DBSObject) {
            return DBUtils.getObjectFullName(((DBSObject)object).getDataSource(), object, context);
        }
        return object.getName();
    }

    @NotNull
    public static String getObjectFullName(@NotNull DBPDataSource dataSource, @NotNull DBPNamedObject object, DBPEvaluationContext context) {
        if (object instanceof DBPQualifiedObject) {
            return ((DBPQualifiedObject)((Object)object)).getFullyQualifiedName(context);
        }
        return DBUtils.getQuotedIdentifier(dataSource, object.getName());
    }

    @NotNull
    public static String getFullTypeName(@NotNull DBSTypedObject typedObject) {
        DBSObject structObject = DBUtils.getFromObject(typedObject);
        DBPDataSource dataSource = structObject == null ? null : structObject.getDataSource();
        String typeName = typedObject.getTypeName();
        String typeModifiers = SQLUtils.getColumnTypeModifiers(dataSource, typedObject, typeName, typedObject.getDataKind());
        return typeModifiers == null ? typeName : String.valueOf(typeName) + typeModifiers;
    }

    public static void releaseValue(@Nullable Object value) {
        if (value instanceof DBDValue) {
            ((DBDValue)value).release();
        }
    }

    public static void resetValue(@Nullable Object value) {
        if (value instanceof DBDContent) {
            ((DBDContent)value).resetContents();
        }
    }

    @NotNull
    public static DBCLogicalOperator[] getAttributeOperators(DBSTypedObject attribute) {
        DBSDataType dataType;
        if (attribute instanceof DBSTypedObjectEx && (dataType = ((DBSTypedObjectEx)((Object)attribute)).getDataType()) != null) {
            return dataType.getSupportedOperators(attribute);
        }
        return DBUtils.getDefaultOperators(attribute);
    }

    @NotNull
    public static DBCLogicalOperator[] getDefaultOperators(DBSTypedObject attribute) {
        ArrayList<DBCLogicalOperator> operators = new ArrayList<DBCLogicalOperator>();
        DBPDataKind dataKind = attribute.getDataKind();
        if (attribute instanceof DBSAttributeBase && !((DBSAttributeBase)attribute).isRequired()) {
            operators.add(DBCLogicalOperator.IS_NULL);
            operators.add(DBCLogicalOperator.IS_NOT_NULL);
        }
        if (dataKind == DBPDataKind.BOOLEAN || dataKind == DBPDataKind.ROWID || dataKind == DBPDataKind.OBJECT || dataKind == DBPDataKind.BINARY) {
            operators.add(DBCLogicalOperator.EQUALS);
            operators.add(DBCLogicalOperator.NOT_EQUALS);
        } else if (dataKind == DBPDataKind.NUMERIC || dataKind == DBPDataKind.DATETIME || dataKind == DBPDataKind.STRING) {
            operators.add(DBCLogicalOperator.EQUALS);
            operators.add(DBCLogicalOperator.NOT_EQUALS);
            operators.add(DBCLogicalOperator.GREATER);
            operators.add(DBCLogicalOperator.LESS);
            operators.add(DBCLogicalOperator.IN);
        }
        if (dataKind == DBPDataKind.STRING) {
            operators.add(DBCLogicalOperator.LIKE);
        }
        return operators.toArray(new DBCLogicalOperator[0]);
    }

    public static Object getRawValue(Object value) {
        if (value instanceof DBDValue) {
            return ((DBDValue)value).getRawValue();
        }
        return value;
    }

    public static DBSTableIndex findAttributeIndex(DBRProgressMonitor monitor, DBSEntityAttribute attribute) throws DBException {
        Collection<? extends DBSTableIndex> indexes;
        DBSEntity entity = attribute.getParentObject();
        if (entity instanceof DBSTable && !CommonUtils.isEmpty(indexes = ((DBSTable)entity).getIndexes(monitor))) {
            for (DBSTableIndex dBSTableIndex : indexes) {
                if (DBUtils.getConstraintAttribute(monitor, (DBSEntityReferrer)dBSTableIndex, attribute) == null) continue;
                return dBSTableIndex;
            }
        }
        return null;
    }

    @Nullable
    public static DBCTransactionManager getTransactionManager(@Nullable DBCExecutionContext executionContext) {
        if (executionContext != null && executionContext.isConnected()) {
            return DBUtils.getAdapter(DBCTransactionManager.class, executionContext);
        }
        return null;
    }

    @NotNull
    public static <T> Class<T> getDriverClass(@NotNull DBPDataSource dataSource, @NotNull String className) throws ClassNotFoundException {
        return Class.forName(className, true, dataSource.getContainer().getDriver().getClassLoader());
    }

    @NotNull
    public static <T extends DBCSession> T openMetaSession(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @NotNull String task) {
        return (T)DBUtils.getDefaultContext(object, true).openSession(monitor, DBCExecutionPurpose.META, task);
    }

    @NotNull
    public static <T extends DBCSession> T openMetaSession(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, @NotNull String task) {
        return (T)dataSource.getDefaultInstance().getDefaultContext(monitor, true).openSession(monitor, DBCExecutionPurpose.META, task);
    }

    @NotNull
    public static <T extends DBCSession> T openUtilSession(@NotNull DBRProgressMonitor monitor, @NotNull DBSObject object, @NotNull String task) {
        return (T)DBUtils.getDefaultContext(object, false).openSession(monitor, DBCExecutionPurpose.UTIL, task);
    }

    @Nullable
    public static DBSObject getFromObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof DBSWrapper) {
            return ((DBSWrapper)object).getObject();
        }
        if (object instanceof DBSObject) {
            return (DBSObject)object;
        }
        return RuntimeUtils.getObjectAdapter(object, DBSObject.class);
    }

    public static boolean isAtomicParameter(Object o) {
        return o == null || o instanceof CharSequence || o instanceof Number || o instanceof Date || o instanceof Boolean;
    }

    @NotNull
    public static DBSObject getDefaultOrActiveObject(@NotNull DBSInstance object) {
        DBCExecutionContext defaultContext = DBUtils.getDefaultContext(object, true);
        DBSObject activeObject = defaultContext == null ? null : DBUtils.getActiveInstanceObject(defaultContext);
        return activeObject == null ? object.getDataSource() : activeObject;
    }

    @Nullable
    public static DBSObject getActiveInstanceObject(@NotNull DBCExecutionContext executionContext) {
        return DBUtils.getSelectedObject(executionContext);
    }

    @Nullable
    public static DBSObject getSelectedObject(@NotNull DBCExecutionContext context) {
        DBCExecutionContextDefaults contextDefaults = context.getContextDefaults();
        if (contextDefaults != null) {
            Object defaultSchema = contextDefaults.getDefaultSchema();
            if (defaultSchema != null) {
                return defaultSchema;
            }
            Object defaultCatalog = contextDefaults.getDefaultCatalog();
            if (defaultCatalog != null) {
                return defaultCatalog;
            }
        }
        return null;
    }

    @Nullable
    public static <T> T getSelectedObject(@NotNull DBCExecutionContext context, Class<T> theClass) {
        DBSObject selectedObject = DBUtils.getSelectedObject(context);
        if (theClass.isInstance(selectedObject)) {
            return theClass.cast(selectedObject);
        }
        return null;
    }

    @NotNull
    public static DBSObject[] getSelectedObjects(DBRProgressMonitor monitor, @NotNull DBCExecutionContext context) {
        DBCExecutionContextDefaults contextDefaults = context.getContextDefaults();
        if (contextDefaults != null) {
            Object defaultCatalog = contextDefaults.getDefaultCatalog();
            Object defaultSchema = contextDefaults.getDefaultSchema();
            if (defaultCatalog != null && defaultSchema != null) {
                return new DBSObject[]{defaultCatalog, defaultSchema};
            }
            if (defaultCatalog != null) {
                return new DBSObject[]{defaultCatalog};
            }
            if (defaultSchema != null) {
                return new DBSObject[]{defaultSchema};
            }
        }
        return new DBSObject[0];
    }

    public static void refreshContextDefaultsAndReflect(DBRProgressMonitor monitor, DBCExecutionContextDefaults contextDefaults) {
        try {
            Object defaultCatalog = contextDefaults.getDefaultCatalog();
            Object defaultSchema = contextDefaults.getDefaultSchema();
            if (contextDefaults.refreshDefaults(monitor, false)) {
                DBUtils.fireObjectSelectionChange(defaultCatalog, contextDefaults.getDefaultCatalog());
                DBUtils.fireObjectSelectionChange(defaultSchema, contextDefaults.getDefaultSchema());
            }
        }
        catch (Exception e) {
            log.debug(e);
        }
    }

    public static void fireObjectSelectionChange(DBSObject oldDefaultObject, DBSObject newDefaultObject) {
        if (oldDefaultObject != newDefaultObject) {
            if (oldDefaultObject != null) {
                DBUtils.fireObjectSelect(oldDefaultObject, false);
            }
            if (newDefaultObject != null) {
                DBUtils.fireObjectSelect(newDefaultObject, true);
            }
        }
    }

    public static DBSObjectContainer getChangeableObjectContainer(DBCExecutionContextDefaults contextDefaults, DBSObjectContainer root, Class<? extends DBSObject> childType) {
        if (contextDefaults == null) {
            return null;
        }
        if (childType == DBSCatalog.class && contextDefaults.supportsCatalogChange()) {
            return root;
        }
        if (childType == DBSSchema.class && contextDefaults.supportsSchemaChange()) {
            Object defaultCatalog = contextDefaults.getDefaultCatalog();
            if (defaultCatalog != null) {
                return defaultCatalog;
            }
            return root;
        }
        return null;
    }

    public static boolean isHiddenObject(Object object) {
        return object instanceof DBPHiddenObject && ((DBPHiddenObject)object).isHidden();
    }

    public static boolean isInheritedObject(Object object) {
        return object instanceof DBPInheritedObject && ((DBPInheritedObject)object).isInherited();
    }

    public static DBDPseudoAttribute getRowIdAttribute(DBSEntity entity) {
        if (entity instanceof DBDPseudoAttributeContainer) {
            try {
                return DBDPseudoAttribute.getAttribute(((DBDPseudoAttributeContainer)((Object)entity)).getPseudoAttributes(), DBDPseudoAttributeType.ROWID);
            }
            catch (DBException e) {
                log.warn("Can't get pseudo attributes for '" + entity.getName() + "'", e);
            }
        }
        return null;
    }

    public static boolean isRowIdAttribute(DBSEntityAttribute attr) {
        DBDPseudoAttribute rowIdAttribute = DBUtils.getRowIdAttribute(attr.getParentObject());
        return rowIdAttribute != null && rowIdAttribute.getName().equals(attr.getName());
    }

    public static DBDPseudoAttribute getPseudoAttribute(DBSEntity entity, String attrName) {
        if (entity instanceof DBDPseudoAttributeContainer) {
            try {
                DBDPseudoAttribute[] pseudoAttributes = ((DBDPseudoAttributeContainer)((Object)entity)).getPseudoAttributes();
                if (pseudoAttributes != null && pseudoAttributes.length > 0) {
                    DBDPseudoAttribute[] dBDPseudoAttributeArray = pseudoAttributes;
                    int n = pseudoAttributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DBDPseudoAttribute pa = dBDPseudoAttributeArray[n2];
                        String attrId = pa.getAlias();
                        if (CommonUtils.isEmpty((String)attrId)) {
                            attrId = pa.getName();
                        }
                        if (attrId.equals(attrName)) {
                            return pa;
                        }
                        ++n2;
                    }
                }
            }
            catch (DBException e) {
                log.warn("Can't get pseudo attributes for '" + entity.getName() + "'", e);
            }
        }
        return null;
    }

    public static boolean isPseudoAttribute(DBSAttributeBase attr) {
        return attr instanceof DBDAttributeBinding && ((DBDAttributeBinding)attr).isPseudoAttribute();
    }

    public static <TYPE extends DBPNamedObject> Comparator<TYPE> nameComparator() {
        return Comparator.comparing(DBPNamedObject::getName);
    }

    public static <TYPE extends DBPNamedObject> Comparator<TYPE> nameComparatorIgnoreCase() {
        return (o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName());
    }

    public static Comparator<? super DBSAttributeBase> orderComparator() {
        return Comparator.comparingInt(DBSAttributeBase::getOrdinalPosition);
    }

    public static <T extends DBPNamedObject> List<T> makeOrderedObjectList(@NotNull Collection<T> objects) {
        ArrayList<T> ordered = new ArrayList<T>(objects);
        DBUtils.orderObjects(ordered);
        return ordered;
    }

    public static <T extends DBPNamedObject> List<T> makeOrderedObjectList(@NotNull T[] objects) {
        ArrayList ordered = new ArrayList();
        Collections.addAll(ordered, objects);
        DBUtils.orderObjects(ordered);
        return ordered;
    }

    public static <T extends DBPNamedObject> void orderObjects(@NotNull List<T> objects) {
        objects.sort((o1, o2) -> {
            String name1 = o1.getName();
            String name2 = o2.getName();
            return name1 == null && name2 == null ? 0 : (name1 == null ? -1 : (name2 == null ? 1 : name1.compareTo(name2)));
        });
    }

    public static String getClientApplicationName(DBPDataSourceContainer container, DBCExecutionContext context, String purpose) {
        if (container.getPreferenceStore().getBoolean("database.meta.client.name.override")) {
            String appName = container.getPreferenceStore().getString("database.meta.client.name.value");
            IVariableResolver cVarResolver = container.getVariablesResolver(false);
            return GeneralUtils.replaceVariables(appName, name -> {
                switch (name) {
                    case "context.name": {
                        return context == null ? null : context.getContextName();
                    }
                    case "context.id": {
                        return context == null ? null : String.valueOf(context.getContextId());
                    }
                }
                return cVarResolver.get(name);
            });
        }
        String productTitle = GeneralUtils.getProductTitle();
        return purpose == null ? productTitle : String.valueOf(productTitle) + " - " + purpose;
    }

    public static DBSInstance getObjectOwnerInstance(DBSObject object) {
        if (object == null) {
            return null;
        }
        DBSObject p = object;
        while (p != null) {
            if (p instanceof DBSInstance) {
                return (DBSInstance)p;
            }
            p = p.getParentObject();
        }
        DBPDataSource dataSource = object.getDataSource();
        return dataSource == null ? null : dataSource.getDefaultInstance();
    }

    public static DBCExecutionContext getDefaultContext(DBSObject object, boolean meta) {
        if (object == null) {
            return null;
        }
        DBSInstance instance = DBUtils.getObjectOwnerInstance(object);
        return instance == null || instance instanceof DBSInstanceLazy && !((DBSInstanceLazy)instance).isInstanceConnected() ? null : instance.getDefaultContext(new VoidProgressMonitor(), meta);
    }

    public static List<DBPDataSourceRegistry> getAllRegistries(boolean forceLoad) {
        ArrayList<DBPDataSourceRegistry> result = new ArrayList<DBPDataSourceRegistry>();
        for (DBPProject project : DBWorkbench.getPlatform().getWorkspace().getProjects()) {
            if (!forceLoad && (!project.isOpen() || !project.isRegistryLoaded())) continue;
            project.ensureOpen();
            DBPDataSourceRegistry registry = project.getDataSourceRegistry();
            if (registry == null) continue;
            result.add(registry);
        }
        return result;
    }

    public static DBPDataSourceContainer findDataSource(String dataSourceId) {
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        for (DBPProject project : workspace.getProjects()) {
            DBPDataSourceContainer dataSourceContainer;
            DBPDataSourceRegistry dataSourceRegistry = project.getDataSourceRegistry();
            if (dataSourceRegistry == null || (dataSourceContainer = dataSourceRegistry.getDataSource(dataSourceId)) == null) continue;
            return dataSourceContainer;
        }
        return null;
    }

    public static int compareDataValues(Object cell1, Object cell2) {
        if (cell1 == cell2) {
            return 0;
        }
        if (DBUtils.isNullValue(cell1)) {
            return 1;
        }
        if (DBUtils.isNullValue(cell2)) {
            return -1;
        }
        if (cell1 instanceof Number && cell2 instanceof Number) {
            return CommonUtils.compareNumbers((Number)((Number)cell1), (Number)((Number)cell2));
        }
        if (cell1 instanceof Comparable && cell1.getClass() == cell2.getClass()) {
            return ((Comparable)cell1).compareTo(cell2);
        }
        String str1 = String.valueOf(cell1);
        String str2 = String.valueOf(cell2);
        return str1.compareTo(str2);
    }

    public static DBSEntity getEntityFromMetaData(DBRProgressMonitor monitor, DBCExecutionContext executionContext, DBCEntityMetaData entityMeta) throws DBException {
        DBSObjectContainer objectContainer = DBUtils.getAdapter(DBSObjectContainer.class, executionContext.getDataSource());
        if (objectContainer != null) {
            DBSEntity entity = DBUtils.getEntityFromMetaData(monitor, executionContext, objectContainer, entityMeta, false);
            if (entity == null) {
                entity = DBUtils.getEntityFromMetaData(monitor, executionContext, objectContainer, entityMeta, true);
            }
            return entity;
        }
        return null;
    }

    public static DBSEntity getEntityFromMetaData(DBRProgressMonitor monitor, DBCExecutionContext executionContext, DBSObjectContainer objectContainer, DBCEntityMetaData entityMeta, boolean transformName) throws DBException {
        DBSObject entityObject;
        DBPDataSource dataSource = objectContainer.getDataSource();
        String catalogName = entityMeta.getCatalogName();
        String schemaName = entityMeta.getSchemaName();
        String entityName = entityMeta.getEntityName();
        if (transformName) {
            catalogName = DBObjectNameCaseTransformer.transformName(dataSource, catalogName);
            schemaName = DBObjectNameCaseTransformer.transformName(dataSource, schemaName);
            entityName = DBObjectNameCaseTransformer.transformName(dataSource, entityName);
        }
        if ((entityObject = DBUtils.getObjectByPath(monitor, executionContext, objectContainer, catalogName, schemaName, entityName)) instanceof DBSAlias && !(entityObject instanceof DBSEntity)) {
            entityObject = ((DBSAlias)((Object)entityObject)).getTargetObject(monitor);
        }
        if (entityObject == null) {
            return null;
        }
        if (entityObject instanceof DBSEntity) {
            return (DBSEntity)entityObject;
        }
        log.debug("Unsupported table class: " + entityObject.getClass().getName());
        return null;
    }

    public static DBSEntityConstraint getConstraint(DBRProgressMonitor monitor, DBSEntity dbsEntity, DBSAttributeBase attribute) throws DBException {
        for (DBSEntityConstraint constraint : CommonUtils.safeCollection(dbsEntity.getConstraints(monitor))) {
            DBSEntityAttributeRef constraintAttribute = DBUtils.getConstraintAttribute(monitor, (DBSEntityReferrer)constraint, attribute.getName());
            if (constraintAttribute == null || constraintAttribute.getAttribute() != attribute) continue;
            return constraint;
        }
        return null;
    }

    public static boolean isReadOnly(DBSObject object) {
        if (object == null) {
            return true;
        }
        DBPDataSource dataSource = object.getDataSource();
        return dataSource == null || !dataSource.getContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA);
    }

    public static <T> T createNewAttributeValue(final DBCExecutionContext context, final DBDValueHandler valueHandler, final DBSTypedObject valueType, Class<T> targetType) throws DBCException {
        DBRRunnableWithResult<Object> runnable = new DBRRunnableWithResult<Object>(){

            @Override
            public void run(DBRProgressMonitor monitor) throws InvocationTargetException {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, "Create new object");){
                        this.result = valueHandler.createNewValueObject(session, valueType);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (DBCException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            DBWorkbench.getPlatformUI().executeWithProgress(runnable);
        }
        catch (InvocationTargetException e) {
            throw new DBCException(e.getTargetException(), context);
        }
        catch (InterruptedException e) {
            throw new DBCException((Throwable)e, context);
        }
        Object result = runnable.getResult();
        if (result == null) {
            throw new DBCException("Internal error - null object created");
        }
        if (!targetType.isInstance(result)) {
            throw new DBCException("Internal error - wrong object type '" + result.getClass().getName() + "' while '" + targetType.getName() + "' was expected");
        }
        return targetType.cast(result);
    }

    public static boolean isView(DBSEntity table) {
        return table instanceof DBSView || table instanceof DBSTable && ((DBSTable)table).isView();
    }

    public static String getEntityScriptName(DBSEntity entity, Map<String, Object> options) {
        return CommonUtils.getOption(options, (String)"useFQN", (boolean)true) && entity instanceof DBPQualifiedObject ? ((DBPQualifiedObject)((Object)entity)).getFullyQualifiedName(DBPEvaluationContext.DDL) : DBUtils.getQuotedIdentifier(entity);
    }

    public static String getObjectTypeName(DBSObject object) {
        DBSObjectType[] objectTypes;
        DBSObjectType[] dBSObjectTypeArray = objectTypes = object.getDataSource().getInfo().getSupportedObjectTypes();
        int n = objectTypes.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObjectType ot = dBSObjectTypeArray[n2];
            Class<? extends DBSObject> typeClass = ot.getTypeClass();
            if (typeClass != null && typeClass != DBSObject.class && typeClass.isInstance(object)) {
                return ot.getTypeName();
            }
            ++n2;
        }
        return "Object";
    }
}

