/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class SQLSearchUtils {
    private static final Log log = Log.getLog(SQLSearchUtils.class);

    @Nullable
    public static DBSObject findObjectByFQN(DBRProgressMonitor monitor, DBSObjectContainer sc, DBCExecutionContext executionContext, List<String> nameList, boolean useAssistant, SQLIdentifierDetector identifierDetector) {
        if (nameList.isEmpty()) {
            return null;
        }
        ArrayList<String> unquotedNames = new ArrayList<String>(nameList.size());
        for (String name : nameList) {
            unquotedNames.add(DBUtils.getUnQuotedIdentifier((DBPDataSource)executionContext.getDataSource(), (String)name));
        }
        DBSObject result = SQLSearchUtils.findObjectByPath(monitor, executionContext, sc, unquotedNames, identifierDetector, useAssistant);
        if (result != null) {
            return result;
        }
        int i = 0;
        while (i < nameList.size()) {
            String name;
            name = nameList.get(i);
            String unquotedName = DBUtils.getUnQuotedIdentifier((DBPDataSource)executionContext.getDataSource(), (String)name);
            name = !unquotedName.equals(name) ? unquotedName : DBObjectNameCaseTransformer.transformName((DBPDataSource)sc.getDataSource(), (String)name);
            nameList.set(i, name);
            ++i;
        }
        return SQLSearchUtils.findObjectByPath(monitor, executionContext, sc, nameList, identifierDetector, useAssistant);
    }

    public static DBSObject findObjectByPath(DBRProgressMonitor monitor, DBCExecutionContext executionContext, DBSObjectContainer sc, List<String> nameList, SQLIdentifierDetector identifierDetector, boolean useAssistant) {
        DBSObject childObject;
        block6: {
            try {
                DBSStructureAssistant structureAssistant;
                childObject = null;
                while (childObject == null) {
                    childObject = DBUtils.findNestedObject((DBRProgressMonitor)monitor, (DBCExecutionContext)executionContext, (DBSObjectContainer)sc, nameList);
                    if (childObject != null) continue;
                    DBSObjectContainer parentSc = (DBSObjectContainer)DBUtils.getParentAdapter(DBSObjectContainer.class, (DBSObject)sc);
                    if (parentSc == null) break;
                    sc = parentSc;
                }
                if (childObject != null || nameList.size() > 1) break block6;
                if (useAssistant && (structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)sc)) != null) {
                    String objectNameMask = nameList.get(0);
                    List tables = structureAssistant.findObjectsByMask(monitor, (DBSObject)sc, structureAssistant.getAutoCompleteObjectTypes(), identifierDetector.removeQuotes(objectNameMask), identifierDetector.isQuoted(objectNameMask), false, 2);
                    if (!tables.isEmpty()) {
                        return ((DBSObjectReference)tables.iterator().next()).resolveObject(monitor);
                    }
                }
                return null;
            }
            catch (DBException e) {
                log.error((Object)e);
                return null;
            }
        }
        return childObject;
    }
}

