/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSchException;
import java.util.List;
import java.util.Vector;
import org.jkiss.dbeaver.model.net.ssh.SSHAgentIdentity;
import org.jkiss.dbeaver.model.net.ssh.SSHImplementationAbstract;

public class DBeaverIdentityRepository
implements IdentityRepository {
    private SSHImplementationAbstract impl;
    private List<SSHAgentIdentity> identities;

    public DBeaverIdentityRepository(SSHImplementationAbstract impl, List<SSHAgentIdentity> identities) {
        this.impl = impl;
        this.identities = identities;
    }

    public Vector getIdentities() {
        Vector<1> result = new Vector<1>();
        for (SSHAgentIdentity identity : this.identities) {
            final byte[] blob = identity.getBlob();
            final byte[] comment = identity.getComment();
            Identity id = new Identity(){
                String algname;
                {
                    this.algname = new String(new Buffer(byArray).getString());
                }

                public boolean setPassphrase(byte[] passphrase) throws JSchException {
                    return true;
                }

                public byte[] getPublicKeyBlob() {
                    return blob;
                }

                public byte[] getSignature(byte[] data) {
                    return DBeaverIdentityRepository.this.impl.agentSign(blob, data);
                }

                public boolean decrypt() {
                    return true;
                }

                public String getAlgName() {
                    return this.algname;
                }

                public String getName() {
                    return new String(comment);
                }

                public boolean isEncrypted() {
                    return false;
                }

                public void clear() {
                }
            };
            result.addElement(id);
        }
        return result;
    }

    public boolean add(byte[] identity) {
        return false;
    }

    public boolean remove(byte[] blob) {
        return false;
    }

    public void removeAll() {
    }

    public String getName() {
        return "DBeaver Identity Repository for jsch";
    }

    public int getStatus() {
        return 2;
    }
}

