/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.mysql.MySQLDataSourceProvider;
import org.jkiss.dbeaver.ext.mysql.MySQLServerHome;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLDatabaseExportInfo;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLExportSettings;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLExportWizardPageObjects;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLExportWizardPageSettings;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLToolScript;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractImportExportWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractToolWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class MySQLExportWizard
extends AbstractImportExportWizard<MySQLExportSettings, MySQLDatabaseExportInfo>
implements IExportWizard {
    private MySQLExportWizardPageObjects objectsPage;
    private MySQLExportWizardPageSettings settingsPage;

    public MySQLExportWizard(Collection<DBSObject> objects) {
        super(objects, MySQLUIMessages.tools_db_export_wizard_task_name);
    }

    public MySQLExportWizard(DBTTask task) {
        super(task);
    }

    protected MySQLExportSettings createSettings() {
        return new MySQLExportSettings();
    }

    public String getTaskTypeId() {
        return "mysqlDatabaseBackup";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, Map<String, Object> state) {
        this.objectsPage.saveState();
        this.settingsPage.updateState();
        ((MySQLExportSettings)this.getSettings()).saveSettings(runnableContext, (DBPPreferenceStore)new TaskPreferenceStore(state));
    }

    public boolean isRunTaskOnFinish() {
        return this.getCurrentTask() != null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.objectsPage = new MySQLExportWizardPageObjects(this);
        this.settingsPage = new MySQLExportWizardPageSettings(this);
    }

    public void addPages() {
        this.addTaskConfigPages();
        this.addPage((IWizardPage)this.objectsPage);
        this.addPage((IWizardPage)this.settingsPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.settingsPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.logPage) {
            return this.settingsPage;
        }
        return super.getPreviousPage(page);
    }

    public void onSuccess(long workTime) {
        UIUtils.showMessageBox((Shell)this.getShell(), (String)MySQLUIMessages.tools_db_export_wizard_title, (String)CommonUtils.truncateString((String)NLS.bind((String)MySQLUIMessages.tools_db_export_wizard_message_export_completed, (Object)this.getObjectsName()), (int)255), (int)2);
        UIUtils.launchProgram((String)((MySQLExportSettings)this.getSettings()).getOutputFolder().getAbsolutePath());
    }

    public void fillProcessParameters(List<String> cmd, MySQLDatabaseExportInfo arg) throws IOException {
        File dumpBinary = RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)this.getClientHome(), (String)"bin", (String)"mysqldump");
        String dumpPath = dumpBinary.getAbsolutePath();
        cmd.add(dumpPath);
        MySQLExportSettings settings = (MySQLExportSettings)this.getSettings();
        switch (settings.getMethod()) {
            case LOCK_ALL_TABLES: {
                cmd.add("--lock-all-tables");
                break;
            }
            case ONLINE: {
                cmd.add("--single-transaction");
            }
        }
        if (settings.isNoCreateStatements()) {
            cmd.add("--no-create-info");
        } else if (CommonUtils.isEmpty((Collection)arg.getTables())) {
            cmd.add("--routines");
        }
        if (settings.isAddDropStatements()) {
            cmd.add("--add-drop-table");
        } else {
            cmd.add("--skip-add-drop-table");
        }
        if (settings.isDisableKeys()) {
            cmd.add("--disable-keys");
        }
        if (settings.isExtendedInserts()) {
            cmd.add("--extended-insert");
        } else {
            cmd.add("--skip-extended-insert");
        }
        if (settings.isBinariesInHex()) {
            cmd.add("--hex-blob");
        }
        if (settings.isNoData()) {
            cmd.add("--no-data");
        }
        if (settings.isDumpEvents()) {
            cmd.add("--events");
        }
        if (settings.isComments()) {
            cmd.add("--comments");
        }
        settings.addExtraCommandArgs(cmd);
    }

    protected void setupProcessParameters(ProcessBuilder process) {
        if (!CommonUtils.isEmpty((String)this.getToolUserPassword())) {
            process.environment().put("MYSQL_PWD", this.getToolUserPassword());
        }
    }

    public boolean performFinish() {
        this.objectsPage.saveState();
        this.settingsPage.updateState();
        return super.performFinish();
    }

    public MySQLServerHome findNativeClientHome(String clientHomeId) {
        return MySQLDataSourceProvider.getServerHome((String)clientHomeId);
    }

    public List<MySQLDatabaseExportInfo> getRunInfo() {
        return ((MySQLExportSettings)this.getSettings()).getExportObjects();
    }

    protected List<String> getCommandLine(MySQLDatabaseExportInfo arg) throws IOException {
        List<String> cmd = MySQLToolScript.getMySQLToolCommandLine(this, arg);
        if (!CommonUtils.isEmpty((Collection)arg.getTables())) {
            cmd.add(arg.getDatabase().getName());
            for (MySQLTableBase table : arg.getTables()) {
                cmd.add(table.getName());
            }
        } else {
            cmd.add(arg.getDatabase().getName());
        }
        return cmd;
    }

    public boolean isVerbose() {
        return true;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, MySQLDatabaseExportInfo arg, ProcessBuilder processBuilder, Process process) {
        super.startProcessHandler(monitor, (Object)arg, processBuilder, process);
        String outFileName = GeneralUtils.replaceVariables((String)((MySQLExportSettings)this.getSettings()).getOutputFilePattern(), name -> {
            switch (name) {
                case "database": {
                    return arg.getDatabase().getName();
                }
                case "host": {
                    return arg.getDatabase().getDataSource().getContainer().getConnectionConfiguration().getHostName();
                }
                case "table": {
                    Iterator iterator;
                    Iterator iterator2 = iterator = arg.getTables() == null ? null : arg.getTables().iterator();
                    if (iterator != null && iterator.hasNext()) {
                        return ((MySQLTableBase)iterator.next()).getName();
                    }
                    return "null";
                }
                case "timestamp": {
                    return RuntimeUtils.getCurrentTimeStamp();
                }
                case "date": {
                    return RuntimeUtils.getCurrentDate();
                }
            }
            System.getProperty(name);
            return null;
        });
        File outFile = new File(((MySQLExportSettings)this.getSettings()).getOutputFolder(), outFileName);
        boolean isFiltering = ((MySQLExportSettings)this.getSettings()).isRemoveDefiner();
        DumpFilterJob job = isFiltering ? new DumpFilterJob(monitor, process.getInputStream(), outFile) : new AbstractToolWizard.DumpCopierJob((AbstractToolWizard)this, monitor, MySQLUIMessages.tools_db_export_wizard_monitor_export_db, process.getInputStream(), outFile);
        ((Thread)((Object)job)).start();
    }

    class DumpFilterJob
    extends AbstractToolWizard.DumpJob {
        private Pattern DEFINER_PATTER;

        DumpFilterJob(DBRProgressMonitor monitor, InputStream stream, File outFile) {
            super((AbstractToolWizard)MySQLExportWizard.this, MySQLUIMessages.tools_db_export_wizard_job_dump_log_reader, monitor, stream, outFile);
            this.DEFINER_PATTER = Pattern.compile("DEFINER\\s*=\\s*`[^*]*`@`[0-9a-z\\-_\\.%]*`", 2);
        }

        public void runDump() throws IOException {
            this.monitor.beginTask(MySQLUIMessages.tools_db_export_wizard_monitor_export_db, 100);
            long prevStatusUpdateTime = 0L;
            try {
                NumberFormat numberFormat = NumberFormat.getInstance();
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(this.input, GeneralUtils.DEFAULT_ENCODING));
                Throwable throwable = null;
                Object var6_6 = null;
                try (FileOutputStream output = new FileOutputStream(this.outFile);){
                    String line;
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output, GeneralUtils.DEFAULT_ENCODING));
                    while ((line = reader.readLine()) != null) {
                        long currentTime;
                        Matcher matcher = this.DEFINER_PATTER.matcher(line);
                        if (matcher.find()) {
                            line = matcher.replaceFirst("");
                        }
                        if ((currentTime = System.currentTimeMillis()) - prevStatusUpdateTime > 300L) {
                            this.monitor.subTask("Saved " + numberFormat.format(reader.getLineNumber()) + " lines");
                            prevStatusUpdateTime = currentTime;
                        }
                        line = this.filterLine(line);
                        writer.write(line);
                        writer.newLine();
                    }
                    writer.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                this.monitor.done();
            }
        }

        @NotNull
        private String filterLine(@NotNull String line) {
            return line;
        }
    }
}

