/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tasks.ui.nativetool;

import java.io.File;
import java.util.Collection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tasks.nativetool.AbstractScriptExecuteSettings;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractToolWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.internal.TaskNativeUIMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;

public abstract class AbstractScriptExecuteWizard<SETTINGS extends AbstractScriptExecuteSettings<BASE_OBJECT>, BASE_OBJECT extends DBSObject, PROCESS_ARG>
extends AbstractToolWizard<SETTINGS, BASE_OBJECT, PROCESS_ARG>
implements IImportWizard {
    public AbstractScriptExecuteWizard(Collection<BASE_OBJECT> dbObject, String task) {
        super(dbObject, task);
    }

    @Override
    protected abstract SETTINGS createSettings();

    @Override
    protected boolean isSingleTimeWizard() {
        return false;
    }

    public File getInputFile() {
        return new File(((AbstractScriptExecuteSettings)this.getSettings()).getInputFile());
    }

    public void setInputFile(File inputFile) {
        ((AbstractScriptExecuteSettings)this.getSettings()).setInputFile(inputFile.getAbsolutePath());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(this.taskTitle);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.logPage);
    }

    @Override
    public void onSuccess(long workTime) {
        UIUtils.showMessageBox((Shell)this.getShell(), (String)this.taskTitle, (String)NLS.bind((String)TaskNativeUIMessages.tools_script_execute_wizard_task_completed, (Object)this.taskTitle, (Object)this.getObjectsName()), (int)2);
    }

    @Override
    protected void startProcessHandler(DBRProgressMonitor monitor, PROCESS_ARG arg, ProcessBuilder processBuilder, Process process) {
        this.logPage.startLogReader(processBuilder, process.getInputStream());
        new AbstractToolWizard.TextFileTransformerJob(monitor, this.getInputFile(), process.getOutputStream(), this.getInputCharset(), this.getOutputCharset()).start();
    }

    @Override
    protected boolean isMergeProcessStreams() {
        return true;
    }

    protected String getInputCharset() {
        return GeneralUtils.UTF8_ENCODING;
    }

    protected String getOutputCharset() {
        return GeneralUtils.UTF8_ENCODING;
    }
}

