/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.ui.sql;

import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLBlockToggleToken;
import org.jkiss.utils.CommonUtils;

class PostgreDollarQuoteRule
implements IPredicateRule {
    private final boolean partitionRule;
    private final boolean ddPlainIsString;
    private final boolean ddTagIsString;
    private final IToken partStringToken;
    private final IToken partCodeToken;
    private final IToken stringToken;
    private final IToken delimiterToken;

    PostgreDollarQuoteRule(DBPDataSourceContainer dataSource, boolean partitionRule) {
        this.partitionRule = partitionRule;
        boolean ddPlainDefault = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("postgresql.dd.plain.string");
        boolean ddTagDefault = DBWorkbench.getPlatform().getPreferenceStore().getBoolean("postgresql.dd.tag.string");
        this.ddPlainIsString = dataSource == null ? ddPlainDefault : CommonUtils.getBoolean((String)dataSource.getActualConnectionConfiguration().getProviderProperty("postgresql.dd.plain.string"), (boolean)ddPlainDefault);
        this.ddTagIsString = dataSource == null ? ddTagDefault : CommonUtils.getBoolean((String)dataSource.getActualConnectionConfiguration().getProviderProperty("postgresql.dd.tag.string"), (boolean)ddTagDefault);
        this.partStringToken = new Token((Object)"sql_character");
        this.partCodeToken = new Token((Object)"__dftl_partition_content_type");
        this.stringToken = new Token((Object)new TextAttribute(UIUtils.getGlobalColor((String)"org.jkiss.dbeaver.sql.editor.color.string.foreground"), null, 0));
        this.delimiterToken = new SQLBlockToggleToken((Object)new TextAttribute(UIUtils.getGlobalColor((String)"org.jkiss.dbeaver.sql.editor.color.delimiter.foreground"), null, 1));
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate(scanner, false);
    }

    public IToken getSuccessToken() {
        return this.partitionRule ? this.partStringToken : this.stringToken;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int totalRead = 0;
        int c = scanner.read();
        ++totalRead;
        if (c == 36) {
            int charsRead = 0;
            do {
                c = scanner.read();
                ++charsRead;
                ++totalRead;
                if (c != 36) continue;
                if (charsRead <= 1 ? this.ddPlainIsString : this.ddTagIsString) {
                    boolean stringEndFound = false;
                    while (true) {
                        c = scanner.read();
                        ++totalRead;
                        if (c == -1) break;
                        if (c != 36) continue;
                        int c2 = scanner.read();
                        ++totalRead;
                        if (c2 == 36) {
                            stringEndFound = true;
                            break;
                        }
                        scanner.unread();
                        --totalRead;
                    }
                    if (!stringEndFound) {
                        if (this.partitionRule) break;
                        PostgreDollarQuoteRule.unread(scanner, totalRead - 2);
                        return this.delimiterToken;
                    }
                    return this.partitionRule ? this.partStringToken : this.stringToken;
                }
                if (this.partitionRule) break;
                return this.delimiterToken;
            } while (Character.isLetterOrDigit(c) || c == 95);
        }
        PostgreDollarQuoteRule.unread(scanner, totalRead);
        return Token.UNDEFINED;
    }

    private static void unread(ICharacterScanner scanner, int totalRead) {
        while (totalRead-- > 0) {
            scanner.unread();
        }
    }
}

