/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.IWizardPage;
import org.jkiss.dbeaver.ext.postgresql.PostgreDataSourceProvider;
import org.jkiss.dbeaver.ext.postgresql.PostgreMessages;
import org.jkiss.dbeaver.ext.postgresql.PostgreServerHome;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.tasks.PostgreScriptExecuteSettings;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreScriptExecuteWizardPageSettings;
import org.jkiss.dbeaver.ext.postgresql.tools.PostgreToolScript;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractScriptExecuteWizard;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class PostgreScriptExecuteWizard
extends AbstractScriptExecuteWizard<PostgreScriptExecuteSettings, PostgreDatabase, PostgreDatabase> {
    private boolean isImport;
    private PostgreScriptExecuteWizardPageSettings mainPage;

    PostgreScriptExecuteWizard(PostgreDatabase catalog, boolean isImport) {
        super(Collections.singleton(catalog), isImport ? PostgreMessages.wizard_script_title_import_db : PostgreMessages.wizard_script_title_execute_script);
        this.isImport = isImport;
        this.mainPage = new PostgreScriptExecuteWizardPageSettings(this);
    }

    public boolean isImport() {
        return this.isImport;
    }

    public boolean isVerbose() {
        return false;
    }

    public String getTaskTypeId() {
        return "postgresScriptExecute";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, Map<String, Object> state) {
    }

    protected PostgreScriptExecuteSettings createSettings() {
        return new PostgreScriptExecuteSettings();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mainPage);
        super.addPages();
    }

    public void fillProcessParameters(List<String> cmd, PostgreDatabase arg) throws IOException {
        String dumpPath = RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)this.getClientHome(), (String)"bin", (String)"psql").getAbsolutePath();
        cmd.add(dumpPath);
        if (arg.getDataSource().isServerVersionAtLeast(9, 5)) {
            cmd.add("--echo-errors");
        }
    }

    protected void setupProcessParameters(ProcessBuilder process) {
        super.setupProcessParameters(process);
        if (!CommonUtils.isEmpty((String)this.getToolUserPassword())) {
            process.environment().put("PGPASSWORD", this.getToolUserPassword());
        }
    }

    public PostgreServerHome findNativeClientHome(String clientHomeId) {
        return PostgreDataSourceProvider.getServerHome((String)clientHomeId);
    }

    public Collection<PostgreDatabase> getRunInfo() {
        return this.getDatabaseObjects();
    }

    protected List<String> getCommandLine(PostgreDatabase arg) throws IOException {
        List<String> cmd = PostgreToolScript.getPostgreToolCommandLine(this, arg);
        cmd.add(arg.getName());
        return cmd;
    }
}

