/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLNativeToolHandler;
import org.jkiss.dbeaver.ext.mysql.tasks.MySQLScriptExecuteSettings;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.registry.task.TaskPreferenceStore;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolHandler;
import org.jkiss.dbeaver.tasks.nativetool.AbstractNativeToolSettings;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class MySQLScriptExecuteHandler
extends MySQLNativeToolHandler<MySQLScriptExecuteSettings, MySQLCatalog, MySQLCatalog> {
    public Collection<MySQLCatalog> getRunInfo(MySQLScriptExecuteSettings settings) {
        return settings.getDatabaseObjects();
    }

    protected MySQLScriptExecuteSettings createTaskSettings(DBRRunnableContext context, DBTTask task) {
        MySQLScriptExecuteSettings settings = new MySQLScriptExecuteSettings();
        boolean isImport = task.getType().getId().equals("mysqlDatabaseRestore");
        settings.setImport(isImport);
        settings.loadSettings(context, (DBPPreferenceStore)new TaskPreferenceStore(task));
        return settings;
    }

    protected boolean validateTaskParameters(DBTTask task, MySQLScriptExecuteSettings settings, Log log) {
        return true;
    }

    protected List<String> getCommandLine(MySQLScriptExecuteSettings settings, MySQLCatalog arg) throws IOException {
        List<String> cmd = this.getMySQLToolCommandLine(this, settings, arg);
        cmd.add(arg.getName());
        return cmd;
    }

    public void fillProcessParameters(MySQLScriptExecuteSettings settings, MySQLCatalog arg, List<String> cmd) throws IOException {
        String dumpPath = RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)settings.getClientHome(), (String)"bin", (String)"mysql").getAbsolutePath();
        cmd.add(dumpPath);
        if (settings.getLogLevel() == MySQLScriptExecuteSettings.LogLevel.Debug) {
            cmd.add("--debug-info");
        }
        if (settings.isNoBeep()) {
            cmd.add("--no-beep");
        }
        settings.addExtraCommandArgs(cmd);
    }

    public boolean isVerbose() {
        return true;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, DBTTask task, MySQLScriptExecuteSettings settings, MySQLCatalog arg, ProcessBuilder processBuilder, Process process, Log log) {
        if (settings.isImport()) {
            super.startProcessHandler(monitor, task, (AbstractNativeToolSettings)settings, (Object)arg, processBuilder, process, log);
            new AbstractNativeToolHandler.BinaryFileTransformerJob(monitor, task, new File(settings.getInputFile()), process.getOutputStream(), log).start();
        } else {
            super.startProcessHandler(monitor, task, (AbstractNativeToolSettings)settings, (Object)arg, processBuilder, process, log);
        }
    }
}

