/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.edit.MySQLTableManager;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.model.MySQLView;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class MySQLViewManager
extends MySQLTableManager {
    @Override
    @Nullable
    public DBSObjectCache<MySQLCatalog, MySQLTableBase> getObjectsCache(MySQLTableBase object) {
        return ((MySQLCatalog)object.getContainer()).getTableCache();
    }

    protected void validateObjectProperties(SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) throws DBException {
        MySQLTableBase object = (MySQLTableBase)command.getObject();
        if (CommonUtils.isEmpty((String)object.getName())) {
            throw new DBException("View name cannot be empty");
        }
        if (CommonUtils.isEmpty((String)((MySQLView)object).getAdditionalInfo().getDefinition())) {
            throw new DBException("View definition cannot be empty");
        }
    }

    protected String getBaseObjectName() {
        return "NewView";
    }

    @Override
    protected MySQLView createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        MySQLCatalog catalog = (MySQLCatalog)container;
        MySQLView newView = new MySQLView(catalog);
        this.setNewObjectName(monitor, (DBSObject)catalog, newView);
        return newView;
    }

    @Override
    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) {
        this.createOrReplaceViewQuery(actions, (MySQLView)command.getObject());
    }

    @Override
    protected void addObjectModifyActions(DBRProgressMonitor monitor, List<DBEPersistAction> actionList, SQLObjectEditor.ObjectChangeCommand command, Map<String, Object> options) {
        this.createOrReplaceViewQuery(actionList, (MySQLView)command.getObject());
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop view", "DROP VIEW " + ((MySQLTableBase)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    private void createOrReplaceViewQuery(List<DBEPersistAction> actions, final MySQLView view) {
        StringBuilder decl = new StringBuilder(200);
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        if (!view.isPersisted()) {
            decl.append("CREATE OR REPLACE VIEW ").append(view.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(lineSeparator).append("AS ");
        }
        decl.append(view.getAdditionalInfo().getDefinition());
        MySQLView.CheckOption checkOption = view.getAdditionalInfo().getCheckOption();
        if (checkOption != null && checkOption != MySQLView.CheckOption.NONE) {
            decl.append(lineSeparator).append("WITH ").append(checkOption.getDefinitionName()).append(" CHECK OPTION");
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create view", decl.toString()){

            public void beforeExecute(DBCSession session) throws DBCException {
                MySQLView schemaView;
                try {
                    schemaView = (MySQLView)DBUtils.findObject(((MySQLCatalog)view.getParentObject()).getViews(session.getProgressMonitor()), (String)view.getName());
                }
                catch (DBException e) {
                    throw new DBCException((Throwable)e, view.getDataSource());
                }
                if (schemaView != view) {
                    throw new DBCException("View with name '" + view.getName() + "' already exists. Choose another name");
                }
                super.beforeExecute(session);
            }
        });
    }
}

