/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.mysql.MySQLDataSourceProvider;
import org.jkiss.dbeaver.ext.mysql.MySQLServerHome;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableBase;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLDatabaseExportInfo;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLExportWizardPageObjects;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLExportWizardPageSettings;
import org.jkiss.dbeaver.ext.mysql.tools.MySQLToolScript;
import org.jkiss.dbeaver.ext.mysql.ui.internal.MySQLUIMessages;
import org.jkiss.dbeaver.model.connection.DBPNativeClientLocation;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractImportExportWizard;
import org.jkiss.dbeaver.tasks.ui.nativetool.AbstractToolWizard;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

class MySQLExportWizard
extends AbstractImportExportWizard<MySQLDatabaseExportInfo>
implements IExportWizard {
    DumpMethod method = DumpMethod.NORMAL;
    boolean noCreateStatements;
    boolean addDropStatements = true;
    boolean disableKeys = true;
    boolean extendedInserts = true;
    boolean dumpEvents;
    boolean comments;
    boolean removeDefiner;
    boolean binariesInHex;
    boolean noData;
    boolean showViews;
    public List<MySQLDatabaseExportInfo> objects = new ArrayList<MySQLDatabaseExportInfo>();
    private MySQLExportWizardPageObjects objectsPage;
    private MySQLExportWizardPageSettings settingsPage;
    private static Pattern DEFINER_PATTER = Pattern.compile("DEFINER\\s*=\\s*`[^*]*`@`[0-9a-z\\-_\\.%]*`", 2);

    public MySQLExportWizard(Collection<DBSObject> objects) {
        super(objects, MySQLUIMessages.tools_db_export_wizard_task_name);
        this.loadExportSettings();
    }

    public MySQLExportWizard(DBTTask task) {
        super(task);
        this.loadExportSettings();
    }

    private void loadExportSettings() {
        DBPPreferenceStore store = this.getPreferenceStore();
        this.outputFilePattern = store.getString("MySQL.export.outputFilePattern");
        if (CommonUtils.isEmpty((String)this.outputFilePattern)) {
            this.outputFilePattern = "dump-${database}-${timestamp}.sql";
        }
        this.noCreateStatements = CommonUtils.getBoolean((String)store.getString("MySQL.export.noCreateStatements"), (boolean)false);
        this.addDropStatements = CommonUtils.getBoolean((String)store.getString("MySQL.export.addDropStatements"), (boolean)true);
        this.disableKeys = CommonUtils.getBoolean((String)store.getString("MySQL.export.disableKeys"), (boolean)true);
        this.extendedInserts = CommonUtils.getBoolean((String)store.getString("MySQL.export.extendedInserts"), (boolean)true);
        this.dumpEvents = CommonUtils.getBoolean((String)store.getString("MySQL.export.dumpEvents"), (boolean)false);
        this.comments = CommonUtils.getBoolean((String)store.getString("MySQL.export.comments"), (boolean)false);
        this.removeDefiner = CommonUtils.getBoolean((String)store.getString("MySQL.export.removeDefiner"), (boolean)false);
        this.binariesInHex = CommonUtils.getBoolean((String)store.getString("MySQL.export.binariesInHex"), (boolean)false);
        this.noData = CommonUtils.getBoolean((String)store.getString("MySQL.export.noData"), (boolean)false);
        this.showViews = CommonUtils.getBoolean((String)store.getString("MySQL.export.showViews"), (boolean)false);
        if (CommonUtils.isEmpty((String)this.getExtraCommandArgs())) {
            this.setExtraCommandArgs(store.getString("MySQL.export.extraArgs"));
        }
    }

    private void saveExportSettings() {
        DBPPreferenceStore store = this.getPreferenceStore();
        store.setValue("MySQL.export.outputFilePattern", this.outputFilePattern);
        store.setValue("MySQL.export.noCreateStatements", this.noCreateStatements);
        store.setValue("MySQL.export.addDropStatements", this.addDropStatements);
        store.setValue("MySQL.export.disableKeys", this.disableKeys);
        store.setValue("MySQL.export.extendedInserts", this.extendedInserts);
        store.setValue("MySQL.export.dumpEvents", this.dumpEvents);
        store.setValue("MySQL.export.comments", this.comments);
        store.setValue("MySQL.export.removeDefiner", this.removeDefiner);
        store.setValue("MySQL.export.binariesInHex", this.binariesInHex);
        store.setValue("MySQL.export.noData", this.noData);
        store.setValue("MySQL.export.showViews", this.showViews);
    }

    public String getTaskTypeId() {
        return "mysqlDatabaseBackup";
    }

    public void saveTaskState(DBRRunnableContext runnableContext, Map<String, Object> state) {
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.objectsPage = new MySQLExportWizardPageObjects(this);
        this.settingsPage = new MySQLExportWizardPageSettings(this);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.objectsPage);
        this.addPage((IWizardPage)this.settingsPage);
        super.addPages();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.settingsPage) {
            return null;
        }
        return super.getNextPage(page);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.logPage) {
            return this.settingsPage;
        }
        return super.getPreviousPage(page);
    }

    public void onSuccess(long workTime) {
        UIUtils.showMessageBox((Shell)this.getShell(), (String)MySQLUIMessages.tools_db_export_wizard_title, (String)CommonUtils.truncateString((String)NLS.bind((String)MySQLUIMessages.tools_db_export_wizard_message_export_completed, (Object)this.getObjectsName()), (int)255), (int)2);
        UIUtils.launchProgram((String)this.outputFolder.getAbsolutePath());
    }

    public void fillProcessParameters(List<String> cmd, MySQLDatabaseExportInfo arg) throws IOException {
        File dumpBinary = RuntimeUtils.getNativeClientBinary((DBPNativeClientLocation)this.getClientHome(), (String)"bin", (String)"mysqldump");
        String dumpPath = dumpBinary.getAbsolutePath();
        cmd.add(dumpPath);
        switch (this.method) {
            case LOCK_ALL_TABLES: {
                cmd.add("--lock-all-tables");
                break;
            }
            case ONLINE: {
                cmd.add("--single-transaction");
            }
        }
        if (this.noCreateStatements) {
            cmd.add("--no-create-info");
        } else if (CommonUtils.isEmpty(arg.getTables())) {
            cmd.add("--routines");
        }
        if (this.addDropStatements) {
            cmd.add("--add-drop-table");
        } else {
            cmd.add("--skip-add-drop-table");
        }
        if (this.disableKeys) {
            cmd.add("--disable-keys");
        }
        if (this.extendedInserts) {
            cmd.add("--extended-insert");
        } else {
            cmd.add("--skip-extended-insert");
        }
        if (this.binariesInHex) {
            cmd.add("--hex-blob");
        }
        if (this.noData) {
            cmd.add("--no-data");
        }
        if (this.dumpEvents) {
            cmd.add("--events");
        }
        if (this.comments) {
            cmd.add("--comments");
        }
        this.addExtraCommandArgs(cmd);
    }

    protected void setupProcessParameters(ProcessBuilder process) {
        if (!CommonUtils.isEmpty((String)this.getToolUserPassword())) {
            process.environment().put("MYSQL_PWD", this.getToolUserPassword());
        }
    }

    public boolean performFinish() {
        this.objectsPage.saveState();
        this.saveExportSettings();
        return super.performFinish();
    }

    public MySQLServerHome findNativeClientHome(String clientHomeId) {
        return MySQLDataSourceProvider.getServerHome((String)clientHomeId);
    }

    public Collection<MySQLDatabaseExportInfo> getRunInfo() {
        return this.objects;
    }

    protected List<String> getCommandLine(MySQLDatabaseExportInfo arg) throws IOException {
        List<String> cmd = MySQLToolScript.getMySQLToolCommandLine(this, arg);
        if (!this.objects.isEmpty()) {
            if (!CommonUtils.isEmpty(arg.getTables())) {
                cmd.add(arg.getDatabase().getName());
                for (MySQLTableBase table : arg.getTables()) {
                    cmd.add(table.getName());
                }
            } else {
                cmd.add(arg.getDatabase().getName());
            }
        }
        return cmd;
    }

    public boolean isVerbose() {
        return true;
    }

    protected void startProcessHandler(DBRProgressMonitor monitor, final MySQLDatabaseExportInfo arg, ProcessBuilder processBuilder, Process process) {
        super.startProcessHandler(monitor, (Object)arg, processBuilder, process);
        String outFileName = GeneralUtils.replaceVariables((String)this.outputFilePattern, (IVariableResolver)new IVariableResolver(){

            public String get(String name) {
                switch (name) {
                    case "database": {
                        return arg.getDatabase().getName();
                    }
                    case "host": {
                        return arg.getDatabase().getDataSource().getContainer().getConnectionConfiguration().getHostName();
                    }
                    case "table": {
                        Iterator<MySQLTableBase> iterator;
                        Iterator<MySQLTableBase> iterator2 = iterator = arg.getTables() == null ? null : arg.getTables().iterator();
                        if (iterator != null && iterator.hasNext()) {
                            return iterator.next().getName();
                        }
                        return "null";
                    }
                    case "timestamp": {
                        return RuntimeUtils.getCurrentTimeStamp();
                    }
                    case "date": {
                        return RuntimeUtils.getCurrentDate();
                    }
                }
                System.getProperty(name);
                return null;
            }
        });
        File outFile = new File(this.outputFolder, outFileName);
        boolean isFiltering = this.removeDefiner;
        DumpFilterJob job = isFiltering ? new DumpFilterJob(monitor, process.getInputStream(), outFile) : new AbstractToolWizard.DumpCopierJob((AbstractToolWizard)this, monitor, MySQLUIMessages.tools_db_export_wizard_monitor_export_db, process.getInputStream(), outFile);
        ((Thread)((Object)job)).start();
    }

    class DumpFilterJob
    extends AbstractToolWizard.DumpJob {
        protected DumpFilterJob(DBRProgressMonitor monitor, InputStream stream, File outFile) {
            super((AbstractToolWizard)MySQLExportWizard.this, MySQLUIMessages.tools_db_export_wizard_job_dump_log_reader, monitor, stream, outFile);
        }

        public void runDump() throws IOException {
            this.monitor.beginTask(MySQLUIMessages.tools_db_export_wizard_monitor_export_db, 100);
            long prevStatusUpdateTime = 0L;
            try {
                NumberFormat numberFormat = NumberFormat.getInstance();
                LineNumberReader reader = new LineNumberReader(new InputStreamReader(this.input, GeneralUtils.DEFAULT_ENCODING));
                Throwable throwable = null;
                Object var6_6 = null;
                try (FileOutputStream output = new FileOutputStream(this.outFile);){
                    String line;
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)output, GeneralUtils.DEFAULT_ENCODING));
                    while ((line = reader.readLine()) != null) {
                        long currentTime;
                        Matcher matcher = DEFINER_PATTER.matcher(line);
                        if (matcher.find()) {
                            line = matcher.replaceFirst("");
                        }
                        if ((currentTime = System.currentTimeMillis()) - prevStatusUpdateTime > 300L) {
                            this.monitor.subTask("Saved " + numberFormat.format(reader.getLineNumber()) + " lines");
                            prevStatusUpdateTime = currentTime;
                        }
                        line = this.filterLine(line);
                        writer.write(line);
                        writer.newLine();
                    }
                    writer.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                this.monitor.done();
            }
        }

        @NotNull
        private String filterLine(@NotNull String line) {
            return line;
        }
    }

    public static enum DumpMethod {
        ONLINE,
        LOCK_ALL_TABLES,
        NORMAL;

    }
}

