/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraintBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;

public class DBDDataFilter {
    private final List<DBDAttributeConstraint> constraints;
    private boolean anyConstraint;
    private String order;
    private String where;

    public DBDDataFilter() {
        this.constraints = new ArrayList<DBDAttributeConstraint>();
    }

    public DBDDataFilter(List<DBDAttributeConstraint> constraints) {
        this.constraints = constraints;
    }

    public DBDDataFilter(DBDDataFilter source) {
        this.constraints = new ArrayList<DBDAttributeConstraint>(source.constraints.size());
        for (DBDAttributeConstraint column : source.constraints) {
            this.constraints.add(new DBDAttributeConstraint(column));
        }
        this.order = source.order;
        this.where = source.where;
        this.anyConstraint = source.anyConstraint;
    }

    public List<DBDAttributeConstraint> getConstraints() {
        return this.constraints;
    }

    @Nullable
    public DBDAttributeConstraint getConstraint(DBDAttributeBinding binding) {
        for (DBDAttributeConstraint co : this.constraints) {
            if (co.getAttribute() != binding) continue;
            return co;
        }
        return null;
    }

    @Nullable
    public DBDAttributeConstraint getConstraint(DBSAttributeBase attribute, boolean metaChanged) {
        for (DBDAttributeConstraint co : this.constraints) {
            if (!co.matches(attribute, metaChanged)) continue;
            return co;
        }
        return null;
    }

    @Nullable
    public DBDAttributeConstraint getConstraint(String name) {
        for (DBDAttributeConstraint co : this.constraints) {
            if (!CommonUtils.equalObjects((Object)co.getAttributeName(), (Object)name)) continue;
            return co;
        }
        return null;
    }

    public void addConstraints(List<DBDAttributeConstraint> constraints) {
        this.constraints.addAll(constraints);
    }

    public List<DBSAttributeBase> getOrderedVisibleAttributes() {
        ArrayList<DBDAttributeConstraint> visibleConstraints = new ArrayList<DBDAttributeConstraint>();
        for (DBDAttributeConstraint constraint : this.constraints) {
            if (!constraint.isVisible()) continue;
            visibleConstraints.add(constraint);
        }
        visibleConstraints.sort(Comparator.comparingInt(DBDAttributeConstraintBase::getVisualPosition));
        ArrayList<DBSAttributeBase> attributes = new ArrayList<DBSAttributeBase>(visibleConstraints.size());
        for (DBDAttributeConstraint constraint : visibleConstraints) {
            attributes.add(constraint.getAttribute());
        }
        return attributes;
    }

    public boolean isAnyConstraint() {
        return this.anyConstraint;
    }

    public void setAnyConstraint(boolean anyConstraint) {
        this.anyConstraint = anyConstraint;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(@Nullable String order) {
        this.order = order;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(@Nullable String where) {
        this.where = where;
    }

    public boolean hasFilters() {
        if (!CommonUtils.isEmpty((String)this.order) || !CommonUtils.isEmpty((String)this.where)) {
            return true;
        }
        for (DBDAttributeConstraint constraint : this.constraints) {
            if (!constraint.hasFilter()) continue;
            return true;
        }
        return false;
    }

    public boolean hasConditions() {
        if (!CommonUtils.isEmpty((String)this.where)) {
            return true;
        }
        for (DBDAttributeConstraint constraint : this.constraints) {
            if (!constraint.hasCondition()) continue;
            return true;
        }
        return false;
    }

    public boolean hasOrdering() {
        if (!CommonUtils.isEmpty((String)this.order)) {
            return true;
        }
        for (DBDAttributeConstraint constraint : this.constraints) {
            if (constraint.getOrderPosition() <= 0) continue;
            return true;
        }
        return false;
    }

    public List<DBDAttributeConstraint> getOrderConstraints() {
        ArrayList<DBDAttributeConstraint> result = null;
        for (DBDAttributeConstraint constraint : this.constraints) {
            if (constraint.getOrderPosition() <= 0) continue;
            if (result == null) {
                result = new ArrayList<DBDAttributeConstraint>(this.constraints.size());
            }
            result.add(constraint);
        }
        if (result != null && result.size() > 1) {
            result.sort(Comparator.comparingInt(DBDAttributeConstraintBase::getOrderPosition));
        }
        return result == null ? Collections.emptyList() : result;
    }

    public int getMaxOrderingPosition() {
        int maxPosition = 0;
        for (DBDAttributeConstraint constraint : this.constraints) {
            if (constraint.getOrderPosition() <= maxPosition) continue;
            maxPosition = constraint.getOrderPosition();
        }
        return maxPosition;
    }

    public void resetOrderBy() {
        this.order = null;
        for (DBDAttributeConstraint constraint : this.constraints) {
            constraint.setOrderPosition(0);
            constraint.setOrderDescending(false);
        }
    }

    public void reset() {
        for (DBDAttributeConstraint constraint : this.constraints) {
            constraint.reset();
        }
        this.order = null;
        this.where = null;
    }

    public void bindAttributes(DBDAttributeBinding[] bindings) {
        for (DBDAttributeConstraint constr : this.constraints) {
            DBDAttributeBinding attrBinding = (DBDAttributeBinding)DBUtils.findObject((DBPNamedObject[])bindings, (String)constr.getAttributeName());
            if (attrBinding == null) continue;
            constr.setAttribute(attrBinding);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DBDDataFilter)) {
            return false;
        }
        DBDDataFilter source = (DBDDataFilter)obj;
        if (this.constraints.size() != source.constraints.size()) {
            return false;
        }
        if (this.anyConstraint != source.anyConstraint) {
            return false;
        }
        int i = 0;
        int orderColumnsSize = source.constraints.size();
        while (i < orderColumnsSize) {
            if (!this.constraints.get(i).equals(source.constraints.get(i))) {
                return false;
            }
            ++i;
        }
        return CommonUtils.equalObjects((Object)this.order, (Object)source.order) && CommonUtils.equalObjects((Object)this.where, (Object)source.where);
    }

    public boolean equalFilters(DBDDataFilter source, boolean compareOrders) {
        if (this.anyConstraint != source.anyConstraint) {
            return false;
        }
        if (this.constraints.size() != source.constraints.size()) {
            return false;
        }
        int i = 0;
        while (i < source.constraints.size()) {
            if (!this.constraints.get(i).equalFilters(source.constraints.get(i), compareOrders)) {
                return false;
            }
            ++i;
        }
        return CommonUtils.equalObjects((Object)this.order, (Object)source.order) && CommonUtils.equalObjects((Object)this.where, (Object)source.where);
    }

    public boolean equalVisibility(DBDDataFilter dataFilter) {
        if (dataFilter.constraints.size() != this.constraints.size()) {
            return false;
        }
        int i = 0;
        while (i < dataFilter.constraints.size()) {
            if (!this.constraints.get(i).equalVisibility(dataFilter.constraints.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasNameDuplicates(String name) {
        int count = 0;
        for (DBDAttributeConstraint c : this.constraints) {
            if (!name.equalsIgnoreCase(c.getAttributeName())) continue;
            ++count;
        }
        return count > 1;
    }

    public void serialize(Map<String, Object> state) {
    }
}

