/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.tools.fdw;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.wizard.IWizardPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreForeignTableManager;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableColumnManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreForeignDataWrapper;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableForeign;
import org.jkiss.dbeaver.ext.postgresql.model.fdw.FDWConfigDescriptor;
import org.jkiss.dbeaver.ext.postgresql.tools.fdw.PostgreFDWConfigWizardPageConfig;
import org.jkiss.dbeaver.ext.postgresql.tools.fdw.PostgreFDWConfigWizardPageFinal;
import org.jkiss.dbeaver.ext.postgresql.tools.fdw.PostgreFDWConfigWizardPageInput;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBStructUtils;
import org.jkiss.dbeaver.model.virtual.DBVContainer;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVEntityForeignKey;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.dialogs.BaseWizard;
import org.jkiss.dbeaver.ui.editors.SimpleCommandContext;
import org.jkiss.utils.CommonUtils;

class PostgreFDWConfigWizard
extends BaseWizard
implements DBPContextProvider {
    private static final Log log = Log.getLog(PostgreFDWConfigWizard.class);
    private PostgreFDWConfigWizardPageInput inputPage;
    private PostgreFDWConfigWizardPageConfig configPage;
    private PostgreDatabase database;
    private List<DBPDataSourceContainer> availableDataSources = null;
    private List<DBSEntity> proposedEntities = null;
    private List<DBNDatabaseNode> selectedEntities;
    private DBPDataSourceContainer selectedDataSource;
    private PostgreSchema selectedSchema;
    private FDWInfo selectedFDW;
    private String fdwServerId;
    private PropertySourceCustom fdwPropertySource;

    PostgreFDWConfigWizard(PostgreDatabase database) {
        this.setWindowTitle("Foreign Data Wrappers configurator");
        this.database = database;
        this.setNeedsProgressMonitor(true);
        this.fdwPropertySource = new PropertySourceCustom();
    }

    public PostgreDatabase getDatabase() {
        return this.database;
    }

    public PostgreSchema getSelectedSchema() {
        return this.selectedSchema;
    }

    public void setSelectedSchema(PostgreSchema selectedSchema) {
        this.selectedSchema = selectedSchema;
    }

    public FDWInfo getSelectedFDW() {
        return this.selectedFDW;
    }

    public void setSelectedFDW(FDWInfo selectedFDW) {
        this.selectedFDW = selectedFDW;
    }

    public String getFdwServerId() {
        return this.fdwServerId;
    }

    public void setFdwServerId(String fdwServerId) {
        this.fdwServerId = fdwServerId;
    }

    public PropertySourceCustom getFdwPropertySource() {
        return this.fdwPropertySource;
    }

    public void addPages() {
        this.inputPage = new PostgreFDWConfigWizardPageInput(this);
        this.configPage = new PostgreFDWConfigWizardPageConfig(this);
        this.addPage((IWizardPage)this.inputPage);
        this.addPage((IWizardPage)this.configPage);
        this.addPage((IWizardPage)new PostgreFDWConfigWizardPageFinal(this));
        super.addPages();
    }

    public List<DBPDataSourceContainer> getAvailableDataSources() {
        return this.availableDataSources == null ? Collections.emptyList() : this.availableDataSources;
    }

    public List<DBSEntity> getProposedEntities() {
        return this.proposedEntities == null ? Collections.emptyList() : this.proposedEntities;
    }

    public DBPDataSourceContainer getSelectedDataSource() {
        return this.selectedDataSource;
    }

    public List<DBNDatabaseNode> getSelectedEntities() {
        return this.selectedEntities == null ? Collections.emptyList() : this.selectedEntities;
    }

    public void setSelectedEntities(List<DBNDatabaseNode> entities) {
        this.selectedEntities = entities;
        this.selectedDataSource = entities.isEmpty() ? null : entities.get(0).getDataSourceContainer();
    }

    public void addAvailableDataSource(DBPDataSourceContainer dataSource) {
        this.availableDataSources.add(dataSource);
    }

    public void removeAvailableDataSource(DBPDataSourceContainer dataSource) {
        this.availableDataSources.remove(dataSource);
    }

    void collectAvailableDataSources(DBRProgressMonitor monitor) {
        if (this.availableDataSources != null) {
            return;
        }
        LinkedHashSet<DBPDataSourceContainer> dataSources = new LinkedHashSet<DBPDataSourceContainer>();
        LinkedHashSet<DBSEntity> entities = new LinkedHashSet<DBSEntity>();
        DBPDataSourceContainer curDataSource = this.database.getDataSource().getContainer();
        DBVModel vModel = curDataSource.getVirtualModel();
        monitor.beginTask("Check virtual foreign keys", 1);
        this.collectAvailableDataSources(monitor, (DBVContainer)vModel, dataSources, entities);
        monitor.done();
        DBNModel navModel = DBWorkbench.getPlatform().getNavigatorModel();
        Map grCache = DBVModel.getGlobalReferenceCache();
        monitor.beginTask("Check external references", grCache.size());
        for (Map.Entry grEntry : grCache.entrySet()) {
            DBNDataSource refDataSource = navModel.getDataSourceByPath(this.database.getDataSource().getContainer().getProject(), (String)grEntry.getKey());
            if (refDataSource != null && refDataSource.getDataSourceContainer() == curDataSource) {
                try {
                    for (DBVEntityForeignKey rfk : (List)grEntry.getValue()) {
                        monitor.subTask("Check " + rfk.getEntity().getFullyQualifiedName(DBPEvaluationContext.UI));
                        DBSEntity refEntity = rfk.getEntity().getRealEntity(monitor);
                        if (refEntity == null) continue;
                        dataSources.add(refEntity.getDataSource().getContainer());
                        entities.add(refEntity);
                    }
                }
                catch (DBException e) {
                    log.debug((Object)"Error getting referenced entity", (Throwable)e);
                }
            }
            monitor.worked(1);
        }
        monitor.done();
        this.availableDataSources = new ArrayList<DBPDataSourceContainer>(dataSources);
        this.proposedEntities = new ArrayList<DBSEntity>(entities);
    }

    private void collectAvailableDataSources(DBRProgressMonitor monitor, DBVContainer vContainer, Set<DBPDataSourceContainer> dataSources, Set<DBSEntity> entities) {
        for (DBVContainer childContainer : vContainer.getContainers()) {
            this.collectAvailableDataSources(monitor, childContainer, dataSources, entities);
        }
        for (DBVEntity vEntity : vContainer.getEntities()) {
            for (DBVEntityForeignKey fk : vEntity.getForeignKeys()) {
                DBPDataSourceContainer dataSource = fk.getAssociatedDataSource();
                if (dataSource == this.database.getDataSource().getContainer()) continue;
                dataSources.add(dataSource);
                try {
                    entities.add(fk.getAssociatedEntity(monitor));
                }
                catch (DBException e) {
                    log.debug((Object)"Error getting referenced entity", (Throwable)e);
                }
            }
        }
    }

    public boolean performFinish() {
        try {
            this.getRunnableContext().run(true, true, monitor -> {
                try {
                    this.installFDW(monitor);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            DBWorkbench.getPlatformUI().showError("Error generating FDW", "Error during FDW script execution", e.getTargetException());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private void installFDW(DBRProgressMonitor monitor) throws DBException {
        monitor.beginTask("Generate FDW script", 2);
        monitor.subTask("Read actions");
        List<DBEPersistAction> actions = this.generateScript(monitor);
        monitor.subTask("Execute script");
        DBCExecutionContext context = DBUtils.getDefaultContext((DBSObject)this.getDatabase(), (boolean)false);
        DBExecUtils.executeScript((DBRProgressMonitor)monitor, (DBCExecutionContext)context, (String)"Install FDW", actions);
    }

    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return DBUtils.getDefaultContext((DBSObject)this.database, (boolean)true);
    }

    List<DBEPersistAction> generateScript(DBRProgressMonitor monitor) throws DBException {
        PostgreDatabase database = this.getDatabase();
        PostgreDataSource curDataSource = database.getDataSource();
        ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
        FDWInfo selectedFDW = this.getSelectedFDW();
        PropertySourceCustom propertySource = this.getFdwPropertySource();
        Map propValues = propertySource.getPropertiesWithDefaults();
        String serverId = this.getFdwServerId();
        actions.add((DBEPersistAction)new SQLDatabasePersistActionComment((DBPDataSource)curDataSource, "CREATE EXTENSION " + selectedFDW.getId()));
        StringBuilder script = new StringBuilder();
        script.append("CREATE SERVER ").append(serverId).append("\n\tFOREIGN DATA WRAPPER ").append(selectedFDW.getId()).append("\n\tOPTIONS(");
        boolean firstProp = true;
        for (Map.Entry pe : propValues.entrySet()) {
            String propName = CommonUtils.toString(pe.getKey());
            String propValue = CommonUtils.toString(pe.getValue());
            if (CommonUtils.isEmpty((String)propName) || CommonUtils.isEmpty((String)propValue)) continue;
            if (!firstProp) {
                script.append(", ");
            }
            script.append(propName).append(" '").append(propValue).append("'");
            firstProp = false;
        }
        script.append(")");
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create extension", script.toString()));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("CREATE USER MAPPING FOR CURRENT_USER SERVER " + serverId));
        SimpleCommandContext commandContext = new SimpleCommandContext(this.getExecutionContext(), false);
        try {
            this.getSelectedFDW();
            HashMap<String, Boolean> options = new HashMap<String, Boolean>();
            options.put("skip.object.configuration", true);
            PostgreForeignTableManager tableManager = new PostgreForeignTableManager();
            PostgreTableColumnManager columnManager = new PostgreTableColumnManager();
            for (DBNDatabaseNode tableNode : this.getSelectedEntities()) {
                DBSEntity entity = (DBSEntity)tableNode.getObject();
                PostgreTableForeign pgTable = (PostgreTableForeign)tableManager.createNewObject(monitor, (DBECommandContext)commandContext, (Object)this.getSelectedSchema(), null, options);
                if (pgTable == null) {
                    log.error((Object)"Internal error while creating new table");
                    continue;
                }
                pgTable.setName(entity.getName());
                pgTable.setForeignServerName(serverId);
                pgTable.setForeignOptions(new String[0]);
                for (DBSEntityAttribute attr : CommonUtils.safeCollection((Collection)entity.getAttributes(monitor))) {
                    String defTypeName;
                    String plainTargetTypeName;
                    PostgreDataType dataType;
                    PostgreSchema catalogSchema = database.getCatalogSchema(monitor);
                    if (catalogSchema != null) {
                        catalogSchema.getDataTypes(monitor);
                    }
                    if ((dataType = database.getDataType(monitor, plainTargetTypeName = SQLUtils.stripColumnTypeModifiers((String)(defTypeName = DBStructUtils.mapTargetDataType((DBSObject)database, (DBSTypedObject)attr))))) == null) {
                        log.error((Object)("Data type '" + plainTargetTypeName + "' not found. Skip column mapping."));
                        continue;
                    }
                    PostgreTableColumn newColumn = (PostgreTableColumn)columnManager.createNewObject(monitor, (DBECommandContext)commandContext, (Object)pgTable, null, options);
                    assert (newColumn != null);
                    newColumn.setName(attr.getName());
                    newColumn.setDataType(dataType);
                }
                DBEPersistAction[] tableDDL = tableManager.getTableDDL(monitor, (DBSEntity)pgTable, options);
                Collections.addAll(actions, tableDDL);
            }
        }
        finally {
            commandContext.resetChanges(true);
        }
        return actions;
    }

    static class FDWInfo {
        PostgreForeignDataWrapper installedFDW;
        FDWConfigDescriptor fdwDescriptor;

        FDWInfo() {
        }

        String getId() {
            return this.installedFDW != null ? this.installedFDW.getName() : this.fdwDescriptor.getFdwId();
        }

        String getDescription() {
            return this.installedFDW != null ? this.installedFDW.getDescription() : this.fdwDescriptor.getDescription();
        }
    }
}

