/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core.application;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.application.DelayedEventsProcessor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.application.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.core.application.DBeaverCommandLine;
import org.jkiss.dbeaver.core.application.DBeaverSettingsImporter;
import org.jkiss.dbeaver.core.application.DBeaverSplashHandler;
import org.jkiss.dbeaver.core.application.rpc.DBeaverInstanceServer;
import org.jkiss.dbeaver.core.application.rpc.IInstanceController;
import org.jkiss.dbeaver.core.application.update.VersionUpdateDialog;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.impl.app.DefaultSecureStorage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.BaseApplicationImpl;
import org.jkiss.dbeaver.registry.BaseWorkspaceImpl;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DBeaverApplication
extends BaseApplicationImpl {
    private static final Log log;
    public static final String APPLICATION_PLUGIN_ID = "org.jkiss.dbeaver.core.application";
    public static final String WORKSPACE_DIR_LEGACY = "${user.home}/.dbeaver";
    public static final String WORKSPACE_DIR_4 = "${user.home}/.dbeaver4";
    public static final String WORKSPACE_DIR_6;
    public static final String DBEAVER_DATA_DIR = "DBeaverData";
    public static final String WORKSPACE_DIR_CURRENT;
    public static final String[] WORKSPACE_DIR_PREVIOUS;
    static final String VERSION_PROP_PRODUCT_NAME = "product-name";
    static final String VERSION_PROP_PRODUCT_VERSION = "product-version";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    static boolean WORKSPACE_MIGRATED;
    static DBeaverApplication instance;
    boolean reuseWorkspace = false;
    private IInstanceController instanceServer;
    private OutputStream debugWriter;
    private PrintStream oldSystemOut;
    private PrintStream oldSystemErr;
    private Display display = null;
    private boolean resetUIOnRestart;

    static {
        String workingDirectory;
        log = Log.getLog(DBeaverApplication.class);
        WORKSPACE_DIR_PREVIOUS = new String[]{WORKSPACE_DIR_4, WORKSPACE_DIR_LEGACY};
        WORKSPACE_MIGRATED = false;
        String osName = System.getProperty("os.name").toUpperCase();
        if (osName.contains("WIN")) {
            String appData = System.getenv("AppData");
            if (appData == null) {
                appData = System.getProperty("user.home");
            }
            workingDirectory = String.valueOf(appData) + "\\" + DBEAVER_DATA_DIR;
        } else if (osName.contains("MAC")) {
            workingDirectory = String.valueOf(System.getProperty("user.home")) + "/Library/" + DBEAVER_DATA_DIR;
        } else {
            String dataHome = System.getProperty("XDG_DATA_HOME");
            if (dataHome == null) {
                dataHome = String.valueOf(System.getProperty("user.home")) + "/.local/share";
            }
            String badWorkingDir = String.valueOf(dataHome) + "/." + DBEAVER_DATA_DIR;
            String goodWorkingDir = String.valueOf(dataHome) + "/" + DBEAVER_DATA_DIR;
            workingDirectory = !new File(goodWorkingDir).exists() && new File(badWorkingDir).exists() ? badWorkingDir : goodWorkingDir;
        }
        WORKSPACE_DIR_CURRENT = WORKSPACE_DIR_6 = new File(workingDirectory, "workspace6").getAbsolutePath();
    }

    public static DBeaverApplication getInstance() {
        return instance;
    }

    public Object start(IApplicationContext context) {
        instance = this;
        Location instanceLoc = Platform.getInstanceLocation();
        CommandLine commandLine = DBeaverCommandLine.getCommandLine();
        String defaultHomePath = WORKSPACE_DIR_CURRENT;
        if (instanceLoc.isSet()) {
            defaultHomePath = instanceLoc.getURL().getFile();
        }
        if (DBeaverCommandLine.handleCommandLine(commandLine, defaultHomePath)) {
            log.debug((Object)("Commands processed. Exit " + GeneralUtils.getProductName() + "."));
            return IApplication.EXIT_OK;
        }
        try {
            if (!instanceLoc.isSet() ? !this.setDefaultWorkspacePath(instanceLoc) : instanceLoc.isLocked() && !this.setDefaultWorkspacePath(instanceLoc)) {
                return IApplication.EXIT_OK;
            }
            if (!instanceLoc.isLocked()) {
                instanceLoc.lock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (DBeaverCommandLine.handleCustomParameters(commandLine)) {
            return IApplication.EXIT_OK;
        }
        this.updateSplashHandler();
        Runtime runtime = Runtime.getRuntime();
        DBeaverCore.setApplication((DBPApplication)this);
        this.initDebugWriter();
        log.debug((Object)(String.valueOf(GeneralUtils.getProductName()) + " " + GeneralUtils.getProductVersion() + " is starting"));
        log.debug((Object)("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")"));
        log.debug((Object)("Java version: " + System.getProperty("java.version") + " by " + System.getProperty("java.vendor") + " (" + System.getProperty("sun.arch.data.model") + "bit)"));
        log.debug((Object)("Install path: '" + SystemVariablesResolver.getInstallPath() + "'"));
        log.debug((Object)("Instance path: '" + instanceLoc.getURL() + "'"));
        log.debug((Object)("Memory available " + runtime.totalMemory() / 0x100000L + "Mb/" + runtime.maxMemory() / 0x100000L + "Mb"));
        DBeaverApplication.writeWorkspaceInfo();
        this.initializeApplication();
        this.instanceServer = DBeaverInstanceServer.startInstanceServer(commandLine, this.createInstanceController());
        PlatformUI.getPreferenceStore().setDefault("KEY_CONFIGURATION_ID", "org.jkiss.dbeaver.defaultKeyScheme");
        try {
            log.debug((Object)"Run workbench");
            this.getDisplay();
            int returnCode = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)this.createWorkbenchAdvisor());
            if (this.resetUIOnRestart) {
                this.resetUISettings(instanceLoc);
            }
            if (returnCode != 1) {
                Integer n = EXIT_OK;
                return n;
            }
            Integer n = EXIT_RELAUNCH.equals(Integer.getInteger(PROP_EXIT_CODE)) ? EXIT_RELAUNCH : EXIT_RESTART;
            return n;
        }
        catch (Throwable e) {
            log.debug((Object)"Internal error in workbench lifecycle", e);
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            this.shutdown();
            this.display.dispose();
            this.display = null;
        }
    }

    private void updateSplashHandler() {
        if (ArrayUtils.contains((Object[])Platform.getApplicationArgs(), (Object)"-nosplash")) {
            return;
        }
        try {
            this.getDisplay();
            Shell shell = WorkbenchPlugin.getSplashShell((Display)this.display);
            if (shell != null) {
                shell.setText(ChooseWorkspaceDialog.getWindowTitle());
                shell.setImages(Window.getDefaultImages());
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.err.println("Error updating splash shell");
        }
        Log.addListener((message, t) -> DBeaverSplashHandler.showMessage(CommonUtils.toString((Object)message)));
    }

    protected IInstanceController createInstanceController() {
        return new DBeaverInstanceServer();
    }

    private void resetUISettings(Location instanceLoc) {
        try {
            File settingsFile;
            File instanceDir = new File(instanceLoc.getURL().toURI());
            if (instanceDir.exists() && (settingsFile = new File(instanceDir, ".metadata/.plugins/org.eclipse.e4.workbench/workbench.xmi")).exists()) {
                settingsFile.deleteOnExit();
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error resetting UI settings", e);
        }
    }

    protected void initializeApplication() {
    }

    private Display getDisplay() {
        if (this.display == null) {
            log.debug((Object)"Create display");
            Display.setAppName((String)GeneralUtils.getProductName());
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = PlatformUI.createDisplay();
            }
            new DelayedEventsProcessor(this.display);
        }
        return this.display;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setDefaultWorkspacePath(Location instanceLoc) {
        String defaultHomePath = WORKSPACE_DIR_CURRENT;
        File homeDir = new File(defaultHomePath);
        try {
            if (!homeDir.exists() || ArrayUtils.isEmpty((Object[])homeDir.listFiles())) {
                DBeaverSettingsImporter importer;
                File previousVersionWorkspaceDir = null;
                String[] stringArray = WORKSPACE_DIR_PREVIOUS;
                int n = WORKSPACE_DIR_PREVIOUS.length;
                int n2 = 0;
                while (n2 < n) {
                    String oldDir = stringArray[n2];
                    File oldWorkspaceDir = new File(oldDir = GeneralUtils.replaceSystemPropertyVariables((String)oldDir));
                    if (oldWorkspaceDir.exists() && GeneralUtils.getMetadataFolder((File)oldWorkspaceDir).exists()) {
                        previousVersionWorkspaceDir = oldWorkspaceDir;
                        break;
                    }
                    ++n2;
                }
                if (previousVersionWorkspaceDir != null && !(importer = new DBeaverSettingsImporter(this, this.getDisplay())).migrateFromPreviousVersion(previousVersionWorkspaceDir, homeDir)) {
                    return false;
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error migrating old workspace version", e);
        }
        try {
            URL defaultHomeURL = new URL("file", null, defaultHomePath);
            boolean keepTrying = true;
            while (true) {
                if (!keepTrying) {
                    return true;
                }
                if (!instanceLoc.isLocked()) {
                    if (instanceLoc.set(defaultHomeURL, true)) return true;
                }
                if (this.reuseWorkspace) {
                    instanceLoc.set(defaultHomeURL, false);
                    return true;
                }
                int msgResult = this.showMessageBox("DBeaver - Can't lock workspace", "Can't lock workspace at " + defaultHomePath + ".\n" + "It seems that you have another DBeaver instance running.\n" + "You may ignore it and work without lock but it is recommended to shutdown previous instance otherwise you may corrupt workspace data.", 3592);
                switch (msgResult) {
                    case 512: {
                        return false;
                    }
                    case 2048: {
                        instanceLoc.set(defaultHomeURL, false);
                        return true;
                    }
                }
            }
        }
        catch (Throwable e) {
            System.err.println("Can't switch workspace to '" + defaultHomePath + "' - " + e.getMessage());
        }
        return true;
    }

    public static void writeWorkspaceInfo() {
        File metadataFolder = GeneralUtils.getMetadataFolder();
        Properties props = BaseWorkspaceImpl.readWorkspaceInfo((File)metadataFolder);
        props.setProperty(VERSION_PROP_PRODUCT_NAME, GeneralUtils.getProductName());
        props.setProperty(VERSION_PROP_PRODUCT_VERSION, GeneralUtils.getProductVersion().toString());
        BaseWorkspaceImpl.writeWorkspaceInfo((File)metadataFolder, (Properties)props);
    }

    @NotNull
    protected ApplicationWorkbenchAdvisor createWorkbenchAdvisor() {
        return new ApplicationWorkbenchAdvisor();
    }

    public void stop() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        display.syncExec(() -> {
            if (!display.isDisposed()) {
                workbench.close();
            }
        });
    }

    private void shutdown() {
        log.debug((Object)"DBeaver is stopping");
        try {
            try {
                this.instanceServer = null;
                DBeaverInstanceServer.stopInstanceServer();
            }
            catch (Throwable e) {
                log.error((Object)e);
                instance = null;
                this.stopDebugWriter();
            }
        }
        finally {
            instance = null;
            this.stopDebugWriter();
        }
    }

    private void initDebugWriter() {
        File debugLogFile;
        DBPPreferenceStore preferenceStore = DBeaverCore.getGlobalPreferenceStore();
        if (!preferenceStore.getBoolean("logs.debug.enabled")) {
            return;
        }
        String logLocation = preferenceStore.getString("logs.debug.location");
        if (CommonUtils.isEmpty((String)logLocation)) {
            logLocation = new File(GeneralUtils.getMetadataFolder(), "dbeaver-debug.log").getAbsolutePath();
        }
        if ((debugLogFile = new File(logLocation = GeneralUtils.replaceVariables((String)logLocation, (IVariableResolver)new SystemVariablesResolver()))).exists() && !debugLogFile.delete()) {
            System.err.println("Can't delete debug log file");
            return;
        }
        try {
            this.debugWriter = new FileOutputStream(debugLogFile);
            this.oldSystemOut = System.out;
            this.oldSystemErr = System.err;
            System.setOut(new PrintStream(new ProxyPrintStream(this.debugWriter, this.oldSystemOut)));
            System.setErr(new PrintStream(new ProxyPrintStream(this.debugWriter, this.oldSystemErr)));
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void stopDebugWriter() {
        if (this.oldSystemOut != null) {
            System.setOut(this.oldSystemOut);
        }
        if (this.oldSystemErr != null) {
            System.setErr(this.oldSystemErr);
        }
        if (this.debugWriter != null) {
            IOUtils.close((Closeable)this.debugWriter);
            this.debugWriter = null;
        }
    }

    IInstanceController getInstanceServer() {
        return this.instanceServer;
    }

    private static File getDefaultWorkspaceLocation(String path) {
        return new File(System.getProperty("user.home"), path);
    }

    public boolean isStandalone() {
        return true;
    }

    @NotNull
    public DBASecureStorage getSecureStorage() {
        return DefaultSecureStorage.INSTANCE;
    }

    public String getInfoDetails() {
        return null;
    }

    public String getDefaultProjectName() {
        return "General";
    }

    private int showMessageBox(String title, String message, int style) {
        Shell shell = new Shell(this.getDisplay(), 16384);
        shell.setText(GeneralUtils.getProductTitle());
        MessageBox messageBox = new MessageBox(shell, style);
        messageBox.setText(title);
        messageBox.setMessage(message);
        int msgResult = messageBox.open();
        shell.dispose();
        return msgResult;
    }

    public void notifyVersionUpgrade(VersionDescriptor currentVersion, VersionDescriptor newVersion, boolean showSkip) {
        VersionUpdateDialog dialog = new VersionUpdateDialog(UIUtils.getActiveWorkbenchShell(), currentVersion, newVersion, showSkip);
        dialog.open();
    }

    public void setResetUIOnRestart(boolean resetUIOnRestart) {
        this.resetUIOnRestart = resetUIOnRestart;
    }

    private class ProxyPrintStream
    extends OutputStream {
        private final OutputStream debugWriter;
        private final OutputStream stdOut;

        ProxyPrintStream(OutputStream debugWriter, OutputStream stdOut) {
            this.debugWriter = debugWriter;
            this.stdOut = stdOut;
        }

        @Override
        public void write(int b) throws IOException {
            this.debugWriter.write(b);
            this.stdOut.write(b);
        }
    }
}

