/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerProcedure;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSynonym;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableCheckConstraint;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableTrigger;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableUniqueKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerView;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public enum SQLServerObjectType implements DBSObjectType
{
    AF("AF", null, (DBPImage)DBIcon.TREE_FUNCTION, "Aggregate function (CLR)"),
    C("C", SQLServerTableCheckConstraint.class, (DBPImage)DBIcon.TREE_CONSTRAINT, "CHECK constraint"),
    D("D", null, (DBPImage)DBIcon.TREE_CONSTRAINT, "DEFAULT (constraint or stand-alone)"),
    F("F", SQLServerTableForeignKey.class, (DBPImage)DBIcon.TREE_CONSTRAINT, "FOREIGN KEY constraint"),
    FN("FN", SQLServerProcedure.class, (DBPImage)DBIcon.TREE_FUNCTION, "SQL scalar function"),
    FS("FS", SQLServerProcedure.class, (DBPImage)DBIcon.TREE_FUNCTION, "Assembly (CLR) scalar-function"),
    FT("FT", SQLServerProcedure.class, (DBPImage)DBIcon.TREE_FUNCTION, "Assembly (CLR) table-valued function"),
    IF("IF", SQLServerProcedure.class, (DBPImage)DBIcon.TREE_FUNCTION, "SQL inline table-valued function"),
    IT("IT", SQLServerTable.class, (DBPImage)DBIcon.TREE_TABLE_SYSTEM, "Internal table"),
    P("P", SQLServerProcedure.class, (DBPImage)DBIcon.TREE_PROCEDURE, "SQL Stored Procedure"),
    PC("PC", SQLServerProcedure.class, (DBPImage)DBIcon.TREE_PROCEDURE, "Assembly (CLR) stored-procedure"),
    PG("PG", null, null, "Plan guide"),
    PK("PK", SQLServerTableUniqueKey.class, (DBPImage)DBIcon.TREE_UNIQUE_KEY, "PRIMARY KEY constraint"),
    R("R", null, null, "Rule (old-style, stand-alone)"),
    RF("RF", null, (DBPImage)DBIcon.TREE_PROCEDURE, "Replication-filter-procedure"),
    S("S", SQLServerTable.class, (DBPImage)DBIcon.TREE_TABLE, "System base table"),
    SN("SN", SQLServerSynonym.class, (DBPImage)DBIcon.TREE_SYNONYM, "Synonym"),
    SQ("SQ", null, null, "Service queue"),
    TA("TA", null, (DBPImage)DBIcon.TREE_TRIGGER, "Assembly (CLR) DML trigger"),
    TF("TF", SQLServerProcedure.class, (DBPImage)DBIcon.TREE_FUNCTION, "SQL table-valued-function"),
    TR("TR", SQLServerTableTrigger.class, (DBPImage)DBIcon.TREE_TRIGGER, "SQL DML trigger"),
    TT("TT", null, (DBPImage)DBIcon.TREE_DATA_TYPE, "Table type"),
    U("U", SQLServerTable.class, (DBPImage)DBIcon.TREE_TABLE, "Table (user-defined)"),
    UQ("UQ", SQLServerTableUniqueKey.class, (DBPImage)DBIcon.TREE_CONSTRAINT, "UNIQUE constraint"),
    V("V", SQLServerView.class, (DBPImage)DBIcon.TREE_VIEW, "View"),
    X("X", SQLServerProcedure.class, (DBPImage)DBIcon.TREE_PROCEDURE, "Extended stored procedure");

    private final String type;
    private final String description;
    private final Class<? extends DBSObject> theClass;
    private final DBPImage icon;
    private static final Log log;

    static {
        log = Log.getLog(SQLServerObjectType.class);
    }

    private SQLServerObjectType(String type, Class<? extends DBSObject> theClass, DBPImage icon, String description) {
        this.type = type;
        this.theClass = theClass;
        this.icon = icon;
        this.description = description;
    }

    public String getTypeName() {
        return this.description;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getImage() {
        return this.icon;
    }

    public Class<? extends DBSObject> getTypeClass() {
        return this.theClass;
    }

    public String getTypeID() {
        return this.type;
    }

    public String toString() {
        return this.type;
    }

    public DBSObject findObject(DBRProgressMonitor monitor, SQLServerDatabase database, SQLServerSchema schema, String objectName) throws DBException {
        if (schema == null) {
            log.debug((Object)("Null schema in table " + objectName + " search (" + this.name() + ")"));
            return null;
        }
        if (SQLServerTableBase.class.isAssignableFrom(this.theClass)) {
            return schema.getChild(monitor, objectName);
        }
        if (SQLServerProcedure.class.isAssignableFrom(this.theClass)) {
            return schema.getProcedure(monitor, objectName);
        }
        log.debug((Object)("Unsupported object for SQL Server search: " + this.name()));
        return null;
    }

    public static List<SQLServerObjectType> getTypesForClass(Class<?> theClass) {
        ArrayList<SQLServerObjectType> result = new ArrayList<SQLServerObjectType>();
        SQLServerObjectType[] sQLServerObjectTypeArray = SQLServerObjectType.values();
        int n = sQLServerObjectTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SQLServerObjectType ot = sQLServerObjectTypeArray[n2];
            if (ot.theClass == theClass) {
                result.add(ot);
            }
            ++n2;
        }
        return result;
    }
}

