/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.formatter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataFormatterSample;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;

public class DataFormatterDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(DataFormatterDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.dataFormatter";
    private String id;
    private String name;
    private String description;
    private List<DBPPropertyDescriptor> properties = new ArrayList<DBPPropertyDescriptor>();
    private DBDDataFormatterSample sample;
    private AbstractDescriptor.ObjectType formatterType;

    public DataFormatterDescriptor(IConfigurationElement config) {
        super(config);
        IConfigurationElement[] propElements;
        this.id = config.getAttribute("id");
        this.formatterType = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.name = config.getAttribute("label");
        this.description = config.getAttribute("description");
        IConfigurationElement[] iConfigurationElementArray = propElements = config.getChildren("propertyGroup");
        int n = propElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement prop = iConfigurationElementArray[n2];
            this.properties.addAll(PropertyDescriptor.extractProperties(prop));
            ++n2;
        }
        Class<?> objectClass = this.getObjectClass(config.getAttribute("sampleClass"));
        try {
            this.sample = (DBDDataFormatterSample)objectClass.newInstance();
        }
        catch (Exception exception) {
            log.error("Can't instantiate data formatter '" + this.getId() + "' sample");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DBDDataFormatterSample getSample() {
        return this.sample;
    }

    public List<DBPPropertyDescriptor> getProperties() {
        return this.properties;
    }

    public DBDDataFormatter createFormatter() throws IllegalAccessException, InstantiationException {
        Class<DBDDataFormatter> clazz = this.formatterType.getObjectClass(DBDDataFormatter.class);
        if (clazz == null) {
            return null;
        }
        return clazz.newInstance();
    }
}

