/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.data;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraintBase;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;

public class DBDAttributeConstraint
extends DBDAttributeConstraintBase {
    @Nullable
    private DBSAttributeBase attribute;
    private String attributeName;
    private int originalVisualPosition;

    public DBDAttributeConstraint(@NotNull DBDAttributeBinding attribute) {
        this.setAttribute(attribute);
        this.setVisualPosition(attribute.getOrdinalPosition());
    }

    public DBDAttributeConstraint(@NotNull DBSAttributeBase attribute, int visualPosition) {
        this.setAttribute(attribute);
        this.setVisualPosition(visualPosition);
    }

    public DBDAttributeConstraint(@NotNull String attributeName, int originalVisualPosition) {
        this.attribute = null;
        this.attributeName = attributeName;
        this.originalVisualPosition = originalVisualPosition;
    }

    public DBDAttributeConstraint(@NotNull DBDAttributeConstraint source) {
        super(source);
        this.attribute = source.attribute;
        this.attributeName = source.attributeName;
        this.originalVisualPosition = source.originalVisualPosition;
    }

    public static boolean isVisibleByDefault(DBDAttributeBinding binding) {
        return !binding.isPseudoAttribute();
    }

    @Nullable
    public DBSAttributeBase getAttribute() {
        return this.attribute;
    }

    void setAttribute(@NotNull DBSAttributeBase binding) {
        this.attribute = binding;
        this.attributeName = this.attribute.getName();
        this.originalVisualPosition = this.attribute.getOrdinalPosition();
    }

    @NotNull
    public String getAttributeName() {
        return this.attributeName;
    }

    @NotNull
    public String getFullAttributeName() {
        return this.attribute == null ? this.attributeName : DBUtils.getObjectFullName(this.attribute, DBPEvaluationContext.DML);
    }

    public int getOriginalVisualPosition() {
        return this.originalVisualPosition;
    }

    @Override
    public boolean hasFilter() {
        return super.hasFilter() || this.getVisualPosition() != NULL_VISUAL_POSITION && this.originalVisualPosition != this.getVisualPosition();
    }

    @Override
    public void reset() {
        super.reset();
        this.setVisualPosition(this.originalVisualPosition);
    }

    @Override
    public boolean equalFilters(DBDAttributeConstraintBase obj, boolean compareOrders) {
        return obj instanceof DBDAttributeConstraint && CommonUtils.equalObjects((Object)this.attribute, (Object)((DBDAttributeConstraint)obj).attribute) && super.equalFilters(obj, compareOrders);
    }

    @Override
    public int hashCode() {
        return this.attributeName.hashCode() + this.getVisualPosition();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof DBDAttributeConstraint) {
            DBDAttributeConstraint source = (DBDAttributeConstraint)obj;
            return CommonUtils.equalObjects((Object)this.attribute, (Object)source.attribute) && super.equals(obj);
        }
        return false;
    }

    public String toString() {
        String clause = this.getOperator() == null ? (this.getCriteria() == null ? "" : this.getCriteria()) : String.valueOf(this.isReverseOperator() ? "NOT " : "") + this.getOperator().getStringValue() + " " + this.getValue();
        return String.valueOf(this.attributeName) + " " + clause;
    }

    public boolean matches(DBSAttributeBase attr, boolean matchByName) {
        return this.attribute == attr || this.attribute instanceof DBDAttributeBinding && ((DBDAttributeBinding)this.attribute).matches(attr, matchByName);
    }
}

