/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreConstants;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.LongKeyMap;

public class PostgreDataTypeCache
extends JDBCObjectCache<PostgreSchema, PostgreDataType> {
    private LongKeyMap<PostgreDataType> dataTypeMap = new LongKeyMap();

    PostgreDataTypeCache() {
        this.setListOrderComparator(DBUtils.nameComparator());
    }

    protected String getCacheName() {
        return "Data type cache";
    }

    protected synchronized void loadObjects(DBRProgressMonitor monitor, PostgreSchema postgreSchema) throws DBException {
        super.loadObjects(monitor, (DBSObject)postgreSchema);
        if (postgreSchema.isCatalogSchema()) {
            this.mapDataTypeAliases(PostgreConstants.DATA_TYPE_ALIASES);
            this.mapDataTypeAliases(PostgreConstants.SERIAL_TYPES);
        }
    }

    private void mapDataTypeAliases(Map<String, String> aliases) {
        for (Map.Entry<String, String> aliasMapping : aliases.entrySet()) {
            PostgreDataType realType = (PostgreDataType)this.getCachedObject(aliasMapping.getValue());
            if (realType == null) continue;
            PostgreDataType serialType = new PostgreDataType(realType, aliasMapping.getKey());
            this.cacheObject(serialType);
        }
    }

    public void clearCache() {
        super.clearCache();
        this.dataTypeMap.clear();
    }

    public void removeObject(@NotNull PostgreDataType object, boolean resetFullCache) {
        super.removeObject((DBSObject)object, resetFullCache);
        this.dataTypeMap.remove(object.getObjectId());
    }

    public void cacheObject(@NotNull PostgreDataType object) {
        if (this.getCachedObject(object.getName()) == null) {
            super.cacheObject((DBSObject)object);
            if (!object.isAlias()) {
                this.dataTypeMap.put(object.getObjectId(), (Object)object);
            }
        }
    }

    public void setCache(List<PostgreDataType> postgreDataTypes) {
        super.setCache(postgreDataTypes);
        for (PostgreDataType dt : postgreDataTypes) {
            if (dt.isAlias()) continue;
            this.dataTypeMap.put(dt.getObjectId(), (Object)dt);
        }
    }

    @NotNull
    protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull PostgreSchema owner) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t.oid,t.*,c.relkind \nFROM pg_catalog.pg_type t\nLEFT OUTER JOIN pg_class c ON c.oid=t.typrelid\nWHERE typnamespace=? ");
        if (PostgreUtils.supportsTypeCategory(session.getDataSource())) {
            sql.append("AND t.typcategory <> 'A'");
        }
        sql.append("\nORDER by t.oid");
        JDBCPreparedStatement dbStat = session.prepareStatement(sql.toString());
        dbStat.setLong(1, owner.getObjectId());
        return dbStat;
    }

    protected PostgreDataType fetchObject(@NotNull JDBCSession session, @NotNull PostgreSchema owner, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        return PostgreDataType.readDataType(session, owner, dbResult, true);
    }

    protected void invalidateObjects(DBRProgressMonitor monitor, PostgreSchema postgreSchema, Iterator<PostgreDataType> objectIter) {
        while (objectIter.hasNext()) {
            PostgreDataType dt = objectIter.next();
            dt.resolveValueTypeFromBaseType(monitor);
        }
    }

    public PostgreDataType getDataType(long oid) {
        return (PostgreDataType)this.dataTypeMap.get(oid);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static PostgreDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDatabase database, long oid) throws SQLException, DBException {
        var4_3 = null;
        var5_5 = null;
        try {
            session = database.getDefaultContext(true).openSession(monitor, DBCExecutionPurpose.META, "Resolve data type by OID");
            try {
                var7_8 = null;
                var8_10 = null;
                try {
                    dbStat = session.prepareStatement("SELECT t.oid,t.*,c.relkind FROM pg_catalog.pg_type t\nLEFT OUTER JOIN pg_class c ON c.oid=t.typrelid\nWHERE t.oid=? ");
                    try {
                        dbStat.setLong(1, oid);
                        var10_13 = null;
                        var11_15 = null;
                        try {
                            block25: {
                                dbResult = dbStat.executeQuery();
                                try {
                                    if (dbResult.next()) {
                                        schemaOid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"typnamespace");
                                        schema = database.getSchema(monitor, schemaOid);
                                        if (schema == null) {
                                            throw new DBException("Schema " + schemaOid + " not found for data type " + oid);
                                        }
                                        dataType = PostgreDataType.readDataType(session, schema, dbResult, false);
                                        if (dataType != null) {
                                            v0 = dataType;
                                            if (dbResult == null) break block25;
                                        }
                                    }
                                    ** GOTO lbl-1000
                                }
                                catch (Throwable var10_14) {
                                    if (dbResult == null) throw var10_14;
                                    dbResult.close();
                                    throw var10_14;
                                }
                                dbResult.close();
                            }
                            if (dbStat == null) return v0;
                        }
                        catch (Throwable var11_16) {
                            if (var10_13 == null) {
                                var10_13 = var11_16;
                                throw var10_13;
                            }
                            if (var10_13 == var11_16) throw var10_13;
                            var10_13.addSuppressed(var11_16);
                            throw var10_13;
                        }
                    }
                    catch (Throwable var7_9) {
                        if (dbStat == null) throw var7_9;
                        dbStat.close();
                        throw var7_9;
                    }
                    dbStat.close();
                    return v0;
                }
                catch (Throwable var8_11) {
                    if (var7_8 == null) {
                        var7_8 = var8_11;
                        throw var7_8;
                    }
                    if (var7_8 == var8_11) throw var7_8;
                    var7_8.addSuppressed(var8_11);
                    throw var7_8;
                }
lbl-1000:
                // 1 sources

                {
                    throw new DBException("Data type " + oid + " not found in database " + database.getName());
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Throwable var5_6) {
            if (var4_3 == null) {
                var4_3 = var5_6;
                throw var4_3;
            }
            if (var4_3 == var5_6) throw var4_3;
            var4_3.addSuppressed(var5_6);
            throw var4_3;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    static PostgreDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull PostgreDatabase database, String name) throws SQLException, DBException {
        var3_3 = null;
        var4_5 = null;
        try {
            session = database.getDefaultContext(true).openSession(monitor, DBCExecutionPurpose.META, "Resolve data type by name");
            try {
                var6_8 = null;
                var7_10 = null;
                try {
                    dbStat = session.prepareStatement("SELECT t.oid,t.* FROM pg_catalog.pg_type t\nLEFT OUTER JOIN pg_class c ON c.oid=t.typrelid\nWHERE t.typname=? ");
                    try {
                        dbStat.setString(1, name);
                        var9_13 = null;
                        var10_15 = null;
                        try {
                            block24: {
                                dbResult = dbStat.executeQuery();
                                try {
                                    if (dbResult.next()) {
                                        schemaOid = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"typnamespace");
                                        schema = database.getSchema(monitor, schemaOid);
                                        if (schema == null) {
                                            throw new DBException("Schema " + schemaOid + " not found for data type " + name);
                                        }
                                        v0 = PostgreDataType.readDataType(session, schema, dbResult, false);
                                        if (dbResult == null) break block24;
                                    }
                                    ** GOTO lbl-1000
                                }
                                catch (Throwable var9_14) {
                                    if (dbResult == null) throw var9_14;
                                    dbResult.close();
                                    throw var9_14;
                                }
                                dbResult.close();
                            }
                            if (dbStat == null) return v0;
                        }
                        catch (Throwable var10_16) {
                            if (var9_13 == null) {
                                var9_13 = var10_16;
                                throw var9_13;
                            }
                            if (var9_13 == var10_16) throw var9_13;
                            var9_13.addSuppressed(var10_16);
                            throw var9_13;
                        }
                    }
                    catch (Throwable var6_9) {
                        if (dbStat == null) throw var6_9;
                        dbStat.close();
                        throw var6_9;
                    }
                    dbStat.close();
                    return v0;
                }
                catch (Throwable var7_11) {
                    if (var6_8 == null) {
                        var6_8 = var7_11;
                        throw var6_8;
                    }
                    if (var6_8 == var7_11) throw var6_8;
                    var6_8.addSuppressed(var7_11);
                    throw var6_8;
                }
lbl-1000:
                // 1 sources

                {
                    throw new DBException("Data type " + name + " not found in database " + database.getName());
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Throwable var4_6) {
            if (var3_3 == null) {
                var3_3 = var4_6;
                throw var3_3;
            }
            if (var3_3 == var4_6) throw var3_3;
            var3_3.addSuppressed(var4_6);
            throw var3_3;
        }
    }
}

