/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.tools.maintenance.TableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;
import org.jkiss.utils.CommonUtils;

public class MySQLToolCheck
implements IUserInterfaceTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        List tables = CommonUtils.filterCollection(objects, MySQLTable.class);
        if (!tables.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), tables);
            dialog.open();
        }
    }

    static class SQLDialog
    extends TableToolDialog {
        private Combo optionCombo;

        public SQLDialog(IWorkbenchPartSite partSite, Collection<MySQLTable> selectedTables) {
            super(partSite, "Check table(s)", selectedTables);
        }

        protected void generateObjectCommand(List<String> lines, MySQLTable object) {
            String sql = "CHECK TABLE " + object.getFullyQualifiedName(DBPEvaluationContext.DDL);
            String option = this.optionCombo.getText();
            if (!CommonUtils.isEmpty((String)option)) {
                sql = String.valueOf(sql) + " " + option;
            }
            lines.add(sql);
        }

        protected void createControls(Composite parent) {
            Group optionsGroup = UIUtils.createControlGroup((Composite)parent, (String)"Options", (int)1, (int)0, (int)0);
            optionsGroup.setLayoutData((Object)new GridData(768));
            this.optionCombo = UIUtils.createLabelCombo((Composite)optionsGroup, (String)"Option", (int)12);
            this.optionCombo.add("");
            this.optionCombo.add("FOR UPGRADE");
            this.optionCombo.add("QUICK");
            this.optionCombo.add("FAST");
            this.optionCombo.add("MEDIUM");
            this.optionCombo.add("EXTENDED");
            this.optionCombo.add("CHANGED");
            this.optionCombo.addSelectionListener(this.SQL_CHANGE_LISTENER);
            this.createObjectsSelector(parent);
        }
    }
}

