/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConnectionLostDialog;
import org.jkiss.dbeaver.ui.editors.DatabaseNodeEditorInput;
import org.jkiss.dbeaver.ui.editors.ErrorEditorInput;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseLazyEditorInput
implements IDatabaseEditorInput {
    private final DBPDataSourceContainer dataSource;
    private final DBPProject project;
    private final String nodePath;
    private final String nodeName;
    private final String activePageId;
    private final String activeFolderId;

    public DatabaseLazyEditorInput(DBPDataSourceContainer dataSource, DBPProject project, String nodePath, String nodeName, String activePageId, String activeFolderId) {
        this.dataSource = dataSource;
        this.project = project;
        this.nodePath = nodePath;
        if (nodeName == null) {
            int divPos = nodePath.lastIndexOf(47);
            nodeName = divPos == -1 ? nodePath : nodePath.substring(divPos + 1);
        }
        this.nodeName = nodeName;
        this.activePageId = activePageId;
        this.activeFolderId = activeFolderId;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return DBeaverIcons.getImageDescriptor((DBPImage)this.dataSource.getDriver().getIcon());
    }

    public String getName() {
        return this.nodeName;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.nodeName;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public DBCExecutionContext getExecutionContext() {
        return null;
    }

    @Override
    public DBNDatabaseNode getNavigatorNode() {
        return null;
    }

    @Override
    public DBSObject getDatabaseObject() {
        return this.dataSource;
    }

    @Override
    public String getDefaultPageId() {
        return this.activePageId;
    }

    @Override
    public String getDefaultFolderId() {
        return this.activeFolderId;
    }

    @Override
    @Nullable
    public DBECommandContext getCommandContext() {
        return null;
    }

    @Override
    public Collection<String> getAttributeNames() {
        return Collections.emptyList();
    }

    @Override
    public Object getAttribute(String name) {
        return null;
    }

    @Override
    public Object setAttribute(String name, Object value) {
        return null;
    }

    @Override
    public DBPPropertySource getPropertySource() {
        return new PropertySourceCustom();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DatabaseLazyEditorInput) {
            DatabaseLazyEditorInput li = (DatabaseLazyEditorInput)obj;
            return this.dataSource == li.dataSource && this.project == li.project && CommonUtils.equalObjects((Object)this.nodePath, (Object)li.nodePath) && CommonUtils.equalObjects((Object)this.nodeName, (Object)li.nodeName) && CommonUtils.equalObjects((Object)this.activePageId, (Object)li.activePageId) && CommonUtils.equalObjects((Object)this.activeFolderId, (Object)li.activeFolderId);
        }
        return false;
    }

    public IDatabaseEditorInput initializeRealInput(DBRProgressMonitor monitor) throws DBException {
        DBNModel navigatorModel = DBWorkbench.getPlatform().getNavigatorModel();
        while (!this.dataSource.isConnected()) {
            boolean connected;
            try {
                connected = this.dataSource.connect(monitor, true, true);
            }
            catch (DBException e) {
                Integer result = (Integer)new UITask<Integer>(){

                    protected Integer runTask() {
                        ConnectionLostDialog clDialog = new ConnectionLostDialog(UIUtils.getActiveWorkbenchShell(), DatabaseLazyEditorInput.this.dataSource, (Throwable)e, "Close");
                        return clDialog.open();
                    }
                }.execute();
                if (result == 6) {
                    return null;
                }
                if (result == 8) continue;
                return new ErrorEditorInput(GeneralUtils.makeExceptionStatus((Throwable)e), navigatorModel.getNodeByObject((DBSObject)this.dataSource));
            }
            if (connected) break;
            throw new DBException("Connection to '" + this.dataSource.getName() + "' canceled");
        }
        try {
            DBNDataSource dsNode = (DBNDataSource)navigatorModel.getNodeByObject(monitor, (DBSObject)this.dataSource, true);
            if (dsNode == null) {
                throw new DBException("Datasource '" + this.dataSource.getName() + "' navigator node not found");
            }
            dsNode.initializeNode(monitor, null);
            DBNNode node = navigatorModel.getNodeByPath(monitor, this.project, this.nodePath);
            if (node == null) {
                throw new DBException("Navigator node '" + this.nodePath + "' not found");
            }
            if (node instanceof DBNDatabaseNode) {
                DatabaseNodeEditorInput realInput = new DatabaseNodeEditorInput((DBNDatabaseNode)node);
                realInput.setDefaultFolderId(this.activeFolderId);
                realInput.setDefaultPageId(this.activePageId);
                return realInput;
            }
            throw new DBException("Database node has bad type: " + node.getClass().getName());
        }
        catch (DBException e) {
            return new ErrorEditorInput(GeneralUtils.makeExceptionStatus((Throwable)e), navigatorModel.getNodeByObject((DBSObject)this.dataSource));
        }
    }
}

