/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.tools;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardDialog;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.connection.ClientHomesSelector;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractToolWizard;
import org.jkiss.dbeaver.ui.internal.UIMessages;

public class ToolWizardDialog
extends ActiveWizardDialog {
    public static final int CLIENT_CONFIG_ID = 1000;

    public ToolWizardDialog(IWorkbenchWindow window, IWizard wizard) {
        super(window, wizard);
        this.setShellStyle(0xCF0 | ToolWizardDialog.getDefaultOrientation());
        this.setHelpAvailable(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        boolean nativeClientRequired;
        if (this.getWizard() instanceof AbstractToolWizard && (nativeClientRequired = ((AbstractToolWizard)this.getWizard()).isNativeClientHomeRequired())) {
            parent.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            Button configButton = this.createButton(parent, 1000, "  Client configuration ...  ", false);
            configButton.setLayoutData((Object)new GridData(32));
            Label spacer = new Label(parent, 0);
            spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            ++((GridLayout)parent.getLayout()).numColumns;
            ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        }
        super.createButtonsForButtonBar(parent);
        Button cancelButton = this.getButton(1);
        cancelButton.setText(IDialogConstants.CLOSE_LABEL);
        Button finishButton = this.getButton(16);
        finishButton.setText(UIMessages.button_start);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1000) {
            this.openClientConfiguration();
        }
        super.buttonPressed(buttonId);
    }

    private void openClientConfiguration() {
        NativeClientConfigDialog dialog;
        AbstractToolWizard toolWizard = (AbstractToolWizard)this.getWizard();
        DBPDataSourceContainer dataSource = toolWizard.getDataSourceContainer();
        if (dataSource != null && (dialog = new NativeClientConfigDialog(this.getShell(), dataSource)).open() == 0) {
            toolWizard.updateErrorMessage();
            this.updateButtons();
        }
    }

    private static class NativeClientConfigDialog
    extends BaseDialog {
        private final DBPDataSourceContainer dataSource;
        private ClientHomesSelector homesSelector;

        public NativeClientConfigDialog(Shell parentShell, DBPDataSourceContainer dataSource) {
            super(parentShell, "Configure local client for " + dataSource.getName(), dataSource.getDriver().getIcon());
            this.dataSource = dataSource;
        }

        protected Composite createDialogArea(Composite parent) {
            Composite dialogArea = super.createDialogArea(parent);
            this.homesSelector = new ClientHomesSelector(dialogArea, 0, "Native client");
            this.homesSelector.populateHomes(this.dataSource.getDriver(), this.dataSource.getConnectionConfiguration().getClientHomeId(), true);
            this.homesSelector.getPanel().setLayoutData((Object)new GridData(768));
            return dialogArea;
        }

        protected void okPressed() {
            String selectedHome = this.homesSelector.getSelectedHome();
            this.dataSource.getConnectionConfiguration().setClientHomeId(selectedHome);
            this.dataSource.getRegistry().flushConfig();
            super.okPressed();
        }
    }
}

