/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.gis.GisAttribute;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.editors.StringInlineEditor;
import org.jkiss.dbeaver.ui.gis.IGeometryValueEditor;
import org.jkiss.dbeaver.ui.gis.IGeometryViewer;
import org.jkiss.dbeaver.ui.gis.panel.SelectCRSAction;
import org.locationtech.jts.geom.Geometry;

public class GISTextViewer
extends StringInlineEditor
implements IGeometryViewer,
IGeometryValueEditor {
    private static final Log log = Log.getLog(GISTextViewer.class);
    private int valueSRID;
    private ToolBarManager toolBarManager;

    public GISTextViewer(IValueController controller) {
        super(controller);
    }

    protected Control createControl(Composite editPlaceholder) {
        Composite composite = UIUtils.createPlaceholder((Composite)editPlaceholder, (int)1);
        CSSUtils.setCSSClass((Widget)composite, (String)"coloredByConnectionType");
        Composite controlPanel = UIUtils.createPlaceholder((Composite)composite, (int)1);
        controlPanel.setLayoutData((Object)new GridData(1808));
        controlPanel.setLayout((Layout)new FillLayout());
        Control textControl = super.createControl(controlPanel);
        Composite bottomPanel = UIUtils.createPlaceholder((Composite)composite, (int)1);
        bottomPanel.setLayoutData((Object)new GridData(768));
        CSSUtils.setCSSClass((Widget)bottomPanel, (String)"coloredByConnectionType");
        ToolBar bottomToolbar = new ToolBar(bottomPanel, 8519936);
        this.toolBarManager = new ToolBarManager(bottomToolbar);
        return textControl;
    }

    public void primeEditorValue(Object value) throws DBException {
        DBSTypedObject column;
        super.primeEditorValue(value);
        this.valueSRID = 0;
        if (value instanceof Geometry) {
            this.valueSRID = ((Geometry)value).getSRID();
        } else if (value instanceof DBGeometry) {
            this.valueSRID = ((DBGeometry)value).getSRID();
        }
        if (this.valueSRID == 0 && (column = this.valueController.getValueType()) instanceof GisAttribute) {
            this.valueSRID = ((GisAttribute)column).getAttributeGeometrySRID((DBRProgressMonitor)new VoidProgressMonitor());
        }
        this.updateToolBar();
    }

    private void updateToolBar() {
        this.toolBarManager.removeAll();
        this.toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new SelectCRSAction(this), (boolean)true));
        this.toolBarManager.update(true);
    }

    public Object extractEditorValue() throws DBCException {
        Object geometry = super.extractEditorValue();
        return geometry;
    }

    public void contributeActions(@NotNull IContributionManager manager, @NotNull IValueController controller) throws DBCException {
        super.contributeActions(manager, controller);
    }

    @Override
    public Control getEditorControl() {
        return this.getControl();
    }

    @Override
    public int getValueSRID() {
        return this.valueSRID;
    }

    @Override
    public void setValueSRID(int srid) {
        this.valueSRID = srid;
        try {
            Object geometry = this.extractEditorValue();
            if (geometry instanceof DBGeometry) {
                ((DBGeometry)geometry).setSRID(this.valueSRID);
            } else if (geometry instanceof Geometry) {
                ((Geometry)geometry).setSRID(this.valueSRID);
            }
            this.valueController.updateValue(geometry, false);
        }
        catch (DBCException e) {
            log.error((Object)e);
        }
        this.updateToolBar();
    }
}

