/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManagerOverrides;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class EditorMenuManager
extends SubMenuManager {
    private ArrayList<EditorMenuManager> wrappers;
    private boolean enabledAllowed = true;
    private Overrides overrides = new Overrides();

    public EditorMenuManager(IMenuManager mgr) {
        super(mgr);
    }

    public IContributionItem[] getItems() {
        return this.getParentMenuManager().getItems();
    }

    public IContributionManagerOverrides getOverrides() {
        return this.overrides;
    }

    public void prependToGroup(String groupName, IContributionItem item) {
        this.insertAfter(groupName, item);
    }

    public void appendToGroup(String groupName, IContributionItem item) {
        try {
            super.appendToGroup(groupName, item);
        }
        catch (RuntimeException e) {
            WorkbenchPlugin.log(e);
        }
    }

    public void setVisible(boolean visible, boolean forceVisibility) {
        if (visible) {
            if (forceVisibility) {
                if (!this.enabledAllowed) {
                    this.setEnabledAllowed(true);
                }
            } else if (this.enabledAllowed) {
                this.setEnabledAllowed(false);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (forceVisibility) {
            this.setVisible(false);
        } else {
            this.setEnabledAllowed(false);
        }
    }

    public void setEnabledAllowed(boolean enabledAllowed) {
        if (this.enabledAllowed == enabledAllowed) {
            return;
        }
        this.enabledAllowed = enabledAllowed;
        this.overrides.updateEnabledAllowed();
    }

    protected SubMenuManager wrapMenu(IMenuManager menu) {
        if (this.wrappers == null) {
            this.wrappers = new ArrayList();
        }
        EditorMenuManager manager = new EditorMenuManager(menu);
        this.wrappers.add(manager);
        return manager;
    }

    protected IAction[] getAllContributedActions() {
        HashSet<IAction> set = new HashSet<IAction>();
        this.getAllContributedActions(set);
        return set.toArray(new IAction[set.size()]);
    }

    protected void getAllContributedActions(HashSet<IAction> set) {
        IContributionItem[] iContributionItemArray = super.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            this.getAllContributedActions(set, item);
            ++n2;
        }
        if (this.wrappers == null) {
            return;
        }
        for (EditorMenuManager element : this.wrappers) {
            element.getAllContributedActions(set);
        }
    }

    protected void getAllContributedActions(HashSet<IAction> set, IContributionItem item) {
        if (item instanceof MenuManager) {
            IContributionItem[] iContributionItemArray = ((MenuManager)item).getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem subItem = iContributionItemArray[n2];
                this.getAllContributedActions(set, subItem);
                ++n2;
            }
        } else if (item instanceof ActionContributionItem) {
            set.add(((ActionContributionItem)item).getAction());
        }
    }

    private class Overrides
    implements IContributionManagerOverrides {
        private Overrides() {
        }

        public void updateEnabledAllowed() {
            IContributionItem[] iContributionItemArray = EditorMenuManager.super.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                item.update("enabled");
                ++n2;
            }
            if (EditorMenuManager.this.wrappers != null) {
                int i = 0;
                while (i < EditorMenuManager.this.wrappers.size()) {
                    EditorMenuManager manager = (EditorMenuManager)((Object)EditorMenuManager.this.wrappers.get(i));
                    manager.setEnabledAllowed(EditorMenuManager.this.enabledAllowed);
                    ++i;
                }
            }
        }

        public Boolean getEnabled(IContributionItem item) {
            if (item instanceof ActionContributionItem && ((ActionContributionItem)item).getAction() instanceof RetargetAction || EditorMenuManager.this.enabledAllowed) {
                return null;
            }
            return Boolean.FALSE;
        }

        public Integer getAccelerator(IContributionItem item) {
            if (this.getEnabled(item) == null) {
                return EditorMenuManager.this.getParentMenuManager().getOverrides().getAccelerator(item);
            }
            return 0;
        }

        public String getAcceleratorText(IContributionItem item) {
            return EditorMenuManager.this.getParentMenuManager().getOverrides().getAcceleratorText(item);
        }

        public String getText(IContributionItem item) {
            return EditorMenuManager.this.getParentMenuManager().getOverrides().getText(item);
        }

        public Boolean getVisible(IContributionItem item) {
            return EditorMenuManager.this.getParentMenuManager().getOverrides().getVisible(item);
        }
    }
}

