/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.navigator.actions.NavigatorHandlerObjectBase;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectDataSourceDialog;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class NavigatorHandlerAssociateScript
extends NavigatorHandlerObjectBase {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        ArrayList<IFile> scripts = new ArrayList<IFile>();
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            while (iter.hasNext()) {
                IResource resource;
                DBNNode node = (DBNNode)RuntimeUtils.getObjectAdapter(iter.next(), DBNNode.class);
                if (!(node instanceof DBNResource) || !((resource = ((DBNResource)node).getResource()) instanceof IFile)) continue;
                scripts.add((IFile)resource);
            }
        }
        if (!scripts.isEmpty()) {
            SelectDataSourceDialog dialog = new SelectDataSourceDialog(activeShell, DBWorkbench.getPlatform().getWorkspace().getProject(((IFile)scripts.get(0)).getProject()), null);
            if (dialog.open() == 1) {
                return null;
            }
            DBPDataSourceContainer dataSource = dialog.getDataSource();
            for (IFile script : scripts) {
                EditorUtils.setFileDataSource((IFile)script, (DBPDataSourceContainer)dataSource);
                DBNUtils.refreshNavigatorResource((IResource)script, (Object)dataSource);
            }
        }
        return null;
    }
}

