/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.exec;

import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.net.DBWForwarder;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerType;
import org.jkiss.dbeaver.model.net.DBWNetworkHandler;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.InvalidateJob;
import org.jkiss.dbeaver.runtime.net.GlobalProxyAuthenticator;
import org.jkiss.utils.CommonUtils;

public class DBExecUtils {
    public static final int DEFAULT_READ_FETCH_SIZE = 10000;
    private static final Log log = Log.getLog(DBExecUtils.class);
    private static final ThreadLocal<DBPDataSourceContainer> ACTIVE_CONTEXT = new ThreadLocal();
    private static final List<DBPDataSourceContainer> ACTIVE_CONTEXTS = new ArrayList<DBPDataSourceContainer>();

    public static DBPDataSourceContainer getCurrentThreadContext() {
        return ACTIVE_CONTEXT.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DBPDataSourceContainer> getActiveContexts() {
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            return new ArrayList<DBPDataSourceContainer>(ACTIVE_CONTEXTS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startContextInitiation(DBPDataSourceContainer context) {
        ACTIVE_CONTEXT.set(context);
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            ACTIVE_CONTEXTS.add(context);
        }
        boolean hasProxy = false;
        for (DBWHandlerConfiguration handler : context.getConnectionConfiguration().getHandlers()) {
            if (!handler.isEnabled() || handler.getType() != DBWHandlerType.PROXY) continue;
            hasProxy = true;
            break;
        }
        if (hasProxy) {
            Authenticator.setDefault(new GlobalProxyAuthenticator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finishContextInitiation(DBPDataSourceContainer context) {
        ACTIVE_CONTEXT.remove();
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            ACTIVE_CONTEXTS.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBPDataSourceContainer findConnectionContext(String host, int port, String path) {
        DBPDataSourceContainer curContext = DBExecUtils.getCurrentThreadContext();
        if (curContext != null) {
            return DBExecUtils.contextMatches(host, port, curContext) ? curContext : null;
        }
        List<DBPDataSourceContainer> list = ACTIVE_CONTEXTS;
        synchronized (list) {
            for (DBPDataSourceContainer ctx : ACTIVE_CONTEXTS) {
                if (!DBExecUtils.contextMatches(host, port, ctx)) continue;
                return ctx;
            }
        }
        return null;
    }

    private static boolean contextMatches(String host, int port, DBPDataSourceContainer ctx) {
        DBPConnectionConfiguration cfg = ctx.getConnectionConfiguration();
        if (CommonUtils.equalObjects((Object)cfg.getHostName(), (Object)host) && String.valueOf(port).equals(cfg.getHostPort())) {
            return true;
        }
        DBWNetworkHandler[] dBWNetworkHandlerArray = ctx.getActiveNetworkHandlers();
        int n = dBWNetworkHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBWNetworkHandler networkHandler = dBWNetworkHandlerArray[n2];
            if (networkHandler instanceof DBWForwarder && ((DBWForwarder)((Object)networkHandler)).matchesParameters(host, port)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @NotNull
    public static DBPErrorAssistant.ErrorType discoverErrorType(@NotNull DBPDataSource dataSource, @NotNull Throwable error) {
        DBPErrorAssistant errorAssistant = DBUtils.getAdapter(DBPErrorAssistant.class, dataSource);
        if (errorAssistant != null) {
            return ((DBPErrorAssistant)((Object)dataSource)).discoverErrorType(error);
        }
        return DBPErrorAssistant.ErrorType.NORMAL;
    }

    public static <T> boolean tryExecuteRecover(@NotNull T param, @NotNull DBPDataSource dataSource, @NotNull DBRRunnableParametrized<T> runnable) throws DBException {
        int tryCount = 1;
        boolean recoverEnabled = dataSource.getContainer().getPreferenceStore().getBoolean("execute.recover.enabled");
        if (recoverEnabled) {
            tryCount += dataSource.getContainer().getPreferenceStore().getInt("execute.recover.retryCount");
        }
        Throwable lastError = null;
        int i = 0;
        while (i < tryCount) {
            try {
                runnable.run(param);
                lastError = null;
                break;
            }
            catch (InvocationTargetException e) {
                DBPErrorAssistant.ErrorType errorType;
                lastError = e.getTargetException();
                if (!recoverEnabled || (errorType = DBExecUtils.discoverErrorType(dataSource, lastError)) != DBPErrorAssistant.ErrorType.TRANSACTION_ABORTED && errorType != DBPErrorAssistant.ErrorType.CONNECTION_LOST) break;
                log.debug("Invalidate datasource '" + dataSource.getContainer().getName() + "' connections...");
                DBRProgressMonitor monitor = param instanceof DBRProgressMonitor ? (DBRProgressMonitor)param : (param instanceof DBCSession ? ((DBCSession)param).getProgressMonitor() : new VoidProgressMonitor());
                if (!monitor.isCanceled()) {
                    if (errorType == DBPErrorAssistant.ErrorType.TRANSACTION_ABORTED) {
                        InvalidateJob.invalidateTransaction(monitor, dataSource);
                    } else {
                        InvalidateJob.invalidateDataSource(monitor, dataSource, false, () -> DBWorkbench.getPlatformUI().openConnectionEditor(dataSource.getContainer()));
                        if (i < tryCount - 1) {
                            log.error("Operation failed. Retry count remains = " + (tryCount - i - 1), lastError);
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                log.error("Operation interrupted");
                return false;
            }
            ++i;
        }
        if (lastError != null) {
            if (lastError instanceof DBException) {
                throw (DBException)lastError;
            }
            throw new DBException(lastError, dataSource);
        }
        return true;
    }

    public static void setStatementFetchSize(DBCStatement dbStat, long firstRow, long maxRows, int fetchSize) {
        boolean useFetchSize;
        boolean bl = useFetchSize = fetchSize > 0 || dbStat.getSession().getDataSource().getContainer().getPreferenceStore().getBoolean("resultset.fetch.size");
        if (useFetchSize) {
            if (fetchSize <= 0) {
                fetchSize = 10000;
            }
            try {
                dbStat.setResultsFetchSize(firstRow < 0L || maxRows <= 0L ? fetchSize : (int)(firstRow + maxRows));
            }
            catch (Exception e) {
                log.warn(e);
            }
        }
    }
}

