/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.handles;

import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2dl.ConnectionLocator;
import org.eclipse.draw2dl.Locator;
import org.eclipse.gef3.ConnectionEditPart;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.handles.ConnectionHandle;
import org.eclipse.gef3.tools.ConnectionEndpointTracker;

public class ConnectionEndpointHandle
extends ConnectionHandle {
    private int endPoint;

    public ConnectionEndpointHandle(ConnectionEditPart owner, int endPoint) {
        this.setOwner(owner);
        Assert.isTrue((endPoint == 2 || endPoint == 3 ? 1 : 0) != 0);
        this.endPoint = endPoint;
        this.setLocator((Locator)new ConnectionLocator(this.getConnection(), endPoint));
    }

    public ConnectionEndpointHandle(ConnectionEditPart owner, boolean fixed, int endPoint) {
        super(fixed);
        this.setOwner(owner);
        Assert.isTrue((endPoint == 2 || endPoint == 3 ? 1 : 0) != 0);
        this.endPoint = endPoint;
        this.setLocator((Locator)new ConnectionLocator(this.getConnection(), endPoint));
    }

    public ConnectionEndpointHandle(int endPoint) {
        Assert.isTrue((endPoint == 2 || endPoint == 3 ? 1 : 0) != 0);
        this.endPoint = endPoint;
    }

    @Override
    protected DragTracker createDragTracker() {
        if (this.isFixed()) {
            return null;
        }
        ConnectionEndpointTracker tracker = new ConnectionEndpointTracker((ConnectionEditPart)this.getOwner());
        if (this.endPoint == 2) {
            tracker.setCommandName("Reconnection source");
        } else {
            tracker.setCommandName("Reconnection target");
        }
        tracker.setDefaultCursor(this.getCursor());
        return tracker;
    }

    public int getEndPoint() {
        return this.endPoint;
    }
}

