/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.parser;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLParserActionKind;
import org.jkiss.dbeaver.model.sql.parser.SQLParserContext;
import org.jkiss.dbeaver.model.sql.parser.SQLRuleManager;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLControlToken;
import org.jkiss.dbeaver.model.sql.parser.tokens.SQLTokenType;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SQLTokenEntry;
import org.jkiss.dbeaver.model.sql.parser.tokens.predicates.SQLTokenPredicateEvaluator;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.model.text.TextUtils;
import org.jkiss.dbeaver.model.text.parser.TPRuleBasedScanner;
import org.jkiss.dbeaver.model.text.parser.TPToken;
import org.jkiss.dbeaver.model.text.parser.TPTokenDefault;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class SQLScriptParser {
    protected static final Log log = Log.getLog(SQLScriptParser.class);
    private static final String CLI_ARG_DEBUG_DISABLE_SKIP_TOKEN_EVALUATION = "dbeaver.debug.sql.disable-skip-token-evaluation";
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType;

    private static boolean isPredicateEvaluationEnabled() {
        String property = System.getProperty(CLI_ARG_DEBUG_DISABLE_SKIP_TOKEN_EVALUATION);
        return CommonUtils.isEmpty((String)property);
    }

    /*
     * Unable to fully structure code
     */
    public static SQLScriptElement parseQuery(SQLParserContext context, int startPos, int endPos, int currentPos, boolean scriptMode, boolean keepDelimiters) {
        length = endPos - startPos;
        document = context.getDocument();
        if (length <= 0 || length > document.getLength()) {
            return null;
        }
        dialect = context.getDialect();
        predicateEvaluator = new SQLTokenPredicateEvaluator(dialect.getSkipTokenPredicates());
        isPredicateEvaluationEnabled = SQLScriptParser.isPredicateEvaluationEnabled();
        ruleScanner = context.getScanner();
        useBlankLines = scriptMode == false && context.getSyntaxManager().isBlankLineDelimiter() != false;
        lineFeedIsDelimiter = ArrayUtils.contains((Object[])context.getSyntaxManager().getStatementDelimiters(), (Object)"\n");
        ruleScanner.setRange(document, startPos, endPos - startPos);
        statementStart = startPos;
        hasValuableTokens = false;
        curBlock = null;
        hasBlocks = false;
        lastTokenLineFeeds = 0;
        prevNotEmptyTokenType = SQLTokenType.T_UNKNOWN;
        firstKeyword = null;
        lastKeyword = null;
        while (true) {
            token = ruleScanner.nextToken();
            tokenOffset = ruleScanner.getTokenOffset();
            tokenLength = ruleScanner.getTokenLength();
            v0 = tokenType = token instanceof TPTokenDefault != false ? (SQLTokenType)((TPTokenDefault)token).getData() : SQLTokenType.T_OTHER;
            if (tokenOffset < startPos) {
                return null;
            }
            isControl = false;
            delimiterText = null;
            try {
                block65: {
                    if (isPredicateEvaluationEnabled && tokenLength > 0 && !token.isWhitespace()) {
                        tokenText = document.get(tokenOffset, tokenLength);
                        predicateEvaluator.captureToken(new SQLTokenEntry(tokenText, tokenType));
                    }
                    v1 = isDelimiter = tokenType == SQLTokenType.T_DELIMITER || lineFeedIsDelimiter != false && token.isWhitespace() != false && document.get(tokenOffset, tokenLength).contains("\n") != false;
                    if (isDelimiter) {
                        delimiterText = document.get(tokenOffset, tokenLength);
                    } else if (useBlankLines && token.isWhitespace() && tokenLength > 1 && lastTokenLineFeeds + SQLScriptParser.countLineFeeds(document, tokenOffset, tokenLength) >= 2) {
                        isDelimiter = true;
                    }
                    lastTokenLineFeeds = 0;
                    if (tokenLength == 1) {
                        aChar = document.getChar(tokenOffset);
                        if (aChar == '(' || aChar == '{' || aChar == '[') {
                            curBlock = new ScriptBlockInfo(curBlock, false);
                        } else if ((aChar == ')' || aChar == '}' || aChar == ']') && curBlock != null) {
                            curBlock = curBlock.parent;
                        }
                    }
                    if (tokenType == SQLTokenType.T_BLOCK_BEGIN && prevNotEmptyTokenType == SQLTokenType.T_BLOCK_END) {
                        tokenType = SQLTokenType.T_UNKNOWN;
                    }
                    if (tokenType == SQLTokenType.T_DELIMITER && prevNotEmptyTokenType == SQLTokenType.T_BLOCK_BEGIN && curBlock != null) {
                        curBlock = curBlock.parent;
                    }
                    if (tokenType == SQLTokenType.T_BLOCK_HEADER) {
                        curBlock = new ScriptBlockInfo(curBlock, true);
                        hasBlocks = true;
                    } else if (tokenType == SQLTokenType.T_BLOCK_TOGGLE) {
                        try {
                            togglePattern = document.get(tokenOffset, tokenLength);
                        }
                        catch (BadLocationException e) {
                            SQLScriptParser.log.warn((Object)e);
                            togglePattern = "";
                        }
                        if (curBlock != null && togglePattern.equals(curBlock.togglePattern)) {
                            curBlock = curBlock.parent;
                        } else {
                            curBlock = new ScriptBlockInfo(curBlock, togglePattern);
                            hasBlocks = true;
                        }
                    } else if (tokenType == SQLTokenType.T_BLOCK_BEGIN) {
                        if (curBlock != null && curBlock.isHeader && !ArrayUtils.containsIgnoreCase((String[])dialect.getInnerBlockPrefixes(), lastKeyword)) {
                            curBlock = curBlock.parent;
                        }
                        curBlock = new ScriptBlockInfo(curBlock, false);
                        hasBlocks = true;
                    } else if (tokenType == SQLTokenType.T_BLOCK_END) {
                        if (curBlock != null) {
                            curBlock = curBlock.parent;
                        }
                    } else {
                        if (isDelimiter && curBlock != null) continue;
                        if (tokenType == SQLTokenType.T_SET_DELIMITER || tokenType == SQLTokenType.T_CONTROL) {
                            isDelimiter = true;
                            isControl = true;
                        } else if (tokenType == SQLTokenType.T_COMMENT) {
                            v2 = lastTokenLineFeeds = tokenLength < 2 ? 0 : SQLScriptParser.countLineFeeds(document, tokenOffset + tokenLength - 2, 2);
                        }
                    }
                    if (tokenLength > 0 && !token.isWhitespace()) {
                        switch (SQLScriptParser.$SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType()[tokenType.ordinal()]) {
                            case 1: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: 
                            case 10: {
                                lastKeyword = document.get(tokenOffset, tokenLength);
                                if (firstKeyword != null) break;
                                firstKeyword = lastKeyword;
                            }
                        }
                    }
                    if (isPredicateEvaluationEnabled && !token.isEOF()) {
                        actionKind = predicateEvaluator.evaluatePredicates();
                        if (actionKind == SQLParserActionKind.BEGIN_BLOCK) {
                            while (curBlock != null && curBlock.isHeader) {
                                curBlock = curBlock.parent;
                            }
                            curBlock = new ScriptBlockInfo(curBlock, false);
                            hasBlocks = true;
                        }
                        if (curBlock != null && !token.isEOF() || actionKind == SQLParserActionKind.SKIP_SUFFIX_TERM) continue;
                    }
                    v3 = cursorInsideToken = currentPos >= tokenOffset && currentPos < tokenOffset + tokenLength;
                    if (isControl && ((scriptMode || cursorInsideToken) && !hasValuableTokens || token.isEOF() || isDelimiter && tokenOffset + tokenLength >= currentPos)) {
                        controlText = document.get(tokenOffset, tokenLength);
                        commandId = null;
                        if (token instanceof SQLControlToken) {
                            commandId = ((SQLControlToken)token).getCommandId();
                        }
                        if ((command = new SQLControlCommand(context.getDataSource(), context.getSyntaxManager(), controlText.trim(), commandId, tokenOffset, tokenLength, tokenType == SQLTokenType.T_SET_DELIMITER)).isEmptyCommand() || command.getCommandId() != null && SQLCommandsRegistry.getInstance().getCommandHandler(command.getCommandId()) != null) {
                            var34_40 = command;
                            return var34_40;
                        }
                        isControl = false;
                    }
                    if (!hasValuableTokens || !token.isEOF() && (!isDelimiter || tokenOffset + tokenLength < currentPos) && tokenOffset <= endPos) break block65;
                    if (tokenOffset > endPos) {
                        tokenOffset = endPos;
                    }
                    if (tokenOffset >= document.getLength()) {
                        tokenOffset = document.getLength();
                    }
                    if (SQLScriptParser.$assertionsDisabled || tokenOffset >= currentPos) ** GOTO lbl118
                    throw new AssertionError();
lbl-1000:
                    // 1 sources

                    {
                        ++statementStart;
lbl118:
                        // 2 sources

                        ** while (statementStart < tokenOffset && Character.isWhitespace((char)document.getChar((int)statementStart)))
                    }
lbl119:
                    // 1 sources

                    if (tokenOffset == statementStart) {
                        if (token.isEOF()) {
                            return null;
                        }
                        statementStart = tokenOffset + tokenLength;
                        continue;
                    }
                    queryText = document.get(statementStart, tokenOffset - statementStart);
                    queryText = SQLUtils.fixLineFeeds((String)queryText);
                    if (isDelimiter && (keepDelimiters || hasBlocks && dialect.isDelimiterAfterQuery() || SQLScriptParser.needsDelimiterAfterBlock(firstKeyword, lastKeyword, dialect)) && delimiterText != null && delimiterText.equals(";")) {
                        queryText = String.valueOf(queryText) + delimiterText;
                    }
                    queryEndPos = tokenOffset;
                    if (tokenType == SQLTokenType.T_DELIMITER) {
                        queryEndPos += tokenLength;
                    }
                    if (curBlock != null) {
                        SQLScriptParser.log.trace((Object)"Found leftover blocks in script after parsing");
                    }
                    var34_41 = new SQLQuery(context.getDataSource(), queryText, statementStart, queryEndPos - statementStart);
                    return var34_41;
                }
                if (isDelimiter) {
                    statementStart = tokenOffset + tokenLength;
                    if (isPredicateEvaluationEnabled) {
                        firstKeyword = null;
                        predicateEvaluator.reset();
                        isControl = false;
                        hasBlocks = false;
                        hasValuableTokens = false;
                    }
                }
                if (token.isEOF()) {
                    return null;
                }
                try {
                    if (hasValuableTokens || token.isWhitespace() || isControl) continue;
                    if (tokenType == SQLTokenType.T_COMMENT) {
                        hasValuableTokens = dialect.supportsCommentQuery();
                        continue;
                    }
                    hasValuableTokens = true;
                    continue;
                }
                catch (BadLocationException e) {
                    SQLScriptParser.log.warn((Object)"Error parsing query", (Throwable)e);
                    buf = new StringWriter();
                    e.printStackTrace(new PrintWriter((Writer)buf, true));
                    var34_42 = new SQLQuery(context.getDataSource(), buf.toString());
                    return var34_42;
                }
            }
            finally {
                if (token.isWhitespace() || token.isEOF()) continue;
                prevNotEmptyTokenType = tokenType;
                continue;
            }
            break;
        }
    }

    public static SQLScriptElement parseQuery(SQLDialect dialect, DBPPreferenceStore preferenceStore, String sqlScriptContent, int cursorPosition) {
        SQLParserContext parserContext = SQLScriptParser.prepareSqlParserContext(dialect, preferenceStore, sqlScriptContent);
        return SQLScriptParser.extractQueryAtPos(parserContext, cursorPosition);
    }

    private static boolean needsDelimiterAfterBlock(String firstKeyword, String lastKeyword, SQLDialect dialect) {
        if (dialect.needsDelimiterFor(firstKeyword, lastKeyword)) {
            return true;
        }
        if (!dialect.isDelimiterAfterBlock()) {
            return false;
        }
        if (firstKeyword == null) {
            return false;
        }
        if (!"END".equalsIgnoreCase(lastKeyword)) {
            return false;
        }
        firstKeyword = firstKeyword.toUpperCase(Locale.ENGLISH);
        String[][] blockBoundStrings = dialect.getBlockBoundStrings();
        if (blockBoundStrings != null) {
            String[][] stringArray = blockBoundStrings;
            int n = blockBoundStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String[] bb = stringArray[n2];
                if (bb[0].equals(firstKeyword)) {
                    return true;
                }
                ++n2;
            }
        }
        return ArrayUtils.contains((Object[])dialect.getBlockHeaderStrings(), (Object)firstKeyword) || ArrayUtils.contains((Object[])dialect.getDDLKeywords(), (Object)firstKeyword);
    }

    private static int countLineFeeds(IDocument document, int offset, int length) {
        int lfCount = 0;
        try {
            int i = offset;
            while (i < offset + length) {
                if (document.getChar(i) == '\n') {
                    ++lfCount;
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            log.error((Object)e);
        }
        return lfCount;
    }

    /*
     * Unable to fully structure code
     */
    public static SQLScriptElement extractQueryAtPos(SQLParserContext context, int currentPos) {
        block26: {
            block24: {
                block25: {
                    block27: {
                        document = context.getDocument();
                        if (document.getLength() == 0) {
                            return null;
                        }
                        syntaxManager = context.getSyntaxManager();
                        docLength = document.getLength();
                        v0 = partitioner = document instanceof IDocumentExtension3 != false ? ((IDocumentExtension3)document).getDocumentPartitioner("___sql_partitioning") : null;
                        if (partitioner == null) break block27;
                        try {
                            currLineIndex = document.getLineOfOffset(currentPos);
                            currLine = document.getLineInformation(currLineIndex);
                            currLineEnd = currLine.getOffset() + currLine.getLength();
                            hasNextLine = currLineIndex + 1 < document.getNumberOfLines();
                            inTailComment = "sql_comment".equals(partitioner.getContentType(currentPos));
                            if (!inTailComment && currentPos >= currLineEnd && (!hasNextLine || hasNextLine && currentPos < document.getLineInformation(currLineIndex + 1).getOffset())) {
                                inTailComment = "sql_comment".equals(partitioner.getContentType(currLineEnd - 1));
                            }
                            if (!inTailComment || (letterBeforeComment = SQLScriptParser.skipCommentsBackTillLetter(document, partitioner, observablePosition = currentPos < document.getLength() ? currentPos : currentPos - 1, currLine.getOffset())) < currLine.getOffset()) ** GOTO lbl23
                            currentPos = letterBeforeComment;
                            if (true) ** GOTO lbl23
                        }
                        catch (BadLocationException v1) {
                            return null;
                        }
                        do {
                            ++currentPos;
lbl23:
                            // 3 sources

                        } while (currentPos < docLength && SQLScriptParser.isMultiCommentPartition(partitioner, currentPos));
                    }
                    startPos = 0;
                    useBlankLines = syntaxManager.isBlankLineDelimiter();
                    statementDelimiters = syntaxManager.getStatementDelimiters();
                    lastPos = currentPos >= docLength ? docLength - 1 : currentPos;
                    lineFeedIsDelimiter = ArrayUtils.contains((Object[])statementDelimiters, (Object)"\n");
                    currentLine = originalPosLine = document.getLineOfOffset(currentPos);
                    if (!useBlankLines || !TextUtils.isEmptyLine(document, currentLine)) break block24;
                    if (currentLine != 0) break block25;
                    return null;
                }
                if (!TextUtils.isEmptyLine(document, --currentLine)) break block24;
                return null;
            }
            try {
                if (!lineFeedIsDelimiter) {
                    document.getLineOffset(currentLine);
                    firstLine = currentLine;
                    while (firstLine > 0) {
                        if (useBlankLines && TextUtils.isEmptyLine(document, firstLine) && SQLScriptParser.isDefaultPartition(partitioner, document.getLineOffset(firstLine))) break;
                        if (currentLine == firstLine) {
                            var17_24 = statementDelimiters;
                            var16_22 = statementDelimiters.length;
                            var15_20 = 0;
                            while (var15_20 < var16_22) {
                                delim = var17_24[var15_20];
                                if (!Character.isLetterOrDigit(delim.charAt(0)) && (offset = TextUtils.getOffsetOf(document, firstLine, (String)delim)) >= 0 && SQLScriptParser.isDefaultPartition(partitioner, delimOffset = document.getLineOffset(firstLine) + offset + delim.length()) && currentPos > startPos && docLength > delimOffset) {
                                    hasValuableChars = false;
                                    i = delimOffset;
                                    while (i <= lastPos) {
                                        if (!Character.isWhitespace(document.getChar(i))) {
                                            hasValuableChars = true;
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (hasValuableChars) {
                                        startPos = delimOffset;
                                        break;
                                    }
                                }
                                ++var15_20;
                            }
                        }
                        --firstLine;
                    }
                    if (startPos == 0) {
                        startPos = document.getLineOffset(firstLine);
                    }
                }
                region = document.getLineInformation(currentLine);
                if (lineFeedIsDelimiter) {
                    startPos = currentPos = region.getOffset();
                    break block26;
                }
                if (region.getLength() <= 0) break block26;
                offsetFromLineStart = currentPos - region.getOffset();
                lineStr = document.get(region.getOffset(), offsetFromLineStart);
                var19_28 = statementDelimiters;
                var18_26 = statementDelimiters.length;
                var17_25 = 0;
                while (var17_25 < var18_26) {
                    delim = var19_28[var17_25];
                    delimIndex = lineStr.lastIndexOf((String)delim);
                    if (delimIndex != -1) {
                        hasValuableChars = false;
                        i = region.getOffset() + delimIndex + delim.length();
                        while (i < currentPos) {
                            if (!Character.isWhitespace(document.getChar(i))) {
                                hasValuableChars = true;
                                break;
                            }
                            ++i;
                        }
                        if (!hasValuableChars) {
                            currentPos = region.getOffset() + delimIndex - 1;
                            break;
                        }
                    }
                    ++var17_25;
                }
            }
            catch (BadLocationException e) {
                SQLScriptParser.log.warn((Object)e);
            }
        }
        return SQLScriptParser.parseQuery(context, startPos, document.getLength(), currentPos, false, false);
    }

    private static boolean isDefaultPartition(IDocumentPartitioner partitioner, int currentPos) {
        return partitioner == null || "__dftl_partition_content_type".equals(partitioner.getContentType(currentPos));
    }

    private static boolean isMultiCommentPartition(IDocumentPartitioner partitioner, int currentPos) {
        return partitioner != null && "sql_multiline_comment".equals(partitioner.getContentType(currentPos));
    }

    /*
     * Unable to fully structure code
     */
    public static SQLScriptElement extractNextQuery(SQLParserContext context, int offset, boolean next) {
        block20: {
            curElement = SQLScriptParser.extractQueryAtPos(context, offset);
            if (curElement == null) {
                return null;
            }
            document = context.getDocument();
            partitioner = document instanceof IDocumentExtension3 != false ? ((IDocumentExtension3)document).getDocumentPartitioner("___sql_partitioning") : null;
            try {
                block19: {
                    block21: {
                        docLength = document.getLength();
                        if (!next) break block21;
                        statementDelimiters = context.getSyntaxManager().getStatementDelimiters();
                        curPos = curElement.getOffset() + curElement.getLength();
                        while (curPos < docLength) {
                            if (partitioner == null) ** GOTO lbl-1000
                            region = partitioner.getPartition(curPos);
                            var10_12 = region.getType();
                            tmp = -1;
                            switch (var10_12.hashCode()) {
                                case -1367807844: {
                                    if (var10_12.equals("sql_multiline_comment")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                                case 154903790: {
                                    if (var10_12.equals("sql_comment")) {
                                        tmp = 1;
                                    }
                                    break;
                                }
                            }
                            switch (tmp) {
                                case 1: {
                                    curPos = region.getOffset() + region.getLength();
                                    break;
                                }
                                default: lbl-1000:
                                // 2 sources

                                {
                                    if (!Character.isWhitespace(c = document.getChar(curPos))) {
                                        isDelimiter = false;
                                        var14_17 = statementDelimiters;
                                        var13_16 = statementDelimiters.length;
                                        var12_15 = 0;
                                        while (var12_15 < var13_16) {
                                            delim = var14_17[var12_15];
                                            if (delim.indexOf(c) != -1) {
                                                isDelimiter = true;
                                            }
                                            ++var12_15;
                                        }
                                        if (!isDelimiter) break block19;
                                    }
                                    ++curPos;
                                }
                            }
                        }
                        break block19;
                    }
                    curPos = curElement.getOffset() - 1;
                    curPos = SQLScriptParser.skipCommentsBackTillLetter(document, partitioner, curPos, 0);
                }
                if (curPos > 0 && curPos < docLength) break block20;
                return null;
            }
            catch (BadLocationException e) {
                SQLScriptParser.log.warn((Object)e);
                return null;
            }
        }
        return SQLScriptParser.extractQueryAtPos(context, curPos);
    }

    /*
     * Unable to fully structure code
     */
    private static int skipCommentsBackTillLetter(@NotNull IDocument document, @Nullable IDocumentPartitioner partitioner, int pos, int limit) throws BadLocationException {
        curPos = pos;
        while (curPos >= limit) {
            if (partitioner == null) ** GOTO lbl-1000
            region = partitioner.getPartition(curPos);
            var6_7 = region.getType();
            tmp = -1;
            switch (var6_7.hashCode()) {
                case -1367807844: {
                    if (var6_7.equals("sql_multiline_comment")) {
                        tmp = 1;
                    }
                    break;
                }
                case 154903790: {
                    if (var6_7.equals("sql_comment")) {
                        tmp = 1;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    curPos = region.getOffset() - 1;
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (Character.isLetter(c = document.getChar(curPos))) {
                        return curPos;
                    }
                    --curPos;
                }
            }
        }
        return -1;
    }

    @Nullable
    public static SQLScriptElement extractActiveQuery(SQLParserContext context, int selOffset, int selLength) {
        return SQLScriptParser.extractActiveQuery(context, new IRegion[]{new Region(selOffset, selLength)});
    }

    @Nullable
    public static SQLScriptElement extractActiveQuery(@NotNull SQLParserContext context, @NotNull IRegion[] regions) {
        SQLScriptElement element;
        String selText = null;
        try {
            StringJoiner text = new StringJoiner(CommonUtils.getLineSeparator());
            IRegion[] iRegionArray = regions;
            int n = regions.length;
            int n2 = 0;
            while (n2 < n) {
                IRegion region = iRegionArray[n2];
                if (region.getOffset() >= 0 && region.getLength() > 0) {
                    text.add(context.getDocument().get(region.getOffset(), region.getLength()));
                }
                ++n2;
            }
            if (text.length() > 0) {
                selText = text.toString();
            }
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
        }
        if (selText != null && context.getPreferenceStore().getBoolean("script.sql.query.remove.trailing.delimiter")) {
            SQLSyntaxManager syntaxManager;
            selText = SQLUtils.trimQueryStatement((SQLSyntaxManager)syntaxManager, (String)selText, (!(syntaxManager = context.getSyntaxManager()).getDialect().isDelimiterAfterQuery() ? 1 : 0) != 0);
        }
        IRegion region = regions[0];
        if (!CommonUtils.isEmpty(selText)) {
            SQLScriptElement parsedElement = SQLScriptParser.parseQuery(context, region.getOffset(), region.getOffset() + region.getLength(), region.getOffset(), false, false);
            if (parsedElement instanceof SQLControlCommand) {
                element = parsedElement;
            } else {
                selText = SQLUtils.fixLineFeeds((String)selText);
                element = new SQLQuery(context.getDataSource(), selText, region.getOffset(), region.getLength());
            }
        } else {
            element = region.getOffset() >= 0 ? SQLScriptParser.extractQueryAtPos(context, region.getOffset()) : null;
        }
        if (element == null || CommonUtils.isEmpty((String)element.getText())) {
            return null;
        }
        if (element instanceof SQLQuery) {
            SQLQuery query = (SQLQuery)element;
            query.setParameters(SQLScriptParser.parseParametersAndVariables(context, query.getOffset(), query.getLength()));
        }
        return element;
    }

    public static List<SQLQueryParameter> parseParametersAndVariables(SQLParserContext context, int queryOffset, int queryLength) {
        SQLDialect sqlDialect = context.getDialect();
        IDocument document = context.getDocument();
        if (queryOffset + queryLength > document.getLength()) {
            queryLength = document.getLength() - queryOffset;
        }
        SQLSyntaxManager syntaxManager = context.getSyntaxManager();
        boolean supportParamsInEmbeddedCode = context.getPreferenceStore().getBoolean("sql.parameter.ddl.enabled");
        boolean execQuery = false;
        boolean ddlQuery = false;
        boolean insideDollarQuote = false;
        ArrayList<SQLQueryParameter> parameters = null;
        TPRuleBasedScanner ruleScanner = context.getScanner();
        ruleScanner.setRange(document, queryOffset, queryLength);
        boolean firstKeyword = true;
        if (syntaxManager.isParametersEnabled()) {
            while (true) {
                SQLTokenType tokenType;
                TPToken token = ruleScanner.nextToken();
                int tokenOffset = ruleScanner.getTokenOffset();
                int tokenLength = ruleScanner.getTokenLength();
                if (token.isEOF() || tokenOffset > queryOffset + queryLength) break;
                SQLTokenType sQLTokenType = tokenType = token instanceof TPTokenDefault ? (SQLTokenType)((TPTokenDefault)token).getData() : null;
                if (token.isWhitespace() || tokenType == SQLTokenType.T_COMMENT) continue;
                if (firstKeyword) {
                    try {
                        String tokenText = document.get(tokenOffset, tokenLength);
                        if (ArrayUtils.containsIgnoreCase((String[])sqlDialect.getDDLKeywords(), (String)tokenText)) {
                            ddlQuery = true;
                        } else {
                            execQuery = ArrayUtils.containsIgnoreCase((String[])sqlDialect.getExecuteKeywords(), (String)tokenText);
                        }
                    }
                    catch (BadLocationException e) {
                        log.warn((Object)e);
                    }
                    firstKeyword = false;
                }
                if (tokenType == SQLTokenType.T_BLOCK_TOGGLE) {
                    boolean bl = insideDollarQuote = !insideDollarQuote;
                }
                if (tokenType != SQLTokenType.T_PARAMETER || tokenLength <= 0) continue;
                try {
                    String variableName;
                    String paramName = document.get(tokenOffset, tokenLength);
                    if (!supportParamsInEmbeddedCode && (ddlQuery || insideDollarQuote) || execQuery && paramName.equals(String.valueOf(syntaxManager.getAnonymousParameterMark()))) continue;
                    if (parameters == null) {
                        parameters = new ArrayList<SQLQueryParameter>();
                    }
                    String preparedParamName = null;
                    String paramMark = paramName.substring(0, 1);
                    if (paramMark.equals("$") && !(variableName = SQLQueryParameter.stripVariablePattern((String)paramName)).equals(paramName)) {
                        preparedParamName = variableName.toUpperCase(Locale.ENGLISH);
                    }
                    if (preparedParamName == null) {
                        String rawParamName;
                        preparedParamName = ArrayUtils.contains((Object[])syntaxManager.getNamedParameterPrefixes(), (Object)paramMark) ? (sqlDialect.isQuotedIdentifier(rawParamName = paramName.substring(1)) ? sqlDialect.getUnquotedIdentifier(rawParamName) : rawParamName.toUpperCase(Locale.ENGLISH)) : paramName;
                    }
                    SQLQueryParameter parameter = new SQLQueryParameter(syntaxManager, parameters.size(), preparedParamName, tokenOffset - queryOffset, tokenLength);
                    parameter.setPrevious(SQLScriptParser.getPreviousParameter(parameters, parameter));
                    parameters.add(parameter);
                }
                catch (BadLocationException e) {
                    log.warn((Object)"Can't extract query parameter", (Throwable)e);
                }
            }
        }
        if (syntaxManager.isVariablesEnabled()) {
            try {
                String query = document.get(queryOffset, queryLength);
                Matcher matcher = SQLQueryParameter.getVariablePattern().matcher(query);
                int position = 0;
                while (matcher.find(position)) {
                    int start = matcher.start();
                    int orderPos = 0;
                    SQLQueryParameter param = null;
                    if (parameters != null) {
                        for (SQLQueryParameter p : parameters) {
                            if (p.getTokenOffset() == start) {
                                param = p;
                                break;
                            }
                            if (p.getTokenOffset() >= start) continue;
                            ++orderPos;
                        }
                    }
                    if (param == null) {
                        param = new SQLQueryParameter(syntaxManager, orderPos, matcher.group("pn").toUpperCase(Locale.ENGLISH), start, matcher.end() - matcher.start());
                        if (parameters == null) {
                            parameters = new ArrayList();
                        }
                        param.setPrevious(SQLScriptParser.getPreviousParameter(parameters, param));
                        parameters.add(param.getOrdinalPosition(), param);
                    }
                    position = matcher.end();
                }
            }
            catch (BadLocationException e) {
                log.warn((Object)"Error parsing variables", (Throwable)e);
            }
        }
        return parameters;
    }

    private static SQLQueryParameter getPreviousParameter(List<SQLQueryParameter> parameters, SQLQueryParameter parameter) {
        String varName = parameter.getVarName();
        if (parameter.isNamed()) {
            int i = parameters.size();
            while (i > 0) {
                if (parameters.get(i - 1).getVarName().equals(varName)) {
                    return parameters.get(i - 1);
                }
                --i;
            }
        }
        return null;
    }

    public static List<SQLScriptElement> extractScriptQueries(SQLParserContext parserContext, int startOffset, int length, boolean scriptMode, boolean keepDelimiters, boolean parseParameters) {
        ArrayList<SQLScriptElement> queryList = new ArrayList<SQLScriptElement>();
        IDocument document = parserContext.getDocument();
        if (document.getLength() == 0) {
            return queryList;
        }
        parserContext.startScriptEvaluation();
        try {
            SQLScriptElement query;
            int queryOffset = startOffset;
            while ((query = SQLScriptParser.parseQuery(parserContext, queryOffset, startOffset + length, queryOffset, scriptMode, keepDelimiters)) != null) {
                queryList.add(query);
                queryOffset = query.getOffset() + query.getLength();
            }
        }
        finally {
            parserContext.endScriptEvaluation();
        }
        if (parseParameters) {
            for (SQLScriptElement element : queryList) {
                if (!(element instanceof SQLQuery)) continue;
                SQLQuery query = (SQLQuery)element;
                query.setParameters(SQLScriptParser.parseParametersAndVariables(parserContext, query.getOffset(), query.getLength()));
            }
        }
        return queryList;
    }

    public static List<SQLScriptElement> parseScript(DBPDataSource dataSource, String sqlScriptContent) {
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        syntaxManager.init(dataSource.getSQLDialect(), dataSource.getContainer().getPreferenceStore());
        SQLRuleManager ruleManager = new SQLRuleManager(syntaxManager);
        ruleManager.loadRules(dataSource, false);
        Document sqlDocument = new Document(sqlScriptContent);
        SQLParserContext parserContext = new SQLParserContext(dataSource, syntaxManager, ruleManager, (IDocument)sqlDocument);
        return SQLScriptParser.extractScriptQueries(parserContext, 0, sqlScriptContent.length(), true, false, true);
    }

    public static List<SQLScriptElement> parseScript(SQLDialect dialect, DBPPreferenceStore preferenceStore, String sqlScriptContent) {
        SQLParserContext parserContext = SQLScriptParser.prepareSqlParserContext(dialect, preferenceStore, sqlScriptContent);
        return SQLScriptParser.extractScriptQueries(parserContext, 0, sqlScriptContent.length(), true, false, true);
    }

    @NotNull
    private static SQLParserContext prepareSqlParserContext(SQLDialect dialect, DBPPreferenceStore preferenceStore, String sqlScriptContent) {
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        syntaxManager.init(dialect, preferenceStore);
        SQLRuleManager ruleManager = new SQLRuleManager(syntaxManager);
        ruleManager.loadRules();
        Document sqlDocument = new Document(sqlScriptContent);
        SQLParserContext parserContext = new SQLParserContext(null, syntaxManager, ruleManager, (IDocument)sqlDocument);
        parserContext.setPreferenceStore(preferenceStore);
        return parserContext;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType() {
        if ($SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType != null) {
            return $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType;
        }
        int[] nArray = new int[SQLTokenType.values().length];
        try {
            nArray[SQLTokenType.T_BLOCK_BEGIN.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_BLOCK_END.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_BLOCK_HEADER.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_BLOCK_TOGGLE.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_COMMENT.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_CONTROL.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_DELIMITER.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_KEYWORD.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_NUMBER.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_OTHER.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_PARAMETER.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_QUOTED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_SET_DELIMITER.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_STRING.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_TYPE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_UNKNOWN.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SQLTokenType.T_VARIABLE.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$jkiss$dbeaver$model$sql$parser$tokens$SQLTokenType = nArray;
        return nArray;
    }

    private static class ScriptBlockInfo {
        final ScriptBlockInfo parent;
        final String togglePattern;
        boolean isHeader;

        ScriptBlockInfo(ScriptBlockInfo parent, boolean isHeader) {
            this.parent = parent;
            this.togglePattern = null;
            this.isHeader = isHeader;
        }

        ScriptBlockInfo(ScriptBlockInfo parent, String togglePattern) {
            this.parent = parent;
            this.togglePattern = togglePattern;
        }
    }
}

