/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionRequest;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public class SQLSearchUtils {
    private static final Log log = Log.getLog(SQLSearchUtils.class);

    @Nullable
    public static DBSObject findObjectByFQN(@NotNull DBRProgressMonitor monitor, @Nullable DBSObjectContainer objectContainer, @Nullable DBCExecutionContext executionContext, @NotNull List<String> nameList, boolean useAssistant, @NotNull SQLIdentifierDetector identifierDetector) {
        return SQLSearchUtils.findObjectByFQN(monitor, objectContainer, executionContext, nameList, useAssistant, identifierDetector, false);
    }

    @Nullable
    public static DBSObject findObjectByFQN(@NotNull DBRProgressMonitor monitor, @Nullable DBSObjectContainer objectContainer, @Nullable SQLCompletionRequest request, @NotNull List<String> nameList) {
        return SQLSearchUtils.findObjectByFQN(monitor, objectContainer, request.getContext().getExecutionContext(), nameList, !request.isSimpleMode(), request.getWordDetector(), request.getContext().isSearchGlobally());
    }

    @Nullable
    public static DBSObject findObjectByFQN(@NotNull DBRProgressMonitor monitor, @Nullable DBSObjectContainer objectContainer, @Nullable DBCExecutionContext executionContext, @NotNull List<String> nameList, boolean useAssistant, @NotNull SQLIdentifierDetector identifierDetector, boolean isGlobalSearch) {
        DBPDataSource dataSource;
        if (nameList.isEmpty()) {
            return null;
        }
        DBPDataSource dBPDataSource = dataSource = objectContainer == null ? null : objectContainer.getDataSource();
        if (executionContext == null && dataSource != null) {
            executionContext = DBUtils.getDefaultContext((DBSObject)dataSource, (boolean)true);
        }
        if (dataSource == null && executionContext != null) {
            dataSource = executionContext.getDataSource();
        }
        if (dataSource == null) {
            return null;
        }
        ArrayList<String> unquotedNames = new ArrayList<String>(nameList.size());
        for (String name : nameList) {
            unquotedNames.add(DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)name));
        }
        DBSObject result = SQLSearchUtils.findObjectByPath(monitor, executionContext, objectContainer, unquotedNames, identifierDetector, useAssistant, isGlobalSearch);
        if (result != null) {
            return result;
        }
        int i = 0;
        while (i < nameList.size()) {
            String name;
            name = nameList.get(i);
            String unquotedName = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)name);
            name = !unquotedName.equals(name) ? unquotedName : DBObjectNameCaseTransformer.transformName((DBPDataSource)objectContainer.getDataSource(), (String)name);
            nameList.set(i, name);
            ++i;
        }
        return SQLSearchUtils.findObjectByPath(monitor, executionContext, objectContainer, nameList, identifierDetector, useAssistant, isGlobalSearch);
    }

    @Nullable
    public static DBSObject findObjectByPath(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer objectContainer, @NotNull List<String> nameList, @NotNull SQLIdentifierDetector identifierDetector, boolean useAssistant) {
        return SQLSearchUtils.findObjectByPath(monitor, executionContext, objectContainer, nameList, identifierDetector, useAssistant, false);
    }

    @Nullable
    public static DBSObject findObjectByPath(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull DBSObjectContainer sc, @NotNull List<String> nameList, @NotNull SQLIdentifierDetector identifierDetector, boolean useAssistant, boolean isGlobalSearch) {
        DBSObject childObject;
        block6: {
            try {
                DBSStructureAssistant structureAssistant;
                childObject = null;
                while (childObject == null) {
                    childObject = DBUtils.findNestedObject((DBRProgressMonitor)monitor, (DBCExecutionContext)executionContext, (DBSObjectContainer)sc, nameList);
                    if (childObject != null) continue;
                    DBSObjectContainer parentSc = (DBSObjectContainer)DBUtils.getParentAdapter(DBSObjectContainer.class, (DBSObject)sc);
                    if (parentSc == null) break;
                    sc = parentSc;
                }
                if (childObject != null || nameList.size() > 1) break block6;
                if (useAssistant && (structureAssistant = (DBSStructureAssistant)DBUtils.getAdapter(DBSStructureAssistant.class, (Object)sc)) != null) {
                    String objectNameMask = nameList.get(0);
                    DBSStructureAssistant.ObjectsSearchParams params = new DBSStructureAssistant.ObjectsSearchParams(structureAssistant.getAutoCompleteObjectTypes(), identifierDetector.removeQuotes(objectNameMask));
                    params.setParentObject((DBSObject)sc);
                    params.setCaseSensitive(identifierDetector.isQuoted(objectNameMask));
                    params.setMaxResults(2);
                    params.setGlobalSearch(isGlobalSearch);
                    List tables = structureAssistant.findObjectsByMask(monitor, executionContext, params);
                    if (!tables.isEmpty()) {
                        return ((DBSObjectReference)tables.iterator().next()).resolveObject(monitor);
                    }
                }
                return null;
            }
            catch (DBException e) {
                log.error((Object)e);
                return null;
            }
        }
        return childObject;
    }
}

