/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.project;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceTypeDescriptor;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.registry.ResourceTypeRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;

public class PrefPageProjectResourceSettings
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.projectSettings";
    private static final Log log = Log.getLog(PrefPageProjectResourceSettings.class);
    private IProject project;
    private Table resourceTable;
    private TableEditor handlerTableEditor;

    public PrefPageProjectResourceSettings() {
        this.setDescription(UINavigatorMessages.pref_page_project_resource_settings_description);
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        boolean isReadOnly = DBWorkbench.isDistributed();
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        composite.setLayoutData((Object)new GridData(1808));
        UIUtils.createControlLabel((Composite)composite, (String)UINavigatorMessages.pref_page_projects_settings_label_resource_location);
        this.resourceTable = new Table(composite, 67588);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        this.resourceTable.setLayoutData((Object)gd);
        this.resourceTable.setHeaderVisible(true);
        this.resourceTable.setLinesVisible(true);
        UIUtils.createTableColumn((Table)this.resourceTable, (int)16384, (String)UINavigatorMessages.pref_page_projects_settings_label_resource);
        UIUtils.createTableColumn((Table)this.resourceTable, (int)16384, (String)UINavigatorMessages.pref_page_projects_settings_label_folder);
        this.resourceTable.setHeaderVisible(true);
        this.handlerTableEditor = new TableEditor(this.resourceTable);
        this.handlerTableEditor.verticalAlignment = 128;
        this.handlerTableEditor.horizontalAlignment = 131072;
        this.handlerTableEditor.grabHorizontal = true;
        this.handlerTableEditor.grabVertical = true;
        if (!isReadOnly) {
            this.resourceTable.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    PrefPageProjectResourceSettings.this.disposeOldEditor();
                    final TableItem item = PrefPageProjectResourceSettings.this.resourceTable.getItem(new Point(0, e.y));
                    if (item == null) {
                        return;
                    }
                    int columnIndex = UIUtils.getColumnAtPos((TableItem)item, (int)e.x, (int)e.y);
                    if (columnIndex <= 0) {
                        return;
                    }
                    if (columnIndex == 1) {
                        String resourcePath = item.getText(1);
                        if (PrefPageProjectResourceSettings.this.project != null) {
                            Object[] result;
                            IFolder folder = PrefPageProjectResourceSettings.this.project.getFolder(resourcePath);
                            ContainerSelectionDialog dialog = new ContainerSelectionDialog(PrefPageProjectResourceSettings.this.resourceTable.getShell(), (IContainer)folder, true, String.valueOf(UINavigatorMessages.pref_page_projects_settings_label_select) + item.getText(0) + UINavigatorMessages.pref_page_projects_settings_label_root_folder);
                            dialog.showClosedProjects(false);
                            dialog.setValidator(selection -> {
                                if (selection instanceof IPath) {
                                    IPath path = (IPath)selection;
                                    if (CommonUtils.isEmptyTrimmed((String)PrefPageProjectResourceSettings.convertToString(path))) {
                                        return UINavigatorMessages.pref_page_projects_settings_label_not_use_project_root;
                                    }
                                    File file = path.toFile();
                                    if (file.isHidden() || file.getName().startsWith(".")) {
                                        return UINavigatorMessages.pref_page_projects_settings_label_not_use_hidden_folders;
                                    }
                                    String[] segments = ((IPath)selection).segments();
                                    if (!PrefPageProjectResourceSettings.this.project.getName().equals(segments[0])) {
                                        return UINavigatorMessages.pref_page_projects_settings_label_not_store_resources_in_another_project;
                                    }
                                }
                                return null;
                            });
                            if (dialog.open() == 0 && (result = dialog.getResult()).length == 1 && result[0] instanceof IPath) {
                                item.setText(1, PrefPageProjectResourceSettings.convertToString((IPath)result[0]));
                            }
                        } else {
                            final Text editor = new Text((Composite)PrefPageProjectResourceSettings.this.resourceTable, 0);
                            editor.setText(resourcePath);
                            editor.selectAll();
                            PrefPageProjectResourceSettings.this.handlerTableEditor.setEditor((Control)editor, item, 1);
                            editor.setFocus();
                            editor.addFocusListener((FocusListener)new FocusAdapter(){

                                public void focusLost(FocusEvent e) {
                                    item.setText(1, editor.getText());
                                }
                            });
                        }
                    }
                }
            });
            UIUtils.createInfoLabel((Composite)composite, (String)UINavigatorMessages.pref_page_projects_settings_label_restart_require_refresh_global_settings);
        }
        this.performDefaults();
        return composite;
    }

    @NotNull
    private static String convertToString(@NotNull IPath path) {
        return path.removeFirstSegments(1).removeTrailingSeparator().toString();
    }

    private void disposeOldEditor() {
        Control oldEditor = this.handlerTableEditor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
    }

    protected void performDefaults() {
        this.resourceTable.removeAll();
        DBPPlatformDesktop.getInstance().getWorkspace();
        for (DBPResourceTypeDescriptor descriptor : ResourceTypeRegistry.getInstance().getResourceTypes()) {
            String defaultRoot;
            if (!descriptor.isManagable()) continue;
            TableItem item = new TableItem(this.resourceTable, 0);
            item.setData((Object)descriptor);
            DBPImage icon = descriptor.getIcon();
            if (icon != null) {
                item.setImage(DBeaverIcons.getImage((DBPImage)icon));
            }
            item.setText(0, descriptor.getName());
            DBPProject projectMeta = this.getProjectMeta();
            String string = defaultRoot = projectMeta == null ? null : descriptor.getDefaultRoot(projectMeta);
            if (defaultRoot == null) continue;
            item.setText(1, defaultRoot);
        }
        UIUtils.packColumns((Table)this.resourceTable, (boolean)true);
        super.performDefaults();
    }

    private DBPProject getProjectMeta() {
        return DBPPlatformDesktop.getInstance().getWorkspace().getProject(this.project);
    }

    public boolean performOk() {
        ArrayList<IResource> refreshedResources = new ArrayList<IResource>();
        DBPProject projectMeta = this.getProjectMeta();
        if (projectMeta != null) {
            TableItem[] tableItemArray = this.resourceTable.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                DBPResourceTypeDescriptor descriptor = (DBPResourceTypeDescriptor)item.getData();
                String rootPath = item.getText(1);
                if (!CommonUtils.equalObjects((Object)descriptor.getDefaultRoot(projectMeta), (Object)rootPath)) {
                    IResource newResource;
                    IResource oldResource = this.project.findMember(descriptor.getDefaultRoot(projectMeta));
                    if (oldResource != null) {
                        refreshedResources.add(oldResource);
                    }
                    if ((newResource = this.project.findMember(rootPath)) != null) {
                        refreshedResources.add(newResource);
                    }
                    descriptor.setDefaultRoot(projectMeta, rootPath);
                }
                ++n2;
            }
            if (!refreshedResources.isEmpty()) {
                for (IResource resource : refreshedResources) {
                    DBNUtils.refreshNavigatorResource((IResource)resource, (Object)((Object)this));
                }
            }
        }
        return super.performOk();
    }

    public IAdaptable getElement() {
        return this.project;
    }

    public void setElement(IAdaptable element) {
        this.project = element instanceof IProject ? (IProject)element : (IProject)DBUtils.getAdapter(IProject.class, (Object)element);
    }
}

