/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.impl.sql.RelationalSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContext;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;

class ResultSetContextImpl
implements IResultSetContext {
    private final ResultSetViewer viewer;
    private final DBCResultSet resultSet;

    ResultSetContextImpl(ResultSetViewer viewer, DBCResultSet resultSet) {
        this.viewer = viewer;
        this.resultSet = resultSet;
    }

    @Override
    public boolean supportsAttributes() {
        DBDAttributeBinding[] attrs = this.viewer.getModel().getAttributes();
        return attrs.length > 0;
    }

    @Override
    public boolean supportsDocument() {
        return this.viewer.getModel().getDocumentAttribute() != null;
    }

    @Override
    public boolean supportsGrouping() {
        DBPDataSource dataSource = this.viewer.getDataSource();
        if (dataSource != null) {
            SQLDialect sqlDialect = dataSource.getSQLDialect();
            return sqlDialect instanceof RelationalSQLDialect && ((RelationalSQLDialect)sqlDialect).supportsGroupBy();
        }
        return false;
    }

    @Override
    public boolean supportsReferences() {
        DBPDataSource dataSource = this.viewer.getDataSource();
        if (dataSource != null) {
            return dataSource.getInfo().supportsReferentialIntegrity();
        }
        return false;
    }

    @Override
    public String getDocumentContentType() {
        DBDAttributeBinding docAttr = this.viewer.getModel().getDocumentAttribute();
        return docAttr == null ? null : docAttr.getValueHandler().getValueContentType((DBSTypedObject)docAttr);
    }

    @Override
    public DBCResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public boolean hasAttributeOfType(String typeName) {
        DBDAttributeBinding[] dBDAttributeBindingArray = this.viewer.getModel().getAttributes();
        int n = dBDAttributeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class objectType;
            DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
            DBDValueHandler valueHandler = attr.getValueHandler();
            if (valueHandler != null && (objectType = valueHandler.getValueObjectType((DBSTypedObject)attr.getAttribute())) != null && objectType.getName().equals(typeName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

