/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rm;

import java.util.Set;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.rm.RMObject;
import org.jkiss.dbeaver.model.rm.RMProjectType;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class RMProject
extends RMObject {
    private static final RMProjectType[] SHARED_PROJECTS = new RMProjectType[]{RMProjectType.GLOBAL, RMProjectType.SHARED};
    private String id;
    private String description;
    private RMProjectType type;
    private Long createTime;
    private String creator;
    private Set<String> projectPermissions;

    public RMProject() {
    }

    public RMProject(String id, String name, String description, RMProjectType type, Long createTime, String creator, Set<String> projectPermissions) {
        super(name);
        this.id = id;
        this.description = description;
        this.type = type;
        this.createTime = createTime;
        this.creator = creator;
        this.projectPermissions = projectPermissions;
    }

    public RMProject(String name) {
        super(name);
    }

    @Property
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDisplayName() {
        switch (this.type) {
            case GLOBAL: {
                return ModelMessages.project_shared_display_name;
            }
            case USER: {
                return ModelMessages.project_private_display_name;
            }
        }
        return this.getName();
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Property
    public boolean isShared() {
        return ArrayUtils.contains((Object[])SHARED_PROJECTS, (Object)((Object)this.getType()));
    }

    @Property
    public boolean isGlobal() {
        return this.getType() == RMProjectType.GLOBAL;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Property
    public RMProjectType getType() {
        return this.type;
    }

    public void setType(RMProjectType type) {
        this.type = type;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    @Override
    public String toString() {
        return this.id;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RMProject && CommonUtils.equalObjects((Object)this.id, (Object)((RMProject)obj).id);
    }

    public void setProjectPermissions(Set<String> projectPermissions) {
        this.projectPermissions = projectPermissions;
    }

    public Set<String> getProjectPermissions() {
        return this.projectPermissions;
    }
}

