/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageMetaData
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.meta";
    private Button readExpensiveCheck;
    private Combo separateMetaConnectionCombo;
    private Button caseSensitiveNamesCheck;
    private Button serverSideFiltersCheck;
    private static final List<ModelPreferences.SeparateConnectionBehavior> metaUseSeparateConnectionValues = List.of(ModelPreferences.SeparateConnectionBehavior.ALWAYS, ModelPreferences.SeparateConnectionBehavior.DEFAULT, ModelPreferences.SeparateConnectionBehavior.NEVER);

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dataSourceDescriptor) {
        DBPPreferenceStore store = dataSourceDescriptor.getPreferenceStore();
        return store.contains("database.props.expensive") || store.contains("database.meta.separate.connection") || store.contains("database.meta.casesensitive") || store.contains("database.meta.server.side.filters");
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        Group metadataGroup = UIUtils.createControlGroup((Composite)composite, (String)CoreMessages.pref_page_database_general_group_metadata, (int)1, (int)32, (int)0);
        this.separateMetaConnectionCombo = UIUtils.createLabelCombo((Composite)UIUtils.createComposite((Composite)metadataGroup, (int)3), (String)CoreMessages.pref_page_database_general_separate_meta_connection, (int)12);
        ((GridData)this.separateMetaConnectionCombo.getLayoutData()).grabExcessHorizontalSpace = false;
        this.separateMetaConnectionCombo.setItems(metaUseSeparateConnectionValues.stream().map(s -> s.getTitle()).collect(Collectors.toList()).toArray(new String[0]));
        this.caseSensitiveNamesCheck = UIUtils.createCheckbox((Composite)metadataGroup, (String)CoreMessages.pref_page_database_general_checkbox_case_sensitive_names, (String)CoreMessages.pref_page_database_general_checkbox_case_sensitive_names_tip, (boolean)false, (int)1);
        this.readExpensiveCheck = UIUtils.createCheckbox((Composite)metadataGroup, (String)CoreMessages.pref_page_database_general_checkbox_show_row_count, (String)CoreMessages.pref_page_database_general_checkbox_show_row_count_tip, (boolean)false, (int)1);
        this.serverSideFiltersCheck = UIUtils.createCheckbox((Composite)metadataGroup, (String)CoreMessages.pref_page_database_general_server_side_object_filters, (String)CoreMessages.pref_page_database_general_server_side_object_filters_tip, (boolean)false, (int)1);
        return composite;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        try {
            this.readExpensiveCheck.setSelection(store.getBoolean("database.props.expensive"));
            this.separateMetaConnectionCombo.select(metaUseSeparateConnectionValues.indexOf(ModelPreferences.SeparateConnectionBehavior.parse((String)store.getString("database.meta.separate.connection"))));
            this.caseSensitiveNamesCheck.setSelection(store.getBoolean("database.meta.casesensitive"));
            this.serverSideFiltersCheck.setSelection(store.getBoolean("database.meta.server.side.filters"));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    protected void savePreferences(DBPPreferenceStore store) {
        try {
            store.setValue("database.props.expensive", this.readExpensiveCheck.getSelection());
            store.setValue("database.meta.separate.connection", metaUseSeparateConnectionValues.get(this.separateMetaConnectionCombo.getSelectionIndex()).name());
            store.setValue("database.meta.casesensitive", this.caseSensitiveNamesCheck.getSelection());
            store.setValue("database.meta.server.side.filters", this.serverSideFiltersCheck.getSelection());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setToDefault("database.props.expensive");
        store.setToDefault("database.meta.separate.connection");
        store.setToDefault("database.meta.casesensitive");
        store.setToDefault("database.meta.server.side.filters");
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }
}

