/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.text.ContentBox;
import org.eclipse.draw2dl.text.FlowBox;
import org.eclipse.draw2dl.text.InlineFlow;
import org.eclipse.draw2dl.text.LineBox;
import org.eclipse.draw2dl.text.NestedLine;

public class LineRoot
extends LineBox {
    private int baseline;
    private boolean isMirrored;

    public LineRoot(boolean isMirrored) {
        this.isMirrored = isMirrored;
    }

    @Override
    public void add(FlowBox child) {
        super.add(child);
        child.setLineRoot(this);
    }

    private void bidiCommit() {
        int xLocation = this.getX();
        BidiLevelNode root = new BidiLevelNode();
        ArrayList branches = new ArrayList();
        this.buildBidiTree(this, root, branches);
        ArrayList result = new ArrayList();
        root.emit(result);
        int i = this.isMirrored ? result.size() - 1 : 0;
        while (i >= 0 && i < result.size()) {
            FlowBox box = (FlowBox)result.get(i);
            box.setX(xLocation);
            xLocation += box.getWidth();
            i += this.isMirrored ? -1 : 1;
        }
        this.layoutNestedLines(branches);
    }

    private void buildBidiTree(FlowBox box, BidiLevelNode node, List branches) {
        if (box instanceof LineBox) {
            List children = ((LineBox)box).getFragments();
            int i = 0;
            while (i < children.size()) {
                this.buildBidiTree((FlowBox)children.get(i), node, branches);
                ++i;
            }
            if (box != this) {
                branches.add(box);
            }
        } else {
            ContentBox leafBox = (ContentBox)box;
            while (leafBox.getBidiLevel() < node.level) {
                node = node.pop();
            }
            while (leafBox.getBidiLevel() > node.level) {
                node = node.push();
            }
            node.add(leafBox);
        }
    }

    public void commit() {
        if (this.requiresBidi()) {
            this.bidiCommit();
        } else {
            this.contiguousCommit(this, this.getX());
        }
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return false;
    }

    private void contiguousCommit(FlowBox box, int x) {
        box.setX(x);
        if (box instanceof LineBox) {
            List fragments = ((LineBox)box).getFragments();
            int i = this.isMirrored ? fragments.size() - 1 : 0;
            while (i >= 0 && i < fragments.size()) {
                FlowBox child = (FlowBox)fragments.get(i);
                this.contiguousCommit(child, x);
                x += child.getWidth();
                i += this.isMirrored ? -1 : 1;
            }
        }
    }

    private Result findParent(NestedLine line, List branches, int afterIndex) {
        int i = afterIndex + 1;
        while (i < branches.size()) {
            NestedLine box = (NestedLine)branches.get(i);
            int index = box.getFragments().indexOf(line);
            if (index >= 0) {
                return new Result(box, index);
            }
            ++i;
        }
        return new Result(this, this.getFragments().indexOf(line));
    }

    @Override
    public int getBaseline() {
        return this.baseline;
    }

    @Override
    LineRoot getLineRoot() {
        return this;
    }

    int getVisibleBottom() {
        return this.baseline + this.contentDescent;
    }

    int getVisibleTop() {
        return this.baseline - this.contentAscent;
    }

    private void layoutNestedLines(List branches) {
        int i = 0;
        while (i < branches.size()) {
            NestedLine parent = (NestedLine)branches.get(i);
            FlowBox prevChild = null;
            Rectangle bounds = null;
            List frags = parent.getFragments();
            int j = 0;
            while (j < frags.size()) {
                FlowBox child = (FlowBox)frags.get(j);
                if (prevChild != null && prevChild.getX() + prevChild.width != child.getX() && child.getX() + child.width != prevChild.getX()) {
                    InlineFlow parentFig = parent.owner;
                    NestedLine newBox = new NestedLine(parentFig);
                    newBox.setLineRoot(this);
                    int k = j;
                    while (k < frags.size()) {
                        newBox.fragments.add(frags.remove(k));
                    }
                    Result result = this.findParent(parent, branches, i);
                    result.parent.getFragments().add(result.index + 1, newBox);
                    parentFig.fragments.add(parentFig.fragments.indexOf(parent) + 1, newBox);
                    branches.add(i + 1, newBox);
                    break;
                }
                if (bounds == null) {
                    bounds = new Rectangle(child.getX(), 1, child.getWidth(), 1);
                } else {
                    bounds.union(child.getX(), 1, child.getWidth(), 1);
                }
                prevChild = child;
                ++j;
            }
            parent.setX(bounds.x);
            parent.setWidth(bounds.width);
            ++i;
        }
    }

    public void setBaseline(int baseline) {
        this.baseline = baseline;
    }

    @Override
    public void setLineTop(int top) {
        this.baseline = top + this.getAscent();
    }

    private static class BidiLevelNode
    extends ArrayList {
        int level;
        final BidiLevelNode parent;

        BidiLevelNode() {
            this(null, 0);
        }

        BidiLevelNode(BidiLevelNode parent, int level) {
            this.parent = parent;
            this.level = level;
        }

        void emit(List list) {
            if (this.level % 2 == 1) {
                int i = this.size() - 1;
                while (i >= 0) {
                    Object child = this.get(i);
                    if (child instanceof BidiLevelNode) {
                        ((BidiLevelNode)child).emit(list);
                    } else {
                        list.add(child);
                    }
                    --i;
                }
            } else {
                int i = 0;
                while (i < this.size()) {
                    Object child = this.get(i);
                    if (child instanceof BidiLevelNode) {
                        ((BidiLevelNode)child).emit(list);
                    } else {
                        list.add(child);
                    }
                    ++i;
                }
            }
        }

        BidiLevelNode pop() {
            return this.parent;
        }

        BidiLevelNode push() {
            Object last;
            if (!this.isEmpty() && (last = this.get(this.size() - 1)) instanceof BidiLevelNode && ((BidiLevelNode)last).level == this.level + 1) {
                return (BidiLevelNode)last;
            }
            BidiLevelNode child = new BidiLevelNode(this, this.level + 1);
            this.add(child);
            return child;
        }
    }

    private static class Result {
        private int index;
        private LineBox parent;

        private Result(LineBox box, int i) {
            this.parent = box;
            this.index = i;
        }
    }
}

