/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.cache.DBSCompositeCache;

public abstract class JDBCObjectWithParentCache<OWNER extends DBSObject, PARENT extends DBSObject, OBJECT extends DBSObject>
extends AbstractObjectCache<OWNER, OBJECT>
implements DBSCompositeCache<PARENT, OBJECT> {
    protected static final Log log = Log.getLog(JDBCObjectWithParentCache.class);
    private final JDBCStructCache<OWNER, ?, ?> parentCache;
    private final Class<PARENT> parentType;
    private Object parentColumnName;
    private Object objectColumnName;
    private final Map<PARENT, List<OBJECT>> objectCache = new IdentityHashMap<PARENT, List<OBJECT>>();

    protected JDBCObjectWithParentCache(JDBCStructCache<OWNER, ?, ?> parentCache, Class<PARENT> parentType, Object parentColumnName, Object objectColumnName) {
        this.parentCache = parentCache;
        this.parentType = parentType;
        this.parentColumnName = parentColumnName;
        this.objectColumnName = objectColumnName;
    }

    @NotNull
    protected abstract JDBCStatement prepareObjectsStatement(@NotNull JDBCSession var1, @NotNull OWNER var2, @Nullable PARENT var3) throws SQLException;

    @Nullable
    protected abstract OBJECT fetchObject(@NotNull JDBCSession var1, @NotNull OWNER var2, @NotNull PARENT var3, String var4, @NotNull JDBCResultSet var5) throws SQLException, DBException;

    protected PARENT getParent(OBJECT object) {
        return (PARENT)object.getParentObject();
    }

    @Override
    @NotNull
    public List<OBJECT> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable OWNER owner) throws DBException {
        return this.getObjects(monitor, owner, null);
    }

    public List<OBJECT> getObjects(DBRProgressMonitor monitor, OWNER owner, PARENT forParent) throws DBException {
        this.loadObjects(monitor, owner, forParent);
        return this.getCachedObjects(forParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OBJECT> getCachedObjects(PARENT forParent) {
        if (forParent == null) {
            return this.getCachedObjects();
        }
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            return this.objectCache.get(forParent);
        }
    }

    @Override
    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @Nullable OWNER owner, @NotNull String objectName) throws DBException {
        this.loadObjects(monitor, owner, null);
        return this.getCachedObject(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBJECT getObject(DBRProgressMonitor monitor, OWNER owner, PARENT forParent, String objectName) throws DBException {
        this.loadObjects(monitor, owner, forParent);
        if (forParent == null) {
            return this.getCachedObject(objectName);
        }
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            return (OBJECT)((DBSObject)DBUtils.findObject((Collection)this.objectCache.get(forParent), objectName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheObject(@NotNull OBJECT object) {
        super.cacheObject(object);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            PARENT parent = this.getParent(object);
            List objects = this.objectCache.computeIfAbsent(parent, k -> new ArrayList());
            objects.add(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObject(@NotNull OBJECT object, boolean resetFullCache) {
        super.removeObject(object, resetFullCache);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            PARENT parent = this.getParent(object);
            if (resetFullCache) {
                this.objectCache.remove(parent);
            } else {
                List<OBJECT> subCache = this.objectCache.get(parent);
                if (subCache != null) {
                    subCache.remove(object);
                }
            }
        }
    }

    @Override
    public void clearObjectCache(PARENT forParent) {
        if (forParent == null) {
            super.clearCache();
            this.objectCache.clear();
        } else {
            List<OBJECT> removedObjects = this.objectCache.remove(forParent);
            if (removedObjects != null) {
                for (DBSObject obj : removedObjects) {
                    super.removeObject(obj, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            this.objectCache.clear();
        }
        super.clearCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCache(List<OBJECT> objects) {
        super.setCache(objects);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            this.objectCache.clear();
            for (DBSObject object : objects) {
                PARENT parent = this.getParent(object);
                List parentObjects = this.objectCache.computeIfAbsent(parent, k -> new ArrayList());
                parentObjects.add(object);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void loadObjects(DBRProgressMonitor monitor, OWNER owner, PARENT forParent) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Map lambda$2(DBSObject k) {
        return new TreeMap();
    }
}

