/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.impl.sac;

import java.util.Set;
import org.eclipse.e4.ui.css.core.impl.sac.AbstractAttributeCondition;
import org.w3c.dom.Element;

public class CSSAttributeConditionImpl
extends AbstractAttributeCondition {
    protected String localName;
    protected String namespaceURI;
    protected boolean specified;

    public CSSAttributeConditionImpl(String localName, String namespaceURI, boolean specified, String value) {
        super(value);
        this.localName = localName;
        this.namespaceURI = namespaceURI;
        this.specified = specified;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CSSAttributeConditionImpl c = (CSSAttributeConditionImpl)obj;
        return c.namespaceURI.equals(this.namespaceURI) && c.localName.equals(this.localName) && c.specified == this.specified;
    }

    @Override
    public int hashCode() {
        return this.namespaceURI.hashCode() ^ this.localName.hashCode() ^ Boolean.hashCode(this.specified);
    }

    public short getConditionType() {
        return 4;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean getSpecified() {
        return this.specified;
    }

    @Override
    public boolean match(Element e, String pseudoE) {
        if (!e.hasAttribute(this.getLocalName())) {
            return false;
        }
        String val = this.getValue();
        if (val == null) {
            return true;
        }
        return e.getAttribute(this.getLocalName()).equals(val);
    }

    @Override
    public void fillAttributeSet(Set<String> attrSet) {
        attrSet.add(this.localName);
    }

    public String toString() {
        if (this.value == null) {
            return String.valueOf('[') + this.localName + ']';
        }
        return String.valueOf('[') + this.localName + "=\"" + this.value + "\"]";
    }
}

