/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.properties;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.IPropertySourceEditable;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCollection;
import org.jkiss.dbeaver.runtime.properties.PropertySourceMap;
import org.jkiss.dbeaver.ui.DefaultViewerToolTipSupport;
import org.jkiss.dbeaver.ui.UIElementAlignment;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.ObjectViewerRenderer;
import org.jkiss.dbeaver.ui.controls.bool.BooleanMode;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyleDecorator;
import org.jkiss.dbeaver.ui.internal.UIMessages;
import org.jkiss.dbeaver.ui.properties.PropertyEditorUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class PropertyTreeViewer
extends TreeViewer {
    public static final String LINE_SEPARATOR = GeneralUtils.getDefaultLineSeparator();
    private static final String CATEGORY_GENERAL = UIMessages.ui_properties_tree_viewer_category_general;
    private static final int NAME_COLUMN_WIDTH = 100;
    private static final int VALUE_COLUMN_WIDTH = 300;
    private boolean expandSingleRoot = true;
    private boolean namesEditable = false;
    private boolean newPropertiesAllowed = false;
    private boolean isMouseEventOnMacos = false;
    private TreeEditor treeEditor;
    private Font boldFont;
    private int selectedColumn = -1;
    private CellEditor curCellEditor;
    private DBPPropertyDescriptor selectedProperty;
    private String[] customCategories;
    private IBaseLabelProvider extraLabelProvider;
    private ObjectViewerRenderer renderer;
    private ExpandMode expandMode = ExpandMode.ALL;
    private final List<IPropertyChangeListener> propertyListeners = new ArrayList<IPropertyChangeListener>();

    public PropertyTreeViewer(Composite parent, int style) {
        super(parent, style | 4 | 0x10000);
        super.setContentProvider((IContentProvider)new PropsContentProvider());
        Tree treeControl = super.getTree();
        if (parent.getLayout() instanceof GridLayout) {
            GridData gd = new GridData(1808);
            gd.grabExcessHorizontalSpace = true;
            gd.grabExcessVerticalSpace = true;
            gd.minimumHeight = 120;
            gd.minimumWidth = 120;
            treeControl.setLayoutData((Object)gd);
        }
        treeControl.setHeaderVisible(true);
        treeControl.addListener(42, (Listener)new PaintListener());
        this.boldFont = UIUtils.makeBoldFont(treeControl.getFont());
        new DefaultViewerToolTipSupport((ColumnViewer)this);
        TreeViewerColumn column = new TreeViewerColumn((TreeViewer)this, 0);
        column.getColumn().setMoveable(true);
        column.getColumn().setText(UIMessages.properties_name);
        column.setLabelProvider((CellLabelProvider)new PropsLabelProvider(true));
        column.getColumn().addListener(13, (Listener)new SortListener());
        column = new TreeViewerColumn((TreeViewer)this, 0);
        column.getColumn().setMoveable(true);
        column.getColumn().setText(UIMessages.properties_value);
        column.setLabelProvider((CellLabelProvider)new PropsLabelProvider(false));
        this.registerEditor();
        this.registerContextMenu();
        this.renderer = new ObjectViewerRenderer((ColumnViewer)this){

            @Override
            public Object getCellValue(Object element, int columnIndex) {
                TreeNode node = (TreeNode)element;
                if (columnIndex == 0) {
                    return node.category != null ? node.category : node.property.getDisplayName();
                }
                return PropertyTreeViewer.this.getPropertyValue(node);
            }

            @Override
            public boolean isHyperlink(Object cellValue) {
                return cellValue instanceof DBSObject;
            }

            @Override
            public void navigateHyperlink(Object cellValue) {
                if (cellValue instanceof DBSObject) {
                    DBWorkbench.getPlatformUI().openEntityEditor((DBSObject)cellValue);
                }
            }

            @Override
            @NotNull
            protected UIElementAlignment getBooleanAlignment(@Nullable Boolean value) {
                return UIElementAlignment.LEFT;
            }
        };
    }

    public boolean isNamesEditable() {
        return this.namesEditable;
    }

    public void setNamesEditable(boolean namesEditable) {
        this.namesEditable = namesEditable;
    }

    public boolean isNewPropertiesAllowed() {
        return this.newPropertiesAllowed;
    }

    public void setNewPropertiesAllowed(boolean newPropertiesAllowed) {
        this.newPropertiesAllowed = newPropertiesAllowed;
    }

    public void loadProperties(DBPPropertySource propertySource) {
        this.loadProperties(null, null, propertySource);
    }

    public void loadProperties(DBRProgressMonitor monitor, DBPPropertySource propertySource) {
        this.loadProperties(monitor, null, propertySource);
    }

    protected void loadProperties(@Nullable DBRProgressMonitor monitor, TreeNode parent, DBPPropertySource propertySource) {
        Object root;
        this.customCategories = this.getCustomCategories();
        Map<String, TreeNode> categories = this.loadTreeNodes(monitor, parent, propertySource);
        if (this.customCategories != null) {
            String[] stringArray = this.customCategories;
            int n = this.customCategories.length;
            int n2 = 0;
            while (n2 < n) {
                String customCategory = stringArray[n2];
                TreeNode node = categories.get(customCategory);
                if (node == null) {
                    node = new TreeNode(parent, propertySource, customCategory);
                    categories.put(customCategory, node);
                }
                ++n2;
            }
        }
        if (categories.size() == 1 && this.expandSingleRoot) {
            Collection<TreeNode> values = categories.values();
            root = values.iterator().next();
        } else {
            root = categories.values();
        }
        super.setInput(root);
        this.disposeOldEditor();
        this.repackColumns();
    }

    public void repackColumns() {
        UIUtils.asyncExec(() -> {
            Tree tree = this.getTree();
            if (tree.isDisposed()) {
                return;
            }
            tree.setRedraw(false);
            try {
                this.expandAll();
                UIUtils.packColumns(tree, true, new float[]{0.1f, 0.9f});
                switch (this.expandMode) {
                    case ALL: {
                        break;
                    }
                    case FIRST: {
                        Object root = this.getInput();
                        if (root instanceof Collection) {
                            Collection rootItems = (Collection)root;
                            if (!rootItems.isEmpty()) {
                                Object first = rootItems.iterator().next();
                                this.collapseAll();
                                this.expandToLevel(first, -1);
                            }
                            break;
                        }
                        this.expandAll();
                    }
                }
            }
            finally {
                tree.setRedraw(true);
            }
        });
    }

    public void changeColumnsWidth() {
        Tree tree = this.getTree();
        if (tree != null && !tree.isDisposed()) {
            UIUtils.asyncExec(() -> {
                tree.setRedraw(false);
                Object[] columns = tree.getColumns();
                if (!ArrayUtils.isEmpty((Object[])columns) && columns.length > 1) {
                    int i = 0;
                    while (i < columns.length) {
                        if (i == 0) {
                            if (columns[0].getWidth() < 100) {
                                columns[0].setWidth(100);
                            }
                        } else if (columns[i].getWidth() < 300) {
                            columns[i].setWidth(300);
                        }
                        ++i;
                    }
                }
                tree.setRedraw(true);
            });
        }
    }

    private Map<String, TreeNode> loadTreeNodes(@Nullable DBRProgressMonitor monitor, TreeNode parent, DBPPropertySource propertySource) {
        DBPPropertyDescriptor[] props;
        LinkedHashMap<String, TreeNode> categories = new LinkedHashMap<String, TreeNode>();
        DBPPropertyDescriptor[] dBPPropertyDescriptorArray = props = this.filterProperties(propertySource.getEditableValue(), propertySource.getProperties());
        int n = props.length;
        int n2 = 0;
        while (n2 < n) {
            block16: {
                Class propType;
                TreeNode category;
                String categoryName;
                DBPPropertyDescriptor prop;
                block15: {
                    prop = dBPPropertyDescriptorArray[n2];
                    if (!(prop instanceof ObjectPropertyDescriptor)) break block15;
                    Object propertyValue = propertySource.getPropertyValue(monitor, prop.getId());
                    if (!((ObjectPropertyDescriptor)prop).isPropertyVisible(propertySource.getEditableValue(), propertyValue)) break block16;
                }
                if (CommonUtils.isEmpty((String)(categoryName = prop.getCategory()))) {
                    categoryName = CATEGORY_GENERAL;
                }
                TreeNode treeNode = category = parent != null ? parent : (TreeNode)categories.get(categoryName);
                if (category == null) {
                    category = new TreeNode(null, propertySource, categoryName);
                    categories.put(categoryName, category);
                }
                TreeNode propNode = new TreeNode(category, propertySource, prop);
                if (!(propertySource instanceof IPropertySourceEditable) && (propType = prop.getDataType()) != null) {
                    int n3;
                    Object propertyValue;
                    if (DBPObject.class.isAssignableFrom(propType)) {
                        PropertyCollector nestedCollector;
                        propertyValue = propertySource.getPropertyValue(monitor, prop.getId());
                        if (propertyValue != null && (nestedCollector = new PropertyCollector(propertyValue, true)).collectProperties()) {
                            categories.putAll(this.loadTreeNodes(monitor, propNode, (DBPPropertySource)nestedCollector));
                        }
                    } else if (BeanUtils.isCollectionType((Type)propType)) {
                        propertyValue = propertySource.getPropertyValue(monitor, prop.getId());
                        if (propertyValue != null) {
                            List<Object> collection = BeanUtils.isArrayType((Type)propType) ? Arrays.asList((Object[])propertyValue) : (List<Object>)propertyValue;
                            PropertySourceCollection psc = new PropertySourceCollection(collection);
                            DBPPropertyDescriptor[] dBPPropertyDescriptorArray2 = psc.getProperties();
                            int n4 = dBPPropertyDescriptorArray2.length;
                            n3 = 0;
                            while (n3 < n4) {
                                DBPPropertyDescriptor pd = dBPPropertyDescriptorArray2[n3];
                                new TreeNode(propNode, (DBPPropertySource)psc, pd);
                                ++n3;
                            }
                        }
                    } else if (Map.class.isAssignableFrom(propType) && (propertyValue = (Map)propertySource.getPropertyValue(monitor, prop.getId())) != null) {
                        PropertySourceMap psc = new PropertySourceMap((Map)propertyValue);
                        DBPPropertyDescriptor[] dBPPropertyDescriptorArray3 = psc.getProperties();
                        n3 = dBPPropertyDescriptorArray3.length;
                        int n5 = 0;
                        while (n5 < n3) {
                            DBPPropertyDescriptor pd = dBPPropertyDescriptorArray3[n5];
                            new TreeNode(propNode, (DBPPropertySource)psc, pd);
                            ++n5;
                        }
                    }
                }
            }
            ++n2;
        }
        return categories;
    }

    protected DBPPropertyDescriptor[] filterProperties(Object object, DBPPropertyDescriptor[] properties) {
        return properties;
    }

    public void clearProperties() {
        super.setInput(null);
    }

    protected void addProperty(Object node, DBPPropertyDescriptor property, boolean update) {
        if (node instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)node;
            while (treeNode.property != null) {
                treeNode = treeNode.parent;
            }
            TreeNode newNode = new TreeNode(treeNode, treeNode.propertySource, property);
            if (update) {
                this.handlePropertyCreate(newNode);
            }
        }
    }

    protected void removeProperty(Object node) {
        this.applyEditorValue();
        this.disposeOldEditor();
        if (node instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)node;
            if (treeNode.propertySource != null) {
                treeNode.propertySource.resetPropertyValueToDefault(treeNode.property.getId());
            }
            treeNode.parent.children.remove(treeNode);
            this.handlePropertyRemove(treeNode);
        }
    }

    public void refresh() {
        super.refresh();
    }

    private void disposeOldEditor() {
        Control oldEditor;
        if (this.curCellEditor != null) {
            this.curCellEditor.deactivate();
            this.curCellEditor.dispose();
            this.curCellEditor = null;
            this.selectedProperty = null;
        }
        if ((oldEditor = this.treeEditor.getEditor()) != null) {
            oldEditor.dispose();
        }
    }

    private void registerEditor() {
        final Tree treeControl = super.getTree();
        this.treeEditor = new TreeEditor(treeControl);
        this.treeEditor.horizontalAlignment = 0x1000000;
        this.treeEditor.verticalAlignment = 0x1000000;
        this.treeEditor.minimumWidth = 50;
        treeControl.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                if (RuntimeUtils.isMacOS()) {
                    PropertyTreeViewer.this.showEditor(item, PropertyTreeViewer.this.isMouseEventOnMacos);
                    PropertyTreeViewer.this.isMouseEventOnMacos = false;
                    return;
                }
                PropertyTreeViewer.this.showEditor(item, (e.stateMask & SWT.BUTTON_MASK) != 0);
            }
        });
        treeControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TreeItem item = treeControl.getItem(new Point(e.x, e.y));
                if (RuntimeUtils.isMacOS()) {
                    PropertyTreeViewer.this.isMouseEventOnMacos = true;
                }
                if (item != null) {
                    PropertyTreeViewer.this.selectedColumn = UIUtils.getColumnAtPos(item, e.x, e.y);
                } else {
                    TreeItem[] allItems;
                    TreeItem lastItem;
                    PropertyTreeViewer.this.selectedColumn = -1;
                    if (PropertyTreeViewer.this.newPropertiesAllowed && (lastItem = (allItems = treeControl.getItems())[allItems.length - 1]).getData() instanceof TreeNode) {
                        TreeNode lastNode = (TreeNode)lastItem.getData();
                        if (!CommonUtils.isEmpty(lastNode.children)) {
                            lastNode = lastNode.children.get(lastNode.children.size() - 1);
                        }
                        if (lastNode.property != null && CommonUtils.isEmpty((String)lastNode.property.getDisplayName())) {
                            return;
                        }
                        if (lastNode.parent != null) {
                            lastNode = lastNode.parent;
                        }
                        PropertyTreeViewer.this.addProperty(lastNode, (DBPPropertyDescriptor)new PropertyDescriptor(lastNode.category, "prop" + lastNode.children.size(), "", "", false, String.class, (Object)"", null), true);
                        allItems = treeControl.getItems();
                        TreeItem newItem = allItems[allItems.length - 1];
                        treeControl.setSelection(newItem);
                        PropertyTreeViewer.this.selectedColumn = UIUtils.getColumnAtPos(newItem, e.x, e.y);
                    }
                }
            }
        });
        treeControl.addTraverseListener(e -> {
            if (e.detail == 4) {
                if (this.curCellEditor != null) {
                    this.curCellEditor.setFocus();
                } else {
                    TreeItem[] selection = treeControl.getSelection();
                    if (selection.length == 0) {
                        return;
                    }
                    this.showEditor(selection[0], true);
                }
                e.doit = false;
                e.detail = 0;
            }
        });
    }

    private void showEditor(TreeItem item, boolean isDef) {
        this.disposeOldEditor();
        if (item == null) {
            return;
        }
        if (item.getData() instanceof TreeNode) {
            Control editorControl;
            CellEditor cellEditor;
            Tree treeControl = super.getTree();
            final TreeNode prop = (TreeNode)item.getData();
            if (prop.property == null || !prop.isEditable()) {
                return;
            }
            final int columnIndex = this.selectedColumn == 0 && (!this.namesEditable || !(prop.property instanceof DBPNamedObject)) ? 1 : this.selectedColumn;
            int editStyle = 16384;
            if (this.isHidePropertyValue(prop.property)) {
                editStyle |= 0x400000;
            }
            if ((cellEditor = PropertyEditorUtils.createPropertyEditor((IServiceLocator)UIUtils.getActiveWorkbenchWindow(), (Composite)treeControl, prop.propertySource, prop.property, editStyle)) == null) {
                return;
            }
            if (cellEditor instanceof BooleanStyleDecorator) {
                ((BooleanStyleDecorator)cellEditor).setBooleanAlignment(UIElementAlignment.LEFT);
            }
            String propertyValue = columnIndex == 0 ? prop.property.getDisplayName() : prop.propertySource.getPropertyValue(null, prop.property.getId());
            ICellEditorListener cellEditorListener = new ICellEditorListener(){

                public void applyEditorValue() {
                    try {
                        String oldValue;
                        Object value = cellEditor.getValue();
                        String string = oldValue = columnIndex == 0 ? prop.property.getDisplayName() : prop.propertySource.getPropertyValue(null, prop.property.getId());
                        if (value instanceof String && ((String)value).isEmpty() && oldValue == null) {
                            return;
                        }
                        if (DBUtils.compareDataValues((Object)oldValue, (Object)value) != 0) {
                            if (columnIndex == 0) {
                                String newName = CommonUtils.toString((Object)value);
                                String oldPropId = prop.property.getId();
                                Object oldPropValue = prop.propertySource.getPropertyValue(null, prop.property.getId());
                                ((DBPNamedObject2)prop.property).setName(newName);
                                if (oldPropValue != null) {
                                    prop.propertySource.resetPropertyValueToDefault(oldPropId);
                                    prop.propertySource.setPropertyValue(null, prop.property.getId(), oldPropValue);
                                }
                            } else {
                                prop.propertySource.setPropertyValue(null, prop.property.getId(), value);
                            }
                            PropertyTreeViewer.this.handlePropertyChange(prop);
                        }
                        PropertyTreeViewer.this.disposeOldEditor();
                    }
                    catch (Exception e) {
                        DBWorkbench.getPlatformUI().showError("Error setting property value", "Error setting property '" + prop.property.getDisplayName() + "' value", (Throwable)e);
                    }
                }

                public void cancelEditor() {
                    PropertyTreeViewer.this.disposeOldEditor();
                }

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                }
            };
            cellEditor.addListener(cellEditorListener);
            if (propertyValue != null) {
                cellEditor.setValue(UIUtils.normalizePropertyValue(propertyValue));
            }
            this.curCellEditor = cellEditor;
            this.selectedProperty = prop.property;
            if (isDef) {
                cellEditor.activate();
            }
            if ((editorControl = cellEditor.getControl()) != null) {
                editorControl.addTraverseListener(e -> {
                    if (e.detail == 2) {
                        e.doit = false;
                        e.detail = 0;
                        this.disposeOldEditor();
                        if (prop.isEditable()) {
                            new ActionResetProperty(prop, false).run();
                        }
                    }
                });
                this.treeEditor.verticalAlignment = cellEditor.getLayoutData().verticalAlignment;
                this.treeEditor.horizontalAlignment = cellEditor.getLayoutData().horizontalAlignment;
                this.treeEditor.minimumWidth = cellEditor.getLayoutData().minimumWidth;
                this.treeEditor.grabHorizontal = cellEditor.getLayoutData().grabHorizontal;
                this.treeEditor.setEditor(editorControl, item, columnIndex);
            }
            if (isDef) {
                cellEditor.setFocus();
            }
        }
    }

    private void registerContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> {
            ITreeSelection selection = this.getStructuredSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object object = selection.getFirstElement();
            if (object instanceof TreeNode) {
                final TreeNode prop = (TreeNode)object;
                if (prop.property != null) {
                    manager.add((IAction)new Action(UIMessages.ui_properties_tree_viewer_action_copy_name){

                        public void run() {
                            UIUtils.setClipboardContents(Display.getDefault(), (Transfer)TextTransfer.getInstance(), prop.property.getDisplayName());
                        }
                    });
                    final String stringValue = CommonUtils.toString((Object)this.getPropertyValue(prop));
                    if (!CommonUtils.isEmpty((String)stringValue)) {
                        manager.add((IAction)new Action(UIMessages.ui_properties_tree_viewer_action_copy_value){

                            public void run() {
                                UIUtils.setClipboardContents(Display.getDefault(), (Transfer)TextTransfer.getInstance(), stringValue);
                            }
                        });
                    }
                    if (this.isPropertyChanged(prop) && prop.isEditable() && (!(prop.propertySource instanceof IPropertySource2) || prop.propertySource.isPropertyResettable(prop.property.getId()))) {
                        manager.add((IAction)new ActionResetProperty(prop, false));
                        if (!this.isCustomProperty(prop.property)) {
                            manager.add((IAction)new ActionResetProperty(prop, true));
                        }
                    }
                }
                manager.add((IContributionItem)new Separator());
                this.contributeContextMenu(manager, object, (String)(prop.category != null ? prop.category : (prop.property == null ? null : prop.property.getCategory())), prop.property);
            }
        });
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu((Control)this.getTree());
        this.getTree().setMenu(menu);
        this.getTree().addDisposeListener(e -> menuMgr.dispose());
    }

    private boolean isCustomProperty(DBPPropertyDescriptor property) {
        if (this.customCategories != null) {
            String[] stringArray = this.customCategories;
            int n = this.customCategories.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                if (category.equals(property.getCategory())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected String[] getCustomCategories() {
        return null;
    }

    protected void contributeContextMenu(IMenuManager manager, Object node, String category, DBPPropertyDescriptor property) {
    }

    public DBPPropertyDescriptor getPropertyFromElement(Object element) {
        if (element instanceof TreeNode) {
            return ((TreeNode)element).property;
        }
        return null;
    }

    private Object getPropertyValue(TreeNode prop) {
        if (prop.category != null) {
            return prop.category;
        }
        Object propertyValue = prop.propertySource.getPropertyValue(null, prop.property.getId());
        return GeneralUtils.makeDisplayString((Object)propertyValue);
    }

    private boolean isPropertyChanged(TreeNode prop) {
        return prop.propertySource.isPropertySet(prop.property.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePropertyChange(TreeNode prop) {
        Event event;
        ArrayList<IPropertyChangeListener> listenersCopy;
        super.update((Object)prop, null);
        List<IPropertyChangeListener> list = this.propertyListeners;
        synchronized (list) {
            listenersCopy = new ArrayList<IPropertyChangeListener>(this.propertyListeners);
        }
        if (!listenersCopy.isEmpty()) {
            event = new PropertyChangeEvent((Object)this, CommonUtils.toString((Object)prop.property.getId()), null, this.getPropertyValue(prop));
            for (IPropertyChangeListener listener : listenersCopy) {
                listener.propertyChange((PropertyChangeEvent)event);
            }
        }
        event = new Event();
        event.data = prop.property;
        this.getTree().notifyListeners(24, event);
    }

    private void handlePropertyCreate(TreeNode prop) {
        this.handlePropertyChange(prop);
        super.refresh((Object)prop.parent);
        super.expandToLevel((Object)prop.parent, 1);
        super.reveal((Object)prop);
        super.setSelection((ISelection)new StructuredSelection((Object)prop));
    }

    private void handlePropertyRemove(TreeNode prop) {
        this.handlePropertyChange(prop);
        super.refresh((Object)prop.parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        List<IPropertyChangeListener> list = this.propertyListeners;
        synchronized (list) {
            this.propertyListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        List<IPropertyChangeListener> list = this.propertyListeners;
        synchronized (list) {
            this.propertyListeners.remove(listener);
        }
    }

    public void setExpandMode(ExpandMode expandMode) {
        this.expandMode = expandMode;
    }

    protected void setExpandSingleRoot(boolean expandSingleRoot) {
        this.expandSingleRoot = expandSingleRoot;
    }

    public void setExtraLabelProvider(IBaseLabelProvider extraLabelProvider) {
        this.extraLabelProvider = extraLabelProvider;
    }

    public DBPPropertyDescriptor getSelectedProperty() {
        Object element;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof TreeNode) {
            TreeNode prop = (TreeNode)element;
            return prop.property;
        }
        return null;
    }

    public String getSelectedCategory() {
        Object element;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof TreeNode) {
            TreeNode prop = (TreeNode)element;
            return prop.parent != null ? prop.parent.category : prop.category;
        }
        return null;
    }

    public Object getCategoryNode(String category) {
        Object input = this.getInput();
        if (input instanceof Collection) {
            for (Object element : (Collection)input) {
                if (!(element instanceof TreeNode) || !category.equals(((TreeNode)element).category)) continue;
                return element;
            }
        }
        return null;
    }

    public void saveEditorValues() {
        if (RuntimeUtils.isMacOS() && this.curCellEditor != null && this.curCellEditor.isActivated()) {
            try {
                Method focusLost = CellEditor.class.getDeclaredMethod("focusLost", new Class[0]);
                focusLost.setAccessible(true);
                focusLost.invoke((Object)this.curCellEditor, new Object[0]);
            }
            catch (Throwable throwable) {}
        }
    }

    private String maskHiddenPropertyValue(Object propertyValue) {
        return CommonUtils.isEmpty((String)CommonUtils.toString((Object)propertyValue)) ? "" : "**********";
    }

    protected boolean isHidePropertyValue(DBPPropertyDescriptor property) {
        return false;
    }

    private class ActionResetProperty
    extends Action {
        private final TreeNode prop;
        private final boolean toDefault;

        ActionResetProperty(TreeNode prop, boolean toDefault) {
            super(String.valueOf(UIMessages.ui_properties_tree_viewer_action_reset_value) + (!toDefault ? "" : UIMessages.ui_properties_tree_viewer__to_default));
            this.prop = prop;
            this.toDefault = toDefault;
        }

        public void run() {
            if (this.prop.propertySource != null) {
                if (this.toDefault) {
                    this.prop.propertySource.resetPropertyValueToDefault(this.prop.property.getId());
                } else {
                    this.prop.propertySource.resetPropertyValue(null, this.prop.property.getId());
                }
            }
            PropertyTreeViewer.this.handlePropertyChange(this.prop);
            PropertyTreeViewer.this.update(this.prop, null);
            PropertyTreeViewer.this.disposeOldEditor();
        }
    }

    public static enum ExpandMode {
        NONE,
        FIRST,
        ALL;

    }

    public static class NodeFilter
    extends ViewerFilter {
        private final String searchString;

        public NodeFilter(String searchString) {
            this.searchString = searchString.toUpperCase(Locale.ENGLISH);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof TreeNode) {
                DBPPropertyDescriptor property = ((TreeNode)element).property;
                if (property != null) {
                    return property.getDisplayName().toUpperCase(Locale.ENGLISH).contains(this.searchString);
                }
                if (((TreeNode)element).category != null) {
                    return true;
                }
            }
            return false;
        }
    }

    class PaintListener
    implements Listener {
        PaintListener() {
        }

        public void handleEvent(Event event) {
            if (PropertyTreeViewer.this.getTree().isDisposed()) {
                return;
            }
            switch (event.type) {
                case 42: {
                    if (event.index != 1) break;
                    if (PropertyTreeViewer.this.treeEditor != null && PropertyTreeViewer.this.treeEditor.getItem() == event.item && PropertyTreeViewer.this.treeEditor.getEditor() != null && !PropertyTreeViewer.this.treeEditor.getEditor().isDisposed() && PropertyTreeViewer.this.treeEditor.getEditor().isVisible()) {
                        return;
                    }
                    TreeNode node = (TreeNode)event.item.getData();
                    if (node == null || node.property == null) break;
                    Object cellValue = PropertyTreeViewer.this.renderer.getCellValue(node, event.index);
                    PropertyTreeViewer.this.renderer.paintCell(event, node, cellValue, event.item, node.property.getDataType(), event.index, node.isEditable(), (event.detail & 2) == 2);
                }
            }
        }
    }

    static class PropsContentProvider
    implements IStructuredContentProvider,
    ITreeContentProvider {
        PropsContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof TreeNode) {
                return ((TreeNode)child).parent;
            }
            return null;
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof Collection) {
                return ((Collection)parent).toArray();
            }
            if (parent instanceof TreeNode) {
                return ((TreeNode)parent).children.toArray();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }
    }

    private class PropsLabelProvider
    extends CellLabelProvider {
        private final boolean isName;

        PropsLabelProvider(boolean isName) {
            this.isName = isName;
        }

        public String getText(Object obj, int columnIndex) {
            if (!(obj instanceof TreeNode)) {
                return "";
            }
            TreeNode node = (TreeNode)obj;
            if (columnIndex == 0) {
                if (node.category != null) {
                    return node.category;
                }
                return node.property.getDisplayName();
            }
            if (node.property != null) {
                Object propertyValue = PropertyTreeViewer.this.getPropertyValue(node);
                Class propDataType = node.property.getDataType();
                if (Boolean.class == propDataType || Boolean.TYPE == propDataType) {
                    if (propertyValue != null && !(propertyValue instanceof Boolean)) {
                        propertyValue = CommonUtils.toBoolean((Object)propertyValue);
                    }
                    if (PropertyTreeViewer.this.renderer.getBooleanStyles().getMode() == BooleanMode.TEXT) {
                        return PropertyTreeViewer.this.renderer.getBooleanStyles().getStyle((Boolean)propertyValue).getText();
                    }
                    return "";
                }
                if (propertyValue == null || PropertyTreeViewer.this.renderer.isHyperlink(propertyValue)) {
                    return "";
                }
                if (PropertyTreeViewer.this.isHidePropertyValue(node.property)) {
                    return PropertyTreeViewer.this.maskHiddenPropertyValue(propertyValue);
                }
                if (BeanUtils.isCollectionType(propertyValue.getClass())) {
                    StringBuilder str = new StringBuilder();
                    str.append("[");
                    if (propertyValue instanceof Collection) {
                        int i = 0;
                        for (Object item : (Collection)propertyValue) {
                            if (i > 0) {
                                str.append(",");
                            }
                            str.append(GeneralUtils.makeDisplayString(item));
                            ++i;
                        }
                    } else {
                        int size = Array.getLength(propertyValue);
                        int i = 0;
                        while (i < size) {
                            if (i > 0) {
                                str.append(",");
                            }
                            str.append(GeneralUtils.makeDisplayString((Object)Array.get(propertyValue, i)));
                            ++i;
                        }
                    }
                    str.append("]");
                    return str.toString();
                }
                return ObjectViewerRenderer.getCellString(propertyValue, this.isName);
            }
            return "";
        }

        @Nullable
        public Color getForeground(Object obj, int columnIndex) {
            if (obj instanceof TreeNode && columnIndex > 0) {
                TreeNode node = (TreeNode)obj;
                if (node.property != null) {
                    Object propertyValue = PropertyTreeViewer.this.getPropertyValue(node);
                    Class propertyDataType = node.property.getDataType();
                    if (Boolean.class == propertyDataType || Boolean.TYPE == propertyDataType) {
                        if (propertyValue != null && !(propertyValue instanceof Boolean)) {
                            propertyValue = CommonUtils.toBoolean((Object)propertyValue);
                        }
                        if (PropertyTreeViewer.this.renderer.getBooleanStyles().getMode() == BooleanMode.TEXT) {
                            return UIUtils.getSharedColor(PropertyTreeViewer.this.renderer.getBooleanStyles().getStyle((Boolean)propertyValue).getColor());
                        }
                        return null;
                    }
                }
            }
            return null;
        }

        public String getToolTipText(Object obj) {
            String toolTip;
            if (!(obj instanceof TreeNode)) {
                return null;
            }
            TreeNode node = (TreeNode)obj;
            if (node.category != null) {
                toolTip = node.category;
            } else {
                String string = toolTip = this.isName ? node.property.getDescription() : this.getText(obj, 1);
            }
            if (CommonUtils.isEmpty((String)toolTip)) {
                return null;
            }
            if (toolTip.contains("\\n")) {
                toolTip = toolTip.replace("\\n", "\n");
                toolTip = this.wrap(toolTip);
            }
            return toolTip;
        }

        private String wrap(String s) {
            StringBuilder buffer = new StringBuilder();
            String delim = "";
            String[] stringArray = s.trim().split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                buffer.append(delim);
                delim = "\n";
                buffer.append(this.wrap(line, 100, "\n", true));
                ++n2;
            }
            return buffer.toString();
        }

        public String wrap(String str, int wrapLength, String newLineStr, boolean wrapLongWords) {
            if (str == null) {
                return null;
            }
            if (newLineStr == null) {
                newLineStr = LINE_SEPARATOR;
            }
            if (wrapLength < 1) {
                wrapLength = 1;
            }
            int inputLineLength = str.length();
            int offset = 0;
            StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
            while (inputLineLength - offset > wrapLength) {
                if (str.charAt(offset) == ' ') {
                    ++offset;
                    continue;
                }
                int spaceToWrapAt = str.lastIndexOf(32, wrapLength + offset);
                if (spaceToWrapAt >= offset) {
                    wrappedLine.append(str.substring(offset, spaceToWrapAt));
                    wrappedLine.append(newLineStr);
                    offset = spaceToWrapAt + 1;
                    continue;
                }
                if (wrapLongWords) {
                    wrappedLine.append(str.substring(offset, wrapLength + offset));
                    wrappedLine.append(newLineStr);
                    offset += wrapLength;
                    continue;
                }
                spaceToWrapAt = str.indexOf(32, wrapLength + offset);
                if (spaceToWrapAt >= 0) {
                    wrappedLine.append(str.substring(offset, spaceToWrapAt));
                    wrappedLine.append(newLineStr);
                    offset = spaceToWrapAt + 1;
                    continue;
                }
                wrappedLine.append(str.substring(offset));
                offset = inputLineLength;
            }
            wrappedLine.append(str.substring(offset));
            return wrappedLine.toString();
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            cell.setText(this.getText(element, cell.getColumnIndex()));
            cell.setForeground(this.getForeground(element, cell.getColumnIndex()));
            if (!(element instanceof TreeNode)) {
                return;
            }
            TreeNode node = (TreeNode)element;
            boolean changed = false;
            if (node.property != null) {
                boolean bl = changed = node.isEditable() && PropertyTreeViewer.this.isPropertyChanged(node);
            }
            if (PropertyTreeViewer.this.extraLabelProvider instanceof IFontProvider) {
                cell.setFont(((IFontProvider)PropertyTreeViewer.this.extraLabelProvider).getFont((Object)node.property));
            } else if (changed) {
                cell.setFont(PropertyTreeViewer.this.boldFont);
            } else {
                cell.setFont(null);
            }
        }
    }

    private class SortListener
    implements Listener {
        int sortDirection = 1024;
        TreeColumn prevColumn = null;

        private SortListener() {
        }

        public void handleEvent(Event e) {
            PropertyTreeViewer.this.disposeOldEditor();
            PropertyTreeViewer.this.getTree().setRedraw(false);
            try {
                Collator collator = Collator.getInstance(Locale.getDefault());
                TreeColumn column = (TreeColumn)e.widget;
                Tree tree = PropertyTreeViewer.this.getTree();
                if (this.prevColumn == column) {
                    this.sortDirection = this.sortDirection == 128 ? 1024 : 128;
                }
                this.prevColumn = column;
                tree.setSortColumn(column);
                tree.setSortDirection(this.sortDirection);
                PropertyTreeViewer.this.setComparator(new ViewerComparator(collator){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        int mul = SortListener.this.sortDirection == 128 ? 1 : -1;
                        TreeNode n1 = (TreeNode)e1;
                        TreeNode n2 = (TreeNode)e2;
                        int result = n1.property != null && n2.property != null ? n1.property.getDisplayName().compareTo(n2.property.getDisplayName()) : (n1.category != null && n2.category != null ? n1.category.compareTo(n2.category) : 0);
                        return result * mul;
                    }
                });
            }
            finally {
                PropertyTreeViewer.this.getTree().setRedraw(true);
            }
        }
    }

    private static class TreeNode {
        final TreeNode parent;
        final DBPPropertySource propertySource;
        final DBPPropertyDescriptor property;
        final String category;
        final List<TreeNode> children = new ArrayList<TreeNode>();

        private TreeNode(TreeNode parent, DBPPropertySource propertySource, DBPPropertyDescriptor property, String category) {
            this.parent = parent;
            this.propertySource = propertySource;
            this.property = property;
            this.category = category;
            if (parent != null) {
                parent.children.add(this);
            }
        }

        private TreeNode(TreeNode parent, DBPPropertySource propertySource, DBPPropertyDescriptor property) {
            this(parent, propertySource, property, null);
        }

        private TreeNode(TreeNode parent, DBPPropertySource propertySource, String category) {
            this(parent, propertySource, null, category);
        }

        boolean isEditable() {
            return this.property != null && this.property.isEditable(this.propertySource.getEditableValue());
        }

        public String toString() {
            return this.property == null ? this.category : String.valueOf(this.property.getId()) + " (" + this.property.getDisplayName() + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof TreeNode) {
                TreeNode node = (TreeNode)obj;
                if (this == node) {
                    return true;
                }
                return this.propertySource.getEditableValue() == node.propertySource.getEditableValue() && (this.category != null ? CommonUtils.equalObjects((Object)this.category, (Object)node.category) : this.property != null && node.property != null && CommonUtils.equalObjects((Object)this.property.getId(), (Object)node.property.getId()));
            }
            return super.equals(obj);
        }
    }
}

