/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataType;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTypeType;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCStructImpl;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCollection;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCComposite;
import org.jkiss.dbeaver.model.impl.jdbc.data.JDBCCompositeStatic;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObjectEx;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.csv.CSVReaderBuilder;
import org.jkiss.utils.csv.CSVReaderNullFieldIndicator;
import org.jkiss.utils.csv.CSVWriter;

public class PostgreValueParser {
    private static final Log log = Log.getLog(PostgreValueParser.class);

    public static Object convertStringToValue(DBCSession session, DBSTypedObject arrayType, String string) throws DBCException {
        if (arrayType.getDataKind() == DBPDataKind.ARRAY) {
            if (string != null && string.startsWith("{") && string.endsWith("}")) {
                try {
                    return PostgreValueParser.prepareToParseArray(session, arrayType, string);
                }
                catch (Exception e) {
                    log.error((Object)("Array parsing failed " + e.getMessage()));
                    return string;
                }
            }
            return string;
        }
        if (CommonUtils.isEmpty((String)string)) {
            return PostgreValueParser.convertStringToSimpleValue(session, arrayType, string);
        }
        try {
            switch (arrayType.getTypeID()) {
                case 16: {
                    if (string.length() > 0 && Character.toLowerCase(string.charAt(0)) == 't') {
                        return true;
                    }
                    return false;
                }
                case -6: {
                    return Byte.parseByte(string);
                }
                case 5: {
                    return Short.parseShort(string);
                }
                case 4: {
                    return Integer.parseInt(string);
                }
                case -5: {
                    return Long.parseLong(string);
                }
                case 6: {
                    return Float.valueOf(Float.parseFloat(string));
                }
                case 2: 
                case 7: 
                case 8: {
                    return Double.parseDouble(string);
                }
            }
            return PostgreValueParser.convertStringToSimpleValue(session, arrayType, string);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    private static Object prepareToParseArray(DBCSession session, DBSTypedObject arrayType, String string) throws DBCException {
        DBSDataType arrayDataType = arrayType instanceof DBSDataType ? (DBSDataType)arrayType : ((DBSTypedObjectEx)arrayType).getDataType();
        try {
            if (arrayDataType == null) {
                log.error((Object)("Can't get array type '" + arrayType.getFullTypeName() + "'"));
                return string;
            }
            Object componentType = arrayDataType.getComponentType(session.getProgressMonitor());
            if (componentType == null && arrayType instanceof PostgreDataType && ((PostgreDataType)arrayType).getTypeType() == PostgreTypeType.d) {
                componentType = ((PostgreDataType)arrayType).getBaseType(session.getProgressMonitor());
            }
            if (componentType == null) {
                log.error((Object)("Can't get component type from array '" + arrayType.getFullTypeName() + "'"));
                return string;
            }
            if (componentType instanceof PostgreDataType) {
                List<Object> itemStrings = PostgreValueParser.parseArrayString(string, ",");
                return PostgreValueParser.startTransformListOfValuesIntoArray(session, (PostgreDataType)componentType, itemStrings);
            }
            log.error((Object)("Incorrect type '" + arrayType.getFullTypeName() + "'"));
            return string;
        }
        catch (Exception e) {
            if (e instanceof DBCException) {
                throw (DBCException)((Object)e);
            }
            throw new DBCException("Error parsing array '" + arrayType.getFullTypeName() + "' items", (Throwable)e);
        }
    }

    private static Object startTransformListOfValuesIntoArray(DBCSession session, PostgreDataType itemType, List<?> list) throws DBException {
        return PostgreValueParser.transformListOfValuesIntoArray(session, itemType, list, true);
    }

    private static Object transformListOfValuesIntoArray(DBCSession session, PostgreDataType itemType, List<?> list, boolean firstAttempt) throws DBException {
        Object[] values = new Object[list.size()];
        int index = 0;
        while (index < list.size()) {
            Object item = list.get(index);
            if (!(item instanceof List)) {
                Object[] itemValues = new Object[list.size()];
                int i = 0;
                while (i < list.size()) {
                    itemValues[i] = PostgreValueParser.convertStringToValue(session, (DBSTypedObject)itemType, (String)list.get(i));
                    ++i;
                }
                if (firstAttempt) {
                    return itemValues;
                }
                return new JDBCCollection(session.getProgressMonitor(), (DBSDataType)itemType, DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType), itemValues);
            }
            Object parsedValue = itemType.getDataKind() == DBPDataKind.STRUCT ? PostgreValueParser.transformListOfValuesIntoStruct(session, itemType, (List)item) : PostgreValueParser.transformListOfValuesIntoArray(session, itemType, (List)item, false);
            values[index] = parsedValue;
            ++index;
        }
        if (firstAttempt) {
            return values;
        }
        return new JDBCCollection(session.getProgressMonitor(), (DBSDataType)itemType, DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType), values);
    }

    private static Object transformListOfValuesIntoStruct(DBCSession session, PostgreDataType itemType, List<?> list) throws DBException {
        List attributes = CommonUtils.safeList(itemType.getAttributes(session.getProgressMonitor()));
        Object[] itemValues = new Object[attributes.size()];
        if (list.size() == 1 && list.get(0) instanceof List) {
            list = (List)list.get(0);
        }
        int i = 0;
        while (i < list.size()) {
            Object item = list.get(i);
            if (item instanceof String) {
                itemValues[i] = PostgreValueParser.convertStringToValue(session, (DBSTypedObject)itemType, (String)item);
            } else if (item instanceof List) {
                if (((List)item).size() == 1) {
                    Object subItem = ((List)item).get(0);
                    if (subItem instanceof String) {
                        itemValues[i] = PostgreValueParser.convertStringToValue(session, (DBSTypedObject)itemType, (String)subItem);
                    } else {
                        log.debug((Object)("Invalid sub item type: " + subItem.getClass().getName()));
                    }
                } else {
                    log.debug((Object)("Invalid struct list size: " + ((List)item).size()));
                }
            } else {
                log.debug((Object)("Invalid struct item type: " + item));
            }
            ++i;
        }
        JDBCStructImpl contents = new JDBCStructImpl(itemType.getTypeName(), itemValues, list.toString());
        return new JDBCCompositeStatic(session, (DBSDataType)itemType, (Struct)contents);
    }

    private static Object convertStringToSimpleValue(DBCSession session, DBSTypedObject itemType, String string) throws DBCException {
        DBDValueHandler valueHandler = DBUtils.findValueHandler((DBCSession)session, (DBSTypedObject)itemType);
        if (valueHandler != null) {
            return valueHandler.getValueFromObject(session, itemType, (Object)string, false, false);
        }
        return string;
    }

    public static String[] parseSingleObject(String string) throws DBCException {
        if (string.isEmpty()) {
            return new String[0];
        }
        try {
            return new CSVReaderBuilder((Reader)new StringReader(string)).withFieldAsNull(CSVReaderNullFieldIndicator.EMPTY_SEPARATORS).build().readNext();
        }
        catch (IOException e) {
            throw new DBCException("Error parsing PGObject", (Throwable)e);
        }
    }

    public static String generateObjectString(Object[] values) {
        String[] line = new String[values.length];
        int i = 0;
        while (i < values.length) {
            Object value = values[i];
            if (value instanceof DBDCollection) {
                value = ((DBDCollection)value).getRawValue();
            }
            if (value instanceof Object[]) {
                String arrayPostgreStyle;
                line[i] = arrayPostgreStyle = Arrays.deepToString((Object[])value).replace("[", "{").replace("]", "}").replace(" ", "");
            } else if (value instanceof JDBCComposite) {
                line[i] = PostgreValueParser.generateObjectString(((JDBCComposite)value).getValues());
            } else if (value != null) {
                line[i] = value.toString();
            }
            ++i;
        }
        StringWriter out = new StringWriter();
        CSVWriter writer = new CSVWriter((Writer)out);
        writer.writeNext(line);
        try {
            writer.flush();
        }
        catch (IOException e) {
            log.warn((Object)e);
        }
        return "(" + out.toString().trim() + ")";
    }

    /*
     * Unable to fully structure code
     */
    public static List<Object> parseArrayString(String fieldString, String delimiter) throws DBCException {
        block21: {
            arrayList = new ArrayList<Object>();
            if (CommonUtils.isEmpty((String)fieldString)) {
                return arrayList;
            }
            delim = delimiter.charAt(0);
            if (fieldString == null) break block21;
            bracePairsCount = 0;
            chars = fieldString.toCharArray();
            buffer = null;
            insideString = false;
            wasInsideString = false;
            dims = new ArrayList<ArrayList<E>>();
            curArray = arrayList;
            startOffset = 0;
            if (chars[0] == '[') {
                while (chars[startOffset] != '=') {
                    ++startOffset;
                }
                ++startOffset;
            }
            i = startOffset;
            while (i < chars.length) {
                block23: {
                    block22: {
                        if (chars[i] != '\\') break block22;
                        ++i;
                        ** GOTO lbl-1000
                    }
                    if (!insideString && chars[i] == '{') {
                        if (dims.isEmpty()) {
                            dims.add(arrayList);
                        } else {
                            a = new ArrayList<E>();
                            p = (List)dims.get(dims.size() - 1);
                            p.add(a);
                            dims.add(a);
                        }
                        ++bracePairsCount;
                        curArray = (List)dims.get(dims.size() - 1);
                        t = i + 1;
                        while (t < chars.length) {
                            if (!Character.isWhitespace(chars[t]) && chars[t] != '{') break;
                            ++t;
                        }
                        buffer = new StringBuilder();
                    } else if (chars[i] == '\"') {
                        insideString = insideString == false;
                        wasInsideString = true;
                    } else if (insideString || !Character.isWhitespace(chars[i])) {
                        ** if ((insideString || chars[i] != delim && chars[i] != '}') && i != chars.length - 1) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            if (chars[i] != '\"' && chars[i] != '}' && chars[i] != delim && buffer != null) {
                                buffer.append((char)chars[i]);
                            } else {
                                ** GOTO lbl54
                            }
lbl54:
                            // 3 sources

                            v0 = b = buffer == null ? null : buffer.toString();
                            if (b != null && (!b.isEmpty() || wasInsideString)) {
                                curArray.add((Object)(wasInsideString == false && b.equals((Object)"NULL") != false ? null : b));
                            } else {
                                ** GOTO lbl58
                            }
lbl58:
                            // 3 sources

                            wasInsideString = false;
                            buffer = new StringBuilder();
                            if (chars[i] == '}') {
                                if (dims.isEmpty()) {
                                    throw new DBCException((String)("Redundant trailing bracket in " + fieldString));
                                } else {
                                    ** GOTO lbl63
                                }
lbl63:
                                // 2 sources

                                dims.remove((int)(dims.size() - 1));
                                --bracePairsCount;
                                if (!dims.isEmpty()) {
                                    curArray = (List)dims.get((int)(dims.size() - 1));
                                } else {
                                    ** GOTO lbl68
                                }
lbl68:
                                // 3 sources

                                buffer = null;
                            } else {
                                ** GOTO lbl69
                            }
lbl69:
                            // 3 sources

                            ** GOTO lbl74
                        }
                    }
                    break block23;
lbl-1000:
                    // 2 sources

                    {
                        if (buffer != null) {
                            buffer.append(chars[i]);
                        }
                    }
                }
                ++i;
            }
            if (bracePairsCount != 0) {
                throw new DBCException("Amount of array's braces is not equal");
            }
        }
        return arrayList;
    }
}

