/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.data.handlers;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.data.DateTimeCustomValueHandler;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class JDBCDateTimeValueHandler
extends DateTimeCustomValueHandler {
    public static final SimpleDateFormat DEFAULT_DATETIME_FORMAT = new SimpleDateFormat("''yyyy-MM-dd HH:mm:ss.SSS''");
    public static final SimpleDateFormat DEFAULT_DATETIME_TZ_FORMAT = new SimpleDateFormat("''yyyy-MM-dd HH:mm:ss.SSS Z''");
    public static final SimpleDateFormat DEFAULT_DATE_FORMAT = new SimpleDateFormat("''yyyy-MM-dd''");
    public static final SimpleDateFormat DEFAULT_TIME_FORMAT = new SimpleDateFormat("''HH:mm:ss''");
    public static final SimpleDateFormat DEFAULT_TIME_TZ_FORMAT = new SimpleDateFormat("''HH:mm:ss Z''");

    public JDBCDateTimeValueHandler(DBDFormatSettings formatSettings) {
        super(formatSettings);
    }

    @Override
    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        Object value = super.getValueFromObject(session, type, object, copy, validateValue);
        if (value instanceof java.util.Date) {
            switch (type.getTypeID()) {
                case 92: 
                case 2013: {
                    return JDBCDateTimeValueHandler.getTimeValue(value);
                }
                case 91: {
                    return JDBCDateTimeValueHandler.getDateValue(value);
                }
            }
            return JDBCDateTimeValueHandler.getTimestampValue(value);
        }
        return value;
    }

    @Override
    public Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        try {
            if (resultSet instanceof JDBCResultSet) {
                JDBCResultSet dbResults = (JDBCResultSet)resultSet;
                if (this.formatSettings.isUseNativeDateTimeFormat()) {
                    try {
                        return dbResults.getString(index + 1);
                    }
                    catch (SQLException e) {
                        log.debug("Can't read date/time value as string: " + e.getMessage());
                    }
                }
                switch (type.getTypeID()) {
                    case 92: 
                    case 2013: {
                        return dbResults.getTime(index + 1);
                    }
                    case 91: {
                        return dbResults.getDate(index + 1);
                    }
                }
                Object value = dbResults.getObject(index + 1);
                return this.getValueFromObject(session, type, value, false, false);
            }
            return resultSet.getAttributeValue(index);
        }
        catch (SQLException e) {
            block17: {
                try {
                    if (!(e.getCause() instanceof ParseException) && !(e.getCause() instanceof UnsupportedOperationException)) break block17;
                    Object objectValue = ((JDBCResultSet)resultSet).getObject(index + 1);
                    if (objectValue instanceof java.util.Date) {
                        return objectValue;
                    }
                    if (objectValue instanceof String) {
                        return objectValue;
                    }
                    if (objectValue != null) {
                        return objectValue.toString();
                    }
                    return null;
                }
                catch (SQLException e1) {
                    log.debug("Can't retrieve datetime object", e1);
                    return null;
                }
            }
            if (SQLState.SQL_42000.getCode().equals(e.getSQLState()) || SQLState.SQL_S1009.getCode().equals(e.getSQLState()) || SQLState.SQL_HY000.getCode().equals(e.getSQLState())) {
                return ((JDBCResultSet)resultSet).getString(index + 1);
            }
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @Override
    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, @Nullable Object value) throws DBCException {
        try {
            JDBCPreparedStatement dbStat = (JDBCPreparedStatement)statement;
            if (value == null) {
                dbStat.setNull(index + 1, type.getTypeID());
            } else if (value instanceof String) {
                dbStat.setString(index + 1, (String)value);
            } else {
                switch (type.getTypeID()) {
                    case 92: 
                    case 2013: {
                        dbStat.setTime(index + 1, JDBCDateTimeValueHandler.getTimeValue(value));
                        break;
                    }
                    case 91: {
                        dbStat.setDate(index + 1, JDBCDateTimeValueHandler.getDateValue(value));
                        break;
                    }
                    default: {
                        dbStat.setTimestamp(index + 1, JDBCDateTimeValueHandler.getTimestampValue(value));
                        break;
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new DBCException(ModelMessages.model_jdbc_exception_could_not_bind_statement_parameter, e);
        }
    }

    @Override
    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (format == DBDDisplayFormat.NATIVE) {
            if (value instanceof java.util.Date) {
                Format nativeFormat = this.getNativeValueFormat(column);
                if (nativeFormat != null) {
                    try {
                        return nativeFormat.format(value);
                    }
                    catch (Exception e) {
                        log.error("Error formatting date", e);
                    }
                }
            } else if (value instanceof String) {
                String strValue = (String)value;
                if (!strValue.startsWith("'") && !strValue.endsWith("'")) {
                    strValue = "'" + strValue + "'";
                }
                return super.getValueDisplayString(column, strValue, format);
            }
        }
        return super.getValueDisplayString(column, value, format);
    }

    @Nullable
    protected Format getNativeValueFormat(DBSTypedObject type) {
        switch (type.getTypeID()) {
            case 93: {
                return DEFAULT_DATETIME_FORMAT;
            }
            case 2014: {
                return DEFAULT_DATETIME_FORMAT;
            }
            case 92: {
                return DEFAULT_TIME_FORMAT;
            }
            case 2013: {
                return DEFAULT_TIME_TZ_FORMAT;
            }
            case 91: {
                return DEFAULT_DATE_FORMAT;
            }
        }
        return null;
    }

    @Override
    @NotNull
    protected String getFormatterId(DBSTypedObject column) {
        switch (column.getTypeID()) {
            case 92: {
                return "time";
            }
            case 91: {
                return "date";
            }
            case 2013: {
                return "timetz";
            }
            case 2014: {
                return "timestamptz";
            }
        }
        return "timestamp";
    }

    @Nullable
    protected static Time getTimeValue(Object value) {
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof java.util.Date) {
            return new Time(((java.util.Date)value).getTime());
        }
        if (value != null) {
            return Time.valueOf(value.toString());
        }
        return null;
    }

    @Nullable
    protected static Date getDateValue(Object value) {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value != null) {
            return Date.valueOf(value.toString());
        }
        return null;
    }

    @Nullable
    protected static Timestamp getTimestampValue(Object value) {
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)value);
        }
        if (value != null) {
            return Timestamp.valueOf(value.toString());
        }
        return null;
    }

    protected static String getTwoDigitValue(int value) {
        if (value < 10) {
            return "0" + value;
        }
        return String.valueOf(value);
    }
}

