/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.console;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.data.console.ConsoleMessages;
import org.jkiss.dbeaver.data.console.SQLConsoleView;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListener;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorListenerDefault;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class ConsoleViewSwitchHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(ConsoleViewSwitchHandler.class);
    private static final String BUNDLE_NAME = "org.jkiss.dbeaver.data.console";
    private static final String CONSOLE_VIEW_ENABLED_PROPERTY = "org.jkiss.dbeaver.ui.editors.sql.show.consoleView.isEnabled";
    private static final String CONSOLE_VIEW_ENABLED_VALUE_TRUE = "true";
    private static final String CONSOLE_VIEW_ENABLED_VALUE_FALSE = "false";
    private static final String CONSOLE_VIEW_ENABLED_VALUE_DEFAULT = "default";
    private static final QualifiedName FILE_CONSOLE_VIEW_ENABLED_PROP_NAME = new QualifiedName("org.jkiss.dbeaver.data.console", "org.jkiss.dbeaver.ui.editors.sql.show.consoleView.isEnabled");

    @Nullable
    private static Pair<SQLConsoleView, CTabItem> findExistingConsoleView(@NotNull SQLEditor editor) {
        CTabItem[] cTabItemArray = editor.getResultTabsContainer().getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem tabItem = cTabItemArray[n2];
            if (tabItem.getData() instanceof SQLConsoleView) {
                return new Pair((Object)((SQLConsoleView)((Object)tabItem.getData())), (Object)tabItem);
            }
            ++n2;
        }
        return null;
    }

    @NotNull
    private static Pair<SQLConsoleView, CTabItem> createSQLConsoleView(final @NotNull SQLEditor editor) {
        final CTabFolder tabsContainer = editor.getResultTabsContainer();
        SQLConsoleView viewer = new SQLConsoleView(editor.getSite(), tabsContainer, 0);
        CTabItem item = new CTabItem(tabsContainer, 64);
        item.setControl(viewer.getControl());
        item.setText(ConsoleMessages.console_view_item_text);
        item.setToolTipText("");
        item.setImage(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.SQL_CONSOLE).createImage());
        item.setData((Object)viewer);
        tabsContainer.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                CTabItem cTab;
                Widget item = event.item;
                if (item instanceof CTabItem && (cTab = (CTabItem)item).getData() instanceof SQLConsoleView) {
                    ConsoleViewSwitchHandler.setConcoleViewEnabledForEditor(editor, false);
                }
            }
        });
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (tabsContainer.getItemCount() == 0 && !editor.hasMaximizedControl()) {
                    editor.toggleResultPanel(false, true);
                }
            }
        });
        editor.getResultTabsContainer().setSelection(item);
        UIUtils.disposeControlOnItemDispose((CTabItem)item);
        return new Pair((Object)viewer, (Object)item);
    }

    @NotNull
    private static Pair<SQLConsoleView, CTabItem> obtainConsoleView(@NotNull SQLEditor editor) {
        Pair<SQLConsoleView, CTabItem> viewerAndTab = ConsoleViewSwitchHandler.findExistingConsoleView(editor);
        if (viewerAndTab == null) {
            return ConsoleViewSwitchHandler.createSQLConsoleView(editor);
        }
        return viewerAndTab;
    }

    static void subscribeEditorData(final @NotNull SQLEditor editor) {
        editor.addListener((SQLEditorListener)new SQLEditorListenerDefault(){

            public void onDataReceived(DBPPreferenceStore contextPrefStore, ResultSetModel resultSet, String name) {
                if (ConsoleViewSwitchHandler.isConsoleViewEnabledForEditor(editor) && CommonUtils.isNotEmpty((String)name)) {
                    SQLConsoleView viewer = (SQLConsoleView)((Object)ConsoleViewSwitchHandler.obtainConsoleView(editor).getFirst());
                    viewer.printQueryData(contextPrefStore, resultSet, name);
                }
            }

            public void onQueryResult(@NotNull DBPPreferenceStore contextPrefStore, @NotNull SQLQueryResult result) {
                if (ConsoleViewSwitchHandler.isConsoleViewEnabledForEditor(editor)) {
                    SQLConsoleView viewer = (SQLConsoleView)((Object)ConsoleViewSwitchHandler.obtainConsoleView(editor).getFirst());
                    viewer.printQueryResult(contextPrefStore, result);
                }
            }
        });
    }

    @Nullable
    public Object execute(@NotNull ExecutionEvent event) {
        SQLEditor editor = (SQLEditor)RuntimeUtils.getObjectAdapter((Object)HandlerUtil.getActiveEditor((ExecutionEvent)event), SQLEditor.class);
        if (editor != null) {
            ConsoleViewSwitchHandler.toggleConsoleViewForEditor(editor);
        }
        return null;
    }

    public static void toggleConsoleViewForEditor(@NotNull SQLEditor editor) {
        boolean wasEnabled = ConsoleViewSwitchHandler.isConsoleViewEnabledForEditor(editor);
        if (wasEnabled) {
            Pair<SQLConsoleView, CTabItem> viewerAndTab = ConsoleViewSwitchHandler.findExistingConsoleView(editor);
            if (viewerAndTab != null) {
                ((CTabItem)viewerAndTab.getSecond()).dispose();
                ((SQLConsoleView)((Object)viewerAndTab.getFirst())).dispose();
            }
            ConsoleViewSwitchHandler.setConcoleViewEnabledForEditor(editor, false);
        } else {
            ConsoleViewSwitchHandler.setConcoleViewEnabledForEditor(editor, true);
            if (editor.hasMaximizedControl()) {
                editor.toggleResultPanel(true, false);
            }
            ConsoleViewSwitchHandler.obtainConsoleView(editor);
        }
        editor.getActivePreferenceStore().firePropertyChangeEvent("SQLEditor.ConsoleView.showConsoleViewByDefault", (Object)wasEnabled, (Object)(!wasEnabled ? 1 : 0));
    }

    static boolean isConsoleViewEnabledSetForEditor(@NotNull SQLEditor editor) {
        return editor.getPartProperty(CONSOLE_VIEW_ENABLED_PROPERTY) != null;
    }

    /*
     * Exception decompiling
     */
    public static boolean isConsoleViewEnabledForEditor(@NotNull SQLEditor editor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[6] lbl30 : CaseStatement: default:\u000a, @NONE, blocks:[6] lbl30 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setConcoleViewEnabledForEditor(@NotNull SQLEditor editor, @Nullable Boolean enabled) {
        if (enabled == null) {
            editor.setPartProperty(CONSOLE_VIEW_ENABLED_PROPERTY, CONSOLE_VIEW_ENABLED_VALUE_DEFAULT);
        } else {
            String value = enabled != false ? CONSOLE_VIEW_ENABLED_VALUE_TRUE : CONSOLE_VIEW_ENABLED_VALUE_FALSE;
            editor.setPartProperty(CONSOLE_VIEW_ENABLED_PROPERTY, value);
            IFile activeFile = EditorUtils.getFileFromInput((IEditorInput)editor.getEditorInput());
            if (activeFile != null) {
                try {
                    activeFile.setPersistentProperty(FILE_CONSOLE_VIEW_ENABLED_PROP_NAME, value);
                }
                catch (CoreException e) {
                    log.debug((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void watchForEditor(@NotNull SQLEditor editor) {
        if (!ConsoleViewSwitchHandler.isConsoleViewEnabledSetForEditor(editor)) {
            ConsoleViewSwitchHandler.subscribeEditorData(editor);
        }
    }
}

