/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.connection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionBootstrap;
import org.jkiss.dbeaver.model.connection.DBPConnectionEventType;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.connection.DBPDriverConfigurationType;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNative;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.runtime.DBRShellCommand;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBPConnectionConfiguration
implements DBPObject {
    public static final String VARIABLE_HOST = "host";
    public static final String VARIABLE_PORT = "port";
    public static final String VARIABLE_SERVER = "server";
    public static final String VARIABLE_DATABASE = "database";
    public static final String VARIABLE_USER = "user";
    public static final String VARIABLE_PASSWORD = "password";
    public static final String VARIABLE_URL = "url";
    public static final String VARIABLE_CONN_TYPE = "connectionType";
    public static final String VARIABLE_DATASOURCE = "datasource";
    public static final String VAR_PROJECT_PATH = "project.path";
    public static final String VAR_PROJECT_NAME = "project.name";
    public static final String VAR_HOST_OR_DATABASE = "host_or_database";
    public static final String VARIABLE_DATE = "date";
    public static final String[][] CONNECT_VARIABLES = new String[][]{{"host", "target database host"}, {"port", "target database port"}, {"server", "target server name"}, {"database", "target database name"}, {"user", "database user name"}, {"url", "connection URL"}, {"connectionType", "connection type"}, {"datasource", "datasource"}, {"project.path", "project path"}, {"project.name", "project name"}, {"date", "current date"}, {"workspace", "workspace path"}, {"home", "OS user home path"}, {"dbeaver_home", "application install path"}, {"application.path", "application install path"}, {"application.name", "application name"}, {"application.version", "application version"}, {"local.ip", "local IP address"}};
    public static final String[][] INTERNAL_CONNECT_VARIABLES = (String[][])ArrayUtils.concatArrays((Object[])CONNECT_VARIABLES, (Object[])new String[][]{{"password", "database password (plain)"}});
    private static final Log log = Log.getLog(DBPConnectionConfiguration.class);
    private String hostName;
    private String hostPort;
    private String serverName;
    private String databaseName;
    private String userName;
    private String userPassword;
    private String url;
    private String clientHomeId;
    private String configProfileName;
    @NotNull
    private final Map<String, String> properties;
    @NotNull
    private final Map<String, String> providerProperties;
    @NotNull
    private final Map<String, Object> runtimeAttributes;
    @NotNull
    private final Map<DBPConnectionEventType, DBRShellCommand> events;
    @NotNull
    private final List<DBWHandlerConfiguration> handlers;
    private final DBPConnectionBootstrap bootstrap;
    private DBPConnectionType connectionType;
    private DBPDriverConfigurationType configurationType;
    private String connectionColor;
    private int keepAliveInterval;
    private int closeIdleInterval;
    private String authModelId;
    private Map<String, String> authProperties;

    public DBPConnectionConfiguration() {
        this.connectionType = DBPConnectionType.DEFAULT_TYPE;
        this.configurationType = DBPDriverConfigurationType.MANUAL;
        this.properties = new LinkedHashMap<String, String>();
        this.providerProperties = new LinkedHashMap<String, String>();
        this.events = new LinkedHashMap<DBPConnectionEventType, DBRShellCommand>();
        this.runtimeAttributes = new HashMap<String, Object>();
        this.handlers = new ArrayList<DBWHandlerConfiguration>();
        this.bootstrap = new DBPConnectionBootstrap();
        this.keepAliveInterval = 0;
        this.closeIdleInterval = 0;
    }

    public DBPConnectionConfiguration(@NotNull DBPConnectionConfiguration info) {
        this.hostName = info.hostName;
        this.hostPort = info.hostPort;
        this.serverName = info.serverName;
        this.databaseName = info.databaseName;
        this.userName = info.userName;
        this.userPassword = info.userPassword;
        this.url = info.url;
        this.clientHomeId = info.clientHomeId;
        this.configProfileName = info.configProfileName;
        this.authModelId = info.authModelId;
        this.authProperties = info.authProperties == null ? null : new LinkedHashMap<String, String>(info.authProperties);
        this.connectionType = info.connectionType;
        this.properties = new LinkedHashMap<String, String>(info.properties);
        this.providerProperties = new LinkedHashMap<String, String>(info.providerProperties);
        this.runtimeAttributes = new HashMap<String, Object>(info.runtimeAttributes);
        this.events = new LinkedHashMap<DBPConnectionEventType, DBRShellCommand>(info.events.size());
        for (Map.Entry<DBPConnectionEventType, DBRShellCommand> entry : info.events.entrySet()) {
            this.events.put(entry.getKey(), new DBRShellCommand(entry.getValue()));
        }
        this.handlers = new ArrayList<DBWHandlerConfiguration>(info.handlers.size());
        for (DBWHandlerConfiguration handler : info.handlers) {
            this.handlers.add(new DBWHandlerConfiguration(handler));
        }
        this.bootstrap = new DBPConnectionBootstrap(info.bootstrap);
        this.connectionColor = info.connectionColor;
        this.keepAliveInterval = info.keepAliveInterval;
        this.closeIdleInterval = info.closeIdleInterval;
    }

    public String getClientHomeId() {
        return this.clientHomeId;
    }

    public void setClientHomeId(String clientHomeId) {
        this.clientHomeId = clientHomeId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public void setHostPort(String hostPort) {
        this.hostPort = hostPort;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(@Nullable String userPassword) {
        this.userPassword = userPassword;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    @NotNull
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(@NotNull Map<String, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public String getProviderProperty(String name) {
        return this.providerProperties.get(name);
    }

    public void setProviderProperty(String name, String value) {
        this.providerProperties.put(name, value);
    }

    public void removeProviderProperty(String name) {
        this.providerProperties.remove(name);
    }

    @NotNull
    public Map<String, String> getProviderProperties() {
        return this.providerProperties;
    }

    public void setProviderProperties(@NotNull Map<String, String> properties) {
        this.providerProperties.clear();
        this.providerProperties.putAll(properties);
    }

    public Object getRuntimeAttribute(String name) {
        return this.runtimeAttributes.get(name);
    }

    public void setRuntimeAttribute(String name, Object value) {
        this.runtimeAttributes.put(name, value);
    }

    @NotNull
    public Map<String, Object> getRuntimeAttribute() {
        return this.runtimeAttributes;
    }

    public DBRShellCommand getEvent(DBPConnectionEventType eventType) {
        return this.events.get((Object)eventType);
    }

    public void setEvent(DBPConnectionEventType eventType, DBRShellCommand command) {
        if (command == null) {
            this.events.remove((Object)eventType);
        } else {
            this.events.put(eventType, command);
        }
    }

    public DBPConnectionEventType[] getDeclaredEvents() {
        Set<DBPConnectionEventType> eventTypes = this.events.keySet();
        return eventTypes.toArray(new DBPConnectionEventType[0]);
    }

    @NotNull
    public List<DBWHandlerConfiguration> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(@NotNull List<DBWHandlerConfiguration> handlers) {
        this.handlers.clear();
        this.handlers.addAll(handlers);
    }

    public void updateHandler(DBWHandlerConfiguration handler) {
        int i = 0;
        while (i < this.handlers.size()) {
            if (this.handlers.get(i).getId().equals(handler.getId())) {
                this.handlers.set(i, handler);
                return;
            }
            ++i;
        }
        this.handlers.add(handler);
    }

    @Nullable
    public DBWHandlerConfiguration getHandler(String id) {
        for (DBWHandlerConfiguration cfg : this.handlers) {
            if (!cfg.getId().equals(id)) continue;
            return cfg;
        }
        return null;
    }

    public DBPConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(DBPConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    @NotNull
    public DBPDriverConfigurationType getConfigurationType() {
        return this.configurationType;
    }

    public void setConfigurationType(DBPDriverConfigurationType configurationType) {
        this.configurationType = configurationType;
    }

    public String getConnectionColor() {
        return this.connectionColor;
    }

    public void setConnectionColor(String color) {
        this.connectionColor = color;
    }

    @NotNull
    public DBPConnectionBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(int keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public int getCloseIdleInterval() {
        return this.closeIdleInterval;
    }

    public void setCloseIdleInterval(int closeIdleInterval) {
        this.closeIdleInterval = closeIdleInterval;
    }

    public String getConfigProfileName() {
        return this.configProfileName;
    }

    public void setConfigProfileName(String configProfileName) {
        this.configProfileName = configProfileName;
    }

    public void setConfigProfile(DBWNetworkProfile profile) {
        if (profile == null) {
            this.configProfileName = null;
        } else {
            this.configProfileName = profile.getProfileName();
            for (DBWHandlerConfiguration handlerConfig : profile.getConfigurations()) {
                if (!handlerConfig.isEnabled()) continue;
                this.updateHandler(new DBWHandlerConfiguration(handlerConfig));
            }
        }
    }

    @Nullable
    public String getAuthModelId() {
        return this.authModelId;
    }

    @NotNull
    public DBAAuthModel getAuthModel() {
        if (!CommonUtils.isEmpty((String)this.authModelId)) {
            DBPAuthModelDescriptor authModelDesc = this.getAuthModelDescriptor(this.authModelId);
            if (authModelDesc != null) {
                return authModelDesc.getInstance();
            }
            log.error("Authentication model '" + this.authModelId + "' not found. Use default.");
        }
        return AuthModelDatabaseNative.INSTANCE;
    }

    @NotNull
    public DBPAuthModelDescriptor getAuthModelDescriptor() {
        if (!CommonUtils.isEmpty((String)this.authModelId)) {
            DBPAuthModelDescriptor authModelDesc = this.getAuthModelDescriptor(this.authModelId);
            if (authModelDesc != null) {
                return authModelDesc;
            }
            log.error("Authentication model '" + this.authModelId + "' not found. Use default.");
        }
        return this.getAuthModelDescriptor("native");
    }

    private DBPAuthModelDescriptor getAuthModelDescriptor(String id) {
        return DBWorkbench.getPlatform().getDataSourceProviderRegistry().getAuthModel(id);
    }

    public void setAuthModelId(String authModelId) {
        this.authModelId = authModelId;
    }

    public String getAuthProperty(String name) {
        return this.authProperties == null ? null : this.authProperties.get(name);
    }

    public Map<String, String> getAuthProperties() {
        return this.authProperties;
    }

    public void setAuthProperties(Map<String, String> authProperties) {
        this.authProperties = authProperties;
    }

    public void setAuthProperty(String name, String value) {
        if (this.authProperties == null) {
            this.authProperties = new HashMap<String, String>();
        }
        this.authProperties.put(name, value);
    }

    public String toString() {
        return "ConnectionConfiguration: " + (this.url == null ? this.databaseName : this.url);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBPConnectionConfiguration)) {
            return false;
        }
        DBPConnectionConfiguration source = (DBPConnectionConfiguration)obj;
        return CommonUtils.equalOrEmptyStrings((String)this.hostName, (String)source.hostName) && CommonUtils.equalOrEmptyStrings((String)this.hostPort, (String)source.hostPort) && CommonUtils.equalOrEmptyStrings((String)this.serverName, (String)source.serverName) && CommonUtils.equalOrEmptyStrings((String)this.databaseName, (String)source.databaseName) && CommonUtils.equalOrEmptyStrings((String)this.userName, (String)source.userName) && CommonUtils.equalOrEmptyStrings((String)this.userPassword, (String)source.userPassword) && CommonUtils.equalOrEmptyStrings((String)this.url, (String)source.url) && CommonUtils.equalObjects((Object)this.clientHomeId, (Object)source.clientHomeId) && CommonUtils.equalObjects((Object)this.configProfileName, (Object)source.configProfileName) && CommonUtils.equalObjects((Object)this.authModelId, (Object)source.authModelId) && CommonUtils.equalObjects(this.authProperties, source.authProperties) && CommonUtils.equalObjects((Object)this.connectionType, (Object)source.connectionType) && CommonUtils.equalObjects(this.properties, source.properties) && CommonUtils.equalObjects(this.providerProperties, source.providerProperties) && CommonUtils.equalObjects(this.events, source.events) && CommonUtils.equalObjects(this.handlers, source.handlers) && CommonUtils.equalObjects((Object)this.bootstrap, (Object)source.bootstrap) && this.keepAliveInterval == source.keepAliveInterval && this.closeIdleInterval == source.closeIdleInterval;
    }

    public void resolveDynamicVariables(IVariableResolver variableResolver) {
        this.hostName = GeneralUtils.replaceVariables(this.hostName, variableResolver);
        this.hostPort = GeneralUtils.replaceVariables(this.hostPort, variableResolver);
        this.serverName = GeneralUtils.replaceVariables(this.serverName, variableResolver);
        this.databaseName = GeneralUtils.replaceVariables(this.databaseName, variableResolver);
        this.userName = GeneralUtils.replaceVariables(this.userName, variableResolver);
        this.userPassword = GeneralUtils.replaceVariables(this.userPassword, variableResolver);
        this.url = GeneralUtils.replaceVariables(this.url, variableResolver);
        this.resolveDynamicVariablesInMap(this.properties, variableResolver);
        this.resolveDynamicVariablesInMap(this.authProperties, variableResolver);
        this.resolveDynamicVariablesInMap(this.providerProperties, variableResolver);
        for (DBWHandlerConfiguration handler : this.handlers) {
            if (!handler.isEnabled()) continue;
            handler.resolveDynamicVariables(variableResolver);
        }
        this.bootstrap.resolveDynamicVariables(variableResolver);
    }

    private void resolveDynamicVariablesInMap(Map<String, String> map, IVariableResolver variableResolver) {
        if (map == null) {
            return;
        }
        for (Map.Entry<String, String> prop : map.entrySet()) {
            prop.setValue(GeneralUtils.replaceVariables(prop.getValue(), variableResolver));
        }
    }
}

