/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.app.DBPPlatformEclipse;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLNewScriptTemplateVariablesResolver;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLEditorVariablesResolver;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.dbeaver.ui.editors.sql.scripts.ScriptsHandlerImpl;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLEditorUtils {
    private static final Log log = Log.getLog(SQLEditorUtils.class);
    public static final String SCRIPT_FILE_EXTENSION = "sql";
    private static final QualifiedName NEW_SCRIPT_FILE = new QualifiedName("org.jkiss.dbeaver.ui.editors.sql", "newScriptFile");

    public static boolean isOpenSeparateConnection(DBPDataSourceContainer container) {
        return container.getPreferenceStore().getBoolean("database.editor.separate.connection") && !container.isForceUseSingleConnection() && !container.getDriver().isEmbedded();
    }

    public static IFolder getScriptsFolder(DBPProject project, boolean forceCreate) throws CoreException {
        if (project == null) {
            Status status = new Status(4, "org.jkiss.dbeaver.ui.editors.sql", "No active project to locate Script Folder");
            throw new CoreException((IStatus)status);
        }
        return DBPPlatformEclipse.getInstance().getWorkspace().getResourceDefaultRoot(project, ScriptsHandlerImpl.class, forceCreate);
    }

    @Nullable
    public static ResourceInfo findRecentScript(DBPProject project, @Nullable SQLNavigatorContext context) throws CoreException {
        ArrayList<ResourceInfo> scripts = new ArrayList<ResourceInfo>();
        SQLEditorUtils.findScriptList(project, SQLEditorUtils.getScriptsFolder(project, false), context == null ? null : context.getDataSourceContainer(), scripts);
        long recentTimestamp = 0L;
        ResourceInfo recentFile = null;
        for (ResourceInfo file : scripts) {
            long lastModified;
            if (file.resource == null || (lastModified = ContentUtils.getResourceLastModified((IResource)file.resource)) <= recentTimestamp) continue;
            recentTimestamp = lastModified;
            recentFile = file;
        }
        return recentFile;
    }

    private static void findScriptList(@NotNull DBPProject project, IFolder folder, @Nullable DBPDataSourceContainer container, @NotNull List<ResourceInfo> result) {
        if (folder == null || container == null) {
            return;
        }
        try {
            String[] stringArray = project.findResources(Map.of("default-datasource", container.getId()));
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                IResource resource = project.getRootResource().findMember(path);
                if (resource instanceof IFile) {
                    result.add(new ResourceInfo((IFile)resource, container));
                }
                ++n2;
            }
            for (Map.Entry fileEntry : DBWorkbench.getPlatform().getExternalFileManager().getAllFiles().entrySet()) {
                File extFile;
                if (!container.getId().equals(((Map)fileEntry.getValue()).get("sql-editor-data-source-id")) || !(extFile = new File((String)fileEntry.getKey())).exists()) continue;
                result.add(new ResourceInfo(extFile, container));
            }
        }
        catch (Throwable e) {
            log.debug((Object)e.getMessage());
        }
    }

    public static List<ResourceInfo> findScriptTree(DBPProject project, IFolder folder, @Nullable DBPDataSourceContainer container) {
        ArrayList<ResourceInfo> result = new ArrayList<ResourceInfo>();
        SQLEditorUtils.findScriptList(project, folder, container, result);
        return result;
    }

    @NotNull
    public static List<ResourceInfo> getScriptsFromProject(@NotNull DBPProject dbpProject) throws CoreException {
        IFolder resourceDefaultRoot = DBPPlatformEclipse.getInstance().getWorkspace().getResourceDefaultRoot(dbpProject, ScriptsHandlerImpl.class, false);
        if (resourceDefaultRoot != null) {
            return SQLEditorUtils.getScriptsFromFolder(resourceDefaultRoot);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<ResourceInfo> getScriptsFromFolder(@NotNull IFolder folder) throws CoreException {
        ArrayList<ResourceInfo> scripts = new ArrayList<ResourceInfo>();
        IResource[] iResourceArray = folder.members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            if (member instanceof IFile) {
                IFile iFile = (IFile)member;
                ResourceInfo resourceInfo = new ResourceInfo(iFile, EditorUtils.getFileDataSource((IFile)iFile));
                scripts.add(resourceInfo);
            }
            if (member instanceof IFolder) {
                IFolder iFolder = (IFolder)member;
                scripts.addAll(SQLEditorUtils.getScriptsFromFolder(iFolder));
            }
            ++n2;
        }
        return scripts;
    }

    public static IFile createNewScript(DBPProject project, @Nullable IFolder folder, @NotNull SQLNavigatorContext navigatorContext) throws CoreException {
        NullProgressMonitor progressMonitor = new NullProgressMonitor();
        IFolder scriptsRootFolder = SQLEditorUtils.getScriptsFolder(project, true);
        IFolder scriptsFolder = folder;
        if (scriptsFolder == null) {
            scriptsFolder = scriptsRootFolder;
        }
        if (!scriptsFolder.exists()) {
            scriptsFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        DBPDataSourceContainer dataSourceContainer = navigatorContext.getDataSourceContainer();
        if (CommonUtils.equalObjects((Object)scriptsRootFolder, (Object)scriptsFolder) && dataSourceContainer != null) {
            IFolder dbFolder;
            DBPDataSourceFolder conFolder;
            if (dataSourceContainer.getPreferenceStore().getBoolean("script.auto.connection.folders") && (conFolder = dataSourceContainer.getFolder()) != null) {
                ArrayList<DBPDataSourceFolder> conFolders = new ArrayList<DBPDataSourceFolder>();
                DBPDataSourceFolder f2 = conFolder;
                while (f2 != null) {
                    conFolders.add(0, f2);
                    f2 = f2.getParent();
                }
                for (DBPDataSourceFolder f2 : conFolders) {
                    IFolder dbFolder2 = scriptsFolder.getFolder(CommonUtils.escapeFileName((String)f2.getName()));
                    if (dbFolder2 == null) continue;
                    if (!dbFolder2.exists()) {
                        dbFolder2.create(true, true, (IProgressMonitor)progressMonitor);
                    }
                    scriptsFolder = dbFolder2;
                }
            }
            if (dataSourceContainer.getPreferenceStore().getBoolean("script.auto.folders") && (dbFolder = scriptsFolder.getFolder(CommonUtils.escapeFileName((String)dataSourceContainer.getName()))) != null) {
                if (!dbFolder.exists()) {
                    dbFolder.create(true, true, (IProgressMonitor)progressMonitor);
                }
                scriptsFolder = dbFolder;
            }
        }
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        String pattern = store.getString("script.file.name.pattern");
        String filename = GeneralUtils.replaceVariables((String)pattern, (IVariableResolver)new SQLEditorVariablesResolver(dataSourceContainer, dataSourceContainer == null ? null : dataSourceContainer.getConnectionConfiguration(), navigatorContext.getExecutionContext(), null, null, null));
        IFile tempFile = ContentUtils.getUniqueFile((IFolder)scriptsFolder, (String)(CommonUtils.isEmpty((String)filename) ? "Script" : CommonUtils.escapeFileName((String)filename)), (String)SCRIPT_FILE_EXTENSION);
        tempFile.create((InputStream)new ByteArrayInputStream(SQLEditorUtils.getResolvedNewScriptTemplate(dataSourceContainer).getBytes(StandardCharsets.UTF_8)), true, (IProgressMonitor)progressMonitor);
        tempFile.setSessionProperty(NEW_SCRIPT_FILE, (Object)true);
        if (navigatorContext.getDataSourceContainer() != null) {
            EditorUtils.setFileDataSource((IFile)tempFile, (DatabaseEditorContext)navigatorContext);
        }
        return tempFile;
    }

    public static String getResourceDescription(IResource resource) {
        if (resource instanceof IFolder) {
            return "";
        }
        if (resource instanceof IFile && SCRIPT_FILE_EXTENSION.equals(resource.getFileExtension())) {
            String description = SQLUtils.getScriptDescription((IFile)((IFile)resource));
            if (CommonUtils.isEmptyTrimmed((String)description)) {
                description = "<empty>";
            }
            return description;
        }
        return "";
    }

    public static boolean isNewScriptFile(@NotNull IResource resource) {
        try {
            return Boolean.TRUE.equals(resource.getSessionProperty(NEW_SCRIPT_FILE));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    @NotNull
    public static String getNewScriptTemplate(@NotNull DBPPreferenceStore store) {
        return store.getString("new.script.template");
    }

    @NotNull
    public static String getResolvedNewScriptTemplate(@Nullable DBPDataSourceContainer container) {
        DBPPreferenceStore store;
        if (container != null && (store = container.getPreferenceStore()).getBoolean("new.script.template.enabled")) {
            return GeneralUtils.replaceVariables((String)SQLEditorUtils.getNewScriptTemplate(store), (IVariableResolver)new SQLNewScriptTemplateVariablesResolver(container, container.getConnectionConfiguration()));
        }
        return "";
    }

    public static class ResourceInfo {
        private final IResource resource;
        @Deprecated
        private final File localFile;
        private final DBPDataSourceContainer dataSource;
        private final List<ResourceInfo> children;
        private String description;

        ResourceInfo(IFile file, DBPDataSourceContainer dataSource) {
            this.resource = file;
            IPath location = file.getLocation();
            this.localFile = location == null ? null : location.toFile();
            this.dataSource = dataSource;
            this.children = null;
        }

        public ResourceInfo(IFolder folder) {
            this.resource = folder;
            IPath location = folder.getLocation();
            this.localFile = location == null ? null : location.toFile();
            this.dataSource = null;
            this.children = new ArrayList<ResourceInfo>();
        }

        ResourceInfo(File localFile, DBPDataSourceContainer dataSource) {
            this.resource = null;
            this.localFile = localFile;
            this.dataSource = dataSource;
            this.children = null;
        }

        public IResource getResource() {
            return this.resource;
        }

        public File getLocalFile() {
            return this.localFile;
        }

        public String getName() {
            return this.resource != null ? this.resource.getName() : this.localFile.getName();
        }

        public DBPDataSourceContainer getDataSource() {
            return this.dataSource;
        }

        public boolean isDirectory() {
            return this.resource instanceof IFolder;
        }

        public List<ResourceInfo> getChildren() {
            return this.children;
        }

        public String getDescription() {
            if (this.description == null) {
                this.description = SQLEditorUtils.getResourceDescription(this.resource);
            }
            return this.description;
        }

        public String toString() {
            return this.getName();
        }
    }
}

