/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceConfigurationStorage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.registry.DataSourceConfigurationManager;
import org.jkiss.dbeaver.registry.DataSourceFileStorage;
import org.jkiss.dbeaver.utils.ContentUtils;

public class DataSourceConfigurationManagerNIO
implements DataSourceConfigurationManager {
    private static final Log log = Log.getLog(DataSourceConfigurationManagerNIO.class);
    @NotNull
    private final DBPProject project;

    public DataSourceConfigurationManagerNIO(@NotNull DBPProject project) {
        this.project = project;
    }

    private Path getConfigurationPath(boolean create) {
        return this.project.getMetadataFolder(create);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public List<DBPDataSourceConfigurationStorage> getConfigurationStorages() {
        String fileName;
        List mdFiles;
        ArrayList<DBPDataSourceConfigurationStorage> storages = new ArrayList<DBPDataSourceConfigurationStorage>();
        Path metadataFolder = this.project.getMetadataFolder(false);
        boolean modernFormat = false;
        if (Files.exists(metadataFolder, new LinkOption[0])) {
            try {
                mdFiles = Files.list(metadataFolder).filter(path -> !Files.isDirectory(path, new LinkOption[0]) && Files.exists(path, new LinkOption[0])).collect(Collectors.toList());
                for (Path res : mdFiles) {
                    fileName = res.getFileName().toString();
                    if (!fileName.startsWith("data-sources") || !fileName.endsWith(".json")) continue;
                    storages.add(new DataSourceFileStorage(res, false, fileName.equals("data-sources.json")));
                    modernFormat = true;
                }
            }
            catch (IOException e) {
                log.error((Object)"Error during project files read", (Throwable)e);
            }
        }
        if (!modernFormat && Files.exists(this.project.getAbsolutePath(), new LinkOption[0])) {
            try {
                mdFiles = Files.list(this.project.getAbsolutePath()).filter(path -> !Files.isDirectory(path, new LinkOption[0]) && Files.exists(path, new LinkOption[0])).collect(Collectors.toList());
                for (Path res : mdFiles) {
                    fileName = res.getFileName().toString();
                    if (!fileName.startsWith(".dbeaver-data-sources") || !fileName.endsWith(".xml")) continue;
                    storages.add(new DataSourceFileStorage(res, true, fileName.equals(".dbeaver-data-sources.xml")));
                }
            }
            catch (IOException e) {
                log.error((Object)"Error during legacy project files read", (Throwable)e);
            }
        }
        if (storages.isEmpty()) {
            storages.add(new DataSourceFileStorage(metadataFolder.resolve("data-sources.json"), false, true));
        }
        return storages;
    }

    @Override
    public InputStream readConfiguration(@NotNull String name) throws IOException {
        Path path = this.getConfigurationPath(false).resolve(name);
        if (Files.notExists(path, new LinkOption[0])) {
            path = this.project.getAbsolutePath().resolve(name);
        }
        if (Files.notExists(path, new LinkOption[0])) {
            return null;
        }
        return Files.newInputStream(path, new OpenOption[0]);
    }

    @Override
    public void writeConfiguration(@NotNull String name, @NotNull byte[] data) throws IOException {
        Path configFile = this.getConfigurationPath(true).resolve(name);
        ContentUtils.makeFileBackup((Path)configFile);
        if (data.length == 0) {
            if (Files.exists(configFile, new LinkOption[0])) {
                try {
                    Files.delete(configFile);
                }
                catch (IOException e) {
                    log.debug((Object)("Error deleting file " + configFile.toAbsolutePath()), (Throwable)e);
                }
            }
        } else {
            Files.write(configFile, data, new OpenOption[0]);
        }
    }
}

