/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class ProcedureParameterBindDialog
extends StatusDialog {
    private static final String DIALOG_ID = "DBeaver.ProcedureParameterBindDialog";
    private DBSProcedure procedure;
    private List<DBSProcedureParameter> parameters;
    private Map<DBSProcedureParameter, Object> values = new HashMap<DBSProcedureParameter, Object>();

    public ProcedureParameterBindDialog(Shell shell, DBSProcedure procedure, Map<DBSProcedureParameter, Object> values) {
        super(shell);
        this.procedure = procedure;
        this.parameters = new ArrayList<DBSProcedureParameter>();
        try {
            this.parameters.addAll(procedure.getParameters((DBRProgressMonitor)new VoidProgressMonitor()));
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Can't get parameters", "Error getting procedure papameters", (Throwable)e);
        }
        this.values = new HashMap<DBSProcedureParameter, Object>(values);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(String.valueOf(this.procedure.getProcedureType().name()) + " " + this.procedure.getName() + " parameter(s)");
        Composite composite = (Composite)super.createDialogArea(parent);
        Table paramTable = new Table(composite, 68356);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 200;
        paramTable.setLayoutData((Object)gd);
        paramTable.setHeaderVisible(true);
        paramTable.setLinesVisible(true);
        TableColumn nameColumn = UIUtils.createTableColumn((Table)paramTable, (int)16384, (String)"Name");
        nameColumn.setWidth(100);
        TableColumn valueColumn = UIUtils.createTableColumn((Table)paramTable, (int)16384, (String)"Value");
        valueColumn.setWidth(200);
        TableColumn typeColumn = UIUtils.createTableColumn((Table)paramTable, (int)16384, (String)"Type");
        typeColumn.setWidth(60);
        TableColumn kindColumn = UIUtils.createTableColumn((Table)paramTable, (int)16384, (String)"Kind");
        kindColumn.setWidth(40);
        for (DBSProcedureParameter param : this.parameters) {
            TableItem item = new TableItem(paramTable, 0);
            item.setData((Object)param);
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_ATTRIBUTE));
            item.setText(0, param.getName());
            Object value = this.values.get(param);
            item.setText(1, CommonUtils.toString((Object)value, (String)""));
            item.setText(2, param.getParameterType().getFullTypeName());
            item.setText(3, param.getParameterKind().getTitle());
        }
        CustomTableEditor tableEditor = new CustomTableEditor(paramTable){
            {
                this.firstTraverseIndex = 1;
                this.lastTraverseIndex = 1;
                this.editOnEnter = false;
            }

            protected Control createEditor(Table table, int index, TableItem item) {
                if (index != 1) {
                    return null;
                }
                DBSProcedureParameter param = (DBSProcedureParameter)item.getData();
                Text editor = new Text((Composite)table, 2048);
                editor.setText(CommonUtils.toString((Object)ProcedureParameterBindDialog.this.values.get(param), (String)""));
                editor.selectAll();
                return editor;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                DBSProcedureParameter param = (DBSProcedureParameter)item.getData();
                String newValue = ((Text)control).getText();
                item.setText(1, newValue);
                ProcedureParameterBindDialog.this.values.put(param, newValue);
            }
        };
        if (!this.parameters.isEmpty()) {
            UIUtils.asyncExec(() -> {
                paramTable.select(0);
                tableEditor.showEditor(paramTable.getItem(0), 1);
            });
        }
        this.updateStatus(GeneralUtils.makeInfoStatus((String)"Use Tab to switch."));
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public List<DBSProcedureParameter> getParameters() {
        return this.parameters;
    }

    public Map<DBSProcedureParameter, Object> getValues() {
        return this.values;
    }
}

