/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.net.ssh;

import com.jcraft.jsch.Identity;
import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jsch.internal.core.JSchCorePlugin;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class SSHUtils {
    private static final Log log = Log.getLog(SSHUtils.class);
    private static final String PLATFORM_SSH_PREFERENCES_NODE = "org.eclipse.jsch.core";
    private static final String PLATFORM_SSH_PREFERENCES_SSH2HOME_KEY = "SSH2HOME";
    private static final String DEFAULT_SSH_HOME_DIR_NAME = ".ssh";
    private static final String DEFAULT_SSH_HOME_DIR_NAME_WIN_OLD = "ssh";
    private static final String KNOWN_SSH_HOSTS_FILE_NAME = "known_hosts";

    static int findFreePort() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        int minPort = store.getInt("net.tunnel.port.min");
        int maxPort = store.getInt("net.tunnel.port.max");
        return IOUtils.findFreePort((int)minPort, (int)maxPort);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isKeyEncrypted(String privKeyPath) {
        if (privKeyPath == null) return false;
        try {
            Identity identity;
            JSch testSch = new JSch();
            testSch.addIdentity(privKeyPath);
            IdentityRepository ir = testSch.getIdentityRepository();
            Vector identities = ir.getIdentities();
            Iterator iterator = identities.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(identity = (Identity)iterator.next()).isEncrypted());
            return true;
        }
        catch (JSchException e) {
            log.debug((Object)("Can't check private key encryption: " + e.getMessage()));
        }
        return false;
    }

    public static boolean isKeyEncrypted(byte[] privKeyValue) {
        if (privKeyValue != null) {
            try {
                JSch testSch = new JSch();
                KeyPair keyPair = KeyPair.load((JSch)testSch, (byte[])privKeyValue, null);
                return keyPair.isEncrypted();
            }
            catch (JSchException e) {
                log.debug((Object)("Can't check private key encryption: " + e.getMessage()));
            }
        }
        return false;
    }

    @NotNull
    public static File getKnownSshHostsFileOrDefault() {
        return SSHUtils.getKnownSshHostsFileImpl(true);
    }

    @Nullable
    public static File getKnownSshHostsFileOrNull() {
        return SSHUtils.getKnownSshHostsFileImpl(false);
    }

    private static File getKnownSshHostsFileImpl(boolean forceFileObjectOnFail) {
        String sshHomePathString = Platform.getPreferencesService().getString(PLATFORM_SSH_PREFERENCES_NODE, PLATFORM_SSH_PREFERENCES_SSH2HOME_KEY, null, null);
        if (CommonUtils.isNotEmpty((String)sshHomePathString)) {
            try {
                return Paths.get(sshHomePathString, KNOWN_SSH_HOSTS_FILE_NAME).toFile();
            }
            catch (InvalidPathException e) {
                log.warn((Object)("Failed to resolve SSH known hosts file location at " + sshHomePathString), (Throwable)e);
                if (forceFileObjectOnFail) {
                    return new File(String.valueOf(sshHomePathString) + File.pathSeparator + KNOWN_SSH_HOSTS_FILE_NAME);
                }
                return null;
            }
        }
        return SSHUtils.resolveDefaultKnownSshHostsFile(forceFileObjectOnFail, true);
    }

    private static File resolveDefaultKnownSshHostsFile(boolean forceFileObjectOnFail, boolean updatePreferences) {
        try {
            String userHomePathString = System.getProperty("user.home");
            if (userHomePathString != null) {
                Path userHomeDirPath = Paths.get(userHomePathString, new String[0]);
                if (Files.isDirectory(userHomeDirPath, new LinkOption[0])) {
                    Path sshHomeOldDirPath;
                    Path sshHomeDirPath = userHomeDirPath.resolve(DEFAULT_SSH_HOME_DIR_NAME);
                    if (RuntimeUtils.isWindows() && (!Files.isDirectory(sshHomeDirPath, new LinkOption[0]) || Files.notExists(sshHomeDirPath, new LinkOption[0])) && Files.isDirectory(sshHomeOldDirPath = userHomeDirPath.resolve(DEFAULT_SSH_HOME_DIR_NAME_WIN_OLD), new LinkOption[0])) {
                        sshHomeDirPath = sshHomeOldDirPath;
                    }
                    if (Files.isDirectory(sshHomeDirPath, new LinkOption[0]) || Files.notExists(sshHomeDirPath, new LinkOption[0])) {
                        if (updatePreferences) {
                            Platform.getPreferencesService().getRootNode().node(PLATFORM_SSH_PREFERENCES_NODE).put(PLATFORM_SSH_PREFERENCES_SSH2HOME_KEY, sshHomeDirPath.toAbsolutePath().toString());
                        }
                        return sshHomeDirPath.resolve(KNOWN_SSH_HOSTS_FILE_NAME).toFile();
                    }
                    log.warn((Object)("Failed to resolve default SSH known hosts file location due to invalid SSH home directory " + sshHomeDirPath.toAbsolutePath()));
                } else {
                    log.warn((Object)("Failed to resolve default SSH known hosts file location due to missing user home directory " + userHomeDirPath.toAbsolutePath()));
                }
            } else {
                log.warn((Object)"Failed to resolve default SSH known hosts file location due to missing user home system property.");
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Failed to resolve default SSH known hosts file location.", e);
        }
        if (forceFileObjectOnFail) {
            Path forcedUserProfilePath = Paths.get(RuntimeUtils.isWindows() ? "%USERPROFILE%" : "~", new String[0]);
            return forcedUserProfilePath.resolve(DEFAULT_SSH_HOME_DIR_NAME).resolve(KNOWN_SSH_HOSTS_FILE_NAME).toFile();
        }
        return null;
    }

    public static void forcePlatformReloadKnownHostsPreferences() {
        JSchCorePlugin.getPlugin().setNeedToLoadKnownHosts(true);
        JSchCorePlugin.getPlugin().getJSch().setHostKeyRepository(null);
    }
}

