/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.task;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskEvent;
import org.jkiss.dbeaver.model.task.DBTTaskFolder;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.dbeaver.model.task.DBTTaskType;
import org.jkiss.dbeaver.registry.task.TaskFolderImpl;
import org.jkiss.dbeaver.registry.task.TaskRegistry;
import org.jkiss.dbeaver.registry.task.TaskRunImpl;
import org.jkiss.utils.CommonUtils;

public class TaskImpl
implements DBTTask,
DBPNamedObject2 {
    private static final Log log = Log.getLog(TaskImpl.class);
    private static final String META_FILE_NAME = "meta.json";
    private static final int MAX_RUNS_IN_STATS = 100;
    private static final TaskRunImpl VOID_RUN = new TaskRunImpl();
    private static final Gson gson = new GsonBuilder().setLenient().setDateFormat("yyyyMMddHHmm").create();
    private final DBPProject project;
    private final String id;
    private String label;
    private String description;
    private Date createTime;
    private Date updateTime;
    private DBTTaskType type;
    private Map<String, Object> properties;
    private TaskRunImpl lastRun;
    @Nullable
    private TaskFolderImpl taskFolder;

    public TaskImpl(@NotNull DBPProject project, @NotNull DBTTaskType type, @NotNull String id, @NotNull String label, @Nullable String description, @NotNull Date createTime, @Nullable Date updateTime, @Nullable TaskFolderImpl taskFolder) {
        this.project = project;
        this.id = id;
        this.label = label;
        this.description = description;
        this.createTime = createTime;
        this.updateTime = updateTime;
        this.type = type;
        this.taskFolder = taskFolder;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public DBPProject getProject() {
        return this.project;
    }

    @NotNull
    public String getName() {
        return this.label;
    }

    public void setName(@NotNull String label) {
        this.label = label;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@NotNull String description) {
        this.description = description;
    }

    @Nullable
    public DBTTaskFolder getTaskFolder() {
        return this.taskFolder;
    }

    public void setTaskFolder(@Nullable DBTTaskFolder taskFolder) {
        this.taskFolder = (TaskFolderImpl)taskFolder;
    }

    @NotNull
    public Date getCreateTime() {
        return this.createTime;
    }

    @NotNull
    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @NotNull
    public DBTTaskType getType() {
        return this.type;
    }

    public void setType(DBTTaskType type) {
        this.type = type;
    }

    @NotNull
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Nullable
    public DBTTaskRun getLastRun() {
        if (this.lastRun == null) {
            this.refreshRunStatistics();
        }
        return this.lastRun == VOID_RUN ? null : this.lastRun;
    }

    @NotNull
    public DBTTaskRun[] getRunStatistics() {
        return this.loadRunStatistics().runs.toArray(new DBTTaskRun[0]);
    }

    @NotNull
    public Path getRunLog(DBTTaskRun run) {
        return this.getTaskStatsFolder(false).resolve("run_" + run.getId() + "." + "log");
    }

    public void removeRunLog(DBTTaskRun taskRun) {
        Path runLog = this.getRunLog(taskRun);
        if (Files.exists(runLog, new LinkOption[0])) {
            try {
                Files.delete(runLog);
            }
            catch (IOException e) {
                log.error((Object)("Can't delete log file '" + runLog.toAbsolutePath() + "'"), (Throwable)e);
            }
        }
        RunStatistics runStatistics = this.loadRunStatistics();
        runStatistics.runs.remove(taskRun);
        this.flushRunStatistics(runStatistics);
        if (CommonUtils.equalObjects((Object)this.lastRun, (Object)taskRun)) {
            this.lastRun = null;
        }
        TaskRegistry.getInstance().notifyTaskListeners(new DBTTaskEvent((DBTTask)this, DBTTaskEvent.Action.TASK_UPDATE));
    }

    public void cleanRunStatistics() {
        Path statsFolder = this.getTaskStatsFolder(false);
        if (Files.exists(statsFolder, new LinkOption[0])) {
            try {
                List taskFiles = Files.list(statsFolder).collect(Collectors.toList());
                for (Path file : taskFiles) {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        log.error((Object)("Can't delete log item '" + file.toAbsolutePath() + "'"), (Throwable)e);
                    }
                }
                Files.delete(statsFolder);
            }
            catch (IOException e) {
                log.error((Object)("Can't delete logs folder '" + statsFolder.toAbsolutePath() + "'"), (Throwable)e);
            }
        }
        RunStatistics runStatistics = new RunStatistics();
        this.flushRunStatistics(runStatistics);
        this.lastRun = null;
        TaskRegistry.getInstance().notifyTaskListeners(new DBTTaskEvent((DBTTask)this, DBTTaskEvent.Action.TASK_UPDATE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshRunStatistics() {
        try {
            TaskImpl taskImpl = this;
            synchronized (taskImpl) {
                List<TaskRunImpl> runs = this.loadRunStatistics().runs;
                this.lastRun = runs.isEmpty() ? VOID_RUN : runs.get(runs.size() - 1);
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Error loading task runs", e);
        }
    }

    public void setProperties(@NotNull Map<String, Object> properties) {
        this.properties = new LinkedHashMap<String, Object>(properties);
    }

    public boolean isTemporary() {
        return "#temp".equals(this.id);
    }

    @NotNull
    public Path getRunLogFolder() {
        return this.getTaskStatsFolder(false);
    }

    Path getTaskStatsFolder(boolean create) {
        Path taskStatsFolder = this.project.getTaskManager().getStatisticsFolder().resolve(this.id);
        if (create && !Files.exists(taskStatsFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(taskStatsFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.error((Object)("Can't create task log folder '" + taskStatsFolder.toAbsolutePath() + "'"), (Throwable)e);
            }
        }
        return taskStatsFolder;
    }

    private RunStatistics loadRunStatistics() {
        Path metaFile = this.getTaskStatsFolder(false).resolve(META_FILE_NAME);
        if (!Files.exists(metaFile, new LinkOption[0])) {
            return new RunStatistics();
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = Files.newBufferedReader(metaFile);){
                RunStatistics statistics = (RunStatistics)gson.fromJson((Reader)reader, RunStatistics.class);
                if (statistics == null) {
                    log.error((Object)"Null task run statistics returned");
                    return new RunStatistics();
                }
                return statistics;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading task run statistics", (Throwable)e);
            return new RunStatistics();
        }
    }

    private void flushRunStatistics(RunStatistics stats) {
        Path metaFile = this.getTaskStatsFolder(true).resolve(META_FILE_NAME);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(metaFile, new OpenOption[0]);){
                String metaContent = gson.toJson((Object)stats);
                writer.write(metaContent);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error((Object)"Error writing task run statistics", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNewRun(TaskRunImpl taskRun) {
        TaskImpl taskImpl = this;
        synchronized (taskImpl) {
            this.lastRun = taskRun;
            RunStatistics stats = this.loadRunStatistics();
            stats.runs.add(taskRun);
            while (stats.runs.size() > 100) {
                stats.runs.remove(0);
            }
            this.flushRunStatistics(stats);
        }
        TaskRegistry.getInstance().notifyTaskListeners(new DBTTaskEvent((DBTTask)this, DBTTaskEvent.Action.TASK_UPDATE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRun(TaskRunImpl taskRun) {
        TaskImpl taskImpl = this;
        synchronized (taskImpl) {
            RunStatistics stats = this.loadRunStatistics();
            List<TaskRunImpl> runs = stats.runs;
            int i = 0;
            while (i < runs.size()) {
                TaskRunImpl run = runs.get(i);
                if (CommonUtils.equalObjects((Object)run.getId(), (Object)taskRun.getId())) {
                    runs.set(i, taskRun);
                    break;
                }
                ++i;
            }
            this.flushRunStatistics(stats);
        }
        TaskRegistry.getInstance().notifyTaskListeners(new DBTTaskEvent((DBTTask)this, DBTTaskEvent.Action.TASK_UPDATE));
    }

    public String toString() {
        return String.valueOf(this.id) + " " + this.label + " (" + this.type.getName() + ")";
    }

    private static class RunStatistics {
        private final List<TaskRunImpl> runs = new ArrayList<TaskRunImpl>();

        private RunStatistics() {
        }
    }
}

