/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common.grammar.nfa;

import org.jkiss.dbeaver.parser.common.grammar.GrammarRule;
import org.jkiss.dbeaver.parser.common.grammar.nfa.ParseOperationKind;

public class GrammarNfaOperation {
    private final int exprId;
    private final ParseOperationKind kind;
    private final String pattern;
    private final GrammarRule rule;
    private final Integer minIterations;
    private final Integer maxIterations;
    private final Integer exprPosition;

    private GrammarNfaOperation(int exprId, ParseOperationKind kind, String pattern, GrammarRule ruleName, Integer minIterations, Integer maxIterations, Integer exprPosition) {
        this.exprId = exprId;
        this.kind = kind;
        this.pattern = pattern;
        this.rule = ruleName;
        this.minIterations = minIterations;
        this.maxIterations = maxIterations;
        this.exprPosition = exprPosition;
        this.validate();
    }

    public int getExprId() {
        return this.exprId;
    }

    public ParseOperationKind getKind() {
        return this.kind;
    }

    public String getPattern() {
        return this.pattern;
    }

    public GrammarRule getRule() {
        return this.rule;
    }

    public Integer getMinIterations() {
        return this.minIterations;
    }

    public Integer getMaxIterations() {
        return this.maxIterations;
    }

    public Integer getExprPosition() {
        return this.exprPosition;
    }

    private void validate() {
        switch (this.kind) {
            case RULE_START: 
            case RULE_END: 
            case CALL: 
            case RESUME: {
                if (this.rule != null) break;
                throw new IllegalArgumentException();
            }
            case LOOP_ENTER: 
            case LOOP_INCREMENT: 
            case LOOP_EXIT: 
            case SEQ_ENTER: 
            case SEQ_STEP: 
            case SEQ_EXIT: {
                if (this.maxIterations == null || this.minIterations == null) {
                    throw new IllegalArgumentException();
                }
                if (this.kind != ParseOperationKind.SEQ_STEP || this.exprPosition != null) break;
                throw new IllegalArgumentException();
            }
            case TERM: {
                if (this.pattern != null) break;
                throw new IllegalArgumentException();
            }
            case NONE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected parse operation kind " + (Object)((Object)this.kind));
            }
        }
    }

    public String toString() {
        String result = String.valueOf(this.kind.toString()) + "#" + this.exprId + "[";
        switch (this.kind) {
            case RULE_START: 
            case RULE_END: 
            case CALL: 
            case RESUME: {
                result = String.valueOf(result) + this.rule;
                break;
            }
            case LOOP_ENTER: 
            case LOOP_INCREMENT: 
            case LOOP_EXIT: 
            case SEQ_ENTER: 
            case SEQ_STEP: 
            case SEQ_EXIT: {
                if (this.exprPosition != null) {
                    result = String.valueOf(result) + this.exprPosition + "/";
                }
                result = String.valueOf(result) + this.minIterations + ".." + this.maxIterations;
                break;
            }
            case TERM: {
                result = String.valueOf(result) + this.pattern;
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected parse opeation kind " + (Object)((Object)this.kind));
            }
        }
        return String.valueOf(result) + "]";
    }

    public static GrammarNfaOperation makeRuleOperation(int exprId, ParseOperationKind opKind, GrammarRule rule) {
        return new GrammarNfaOperation(exprId, opKind, null, rule, null, null, null);
    }

    public static GrammarNfaOperation makeSequenceOperation(int exprId, ParseOperationKind opKind, int min, int max, Integer exprPosition) {
        return new GrammarNfaOperation(exprId, opKind, null, null, min, max, exprPosition);
    }

    public static GrammarNfaOperation makeTerm(int exprId, String pattern) {
        return new GrammarNfaOperation(exprId, ParseOperationKind.TERM, pattern, null, null, null, null);
    }

    public static GrammarNfaOperation makeEmpty(int exprId) {
        return new GrammarNfaOperation(exprId, ParseOperationKind.NONE, null, null, null, null, null);
    }
}

