/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.dnd.LocalObjectTransfer;

public class TabFolderReorder {
    public static final int ITEM_MOVE_EVENT = 1001;
    private final CTabFolder folder;
    private CTabItem dragItem;

    public TabFolderReorder(final CTabFolder folder) {
        this.folder = folder;
        DragSource source = new DragSource((Control)folder, 2);
        source.setTransfer(new Transfer[]{TabTransfer.INSTANCE});
        source.addDragListener(new DragSourceListener(){
            private Image dragImage;

            public void dragStart(DragSourceEvent event) {
                Point point = folder.toControl(folder.getDisplay().getCursorLocation());
                TabFolderReorder.this.dragItem = folder.getItem(point);
                if (TabFolderReorder.this.dragItem == null) {
                    return;
                }
                Rectangle columnBounds = TabFolderReorder.this.dragItem.getBounds();
                if (this.dragImage != null) {
                    this.dragImage.dispose();
                    this.dragImage = null;
                }
                GC gc = new GC((Drawable)folder);
                this.dragImage = new Image((Device)Display.getCurrent(), columnBounds.width, columnBounds.height);
                gc.copyArea(this.dragImage, columnBounds.x, columnBounds.y);
                event.image = this.dragImage;
                gc.dispose();
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = TabFolderReorder.this.dragItem;
            }

            public void dragFinished(DragSourceEvent event) {
                if (this.dragImage != null) {
                    this.dragImage.dispose();
                    this.dragImage = null;
                }
            }
        });
        DropTarget dropTarget = new DropTarget((Control)folder, 2);
        dropTarget.setTransfer(new Transfer[]{TabTransfer.INSTANCE, TextTransfer.getInstance()});
        dropTarget.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragLeave(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            public void drop(DropTargetEvent event) {
                this.handleDragEvent(event);
                if (event.detail == 2) {
                    Point point = folder.toControl(folder.getDisplay().getCursorLocation());
                    CTabItem item = folder.getItem(new Point(point.x, point.y));
                    if (item != null && TabFolderReorder.this.dragItem != null) {
                        TabFolderReorder.this.moveTab(folder, folder.indexOf(TabFolderReorder.this.dragItem), folder.indexOf(item));
                    }
                }
            }

            public void dropAccept(DropTargetEvent event) {
                this.handleDragEvent(event);
            }

            private void handleDragEvent(DropTargetEvent event) {
                event.detail = !this.isDropSupported(folder, event) ? 0 : 2;
                event.feedback = 1;
            }

            private boolean isDropSupported(CTabFolder folder2, DropTargetEvent event) {
                if (TabFolderReorder.this.dragItem == null) {
                    return false;
                }
                Point point = folder2.toControl(folder2.getDisplay().getCursorLocation());
                CTabItem item = folder2.getItem(new Point(point.x, point.y));
                return item != null && TabFolderReorder.this.dragItem.getShowClose() == item.getShowClose();
            }
        });
    }

    public void moveTab(@NotNull CTabFolder folder, int from, int to) {
        if (from == to) {
            return;
        }
        CTabItem currTabItem = folder.getItem(from);
        if (from < to) {
            int i = from + 1;
            while (i <= to) {
                CTabItem nextTabItem = folder.getItem(i);
                this.swapTabs(currTabItem, nextTabItem);
                currTabItem = nextTabItem;
                ++i;
            }
        } else {
            int i = from - 1;
            while (i >= to) {
                CTabItem nextTabItem = folder.getItem(i);
                this.swapTabs(currTabItem, nextTabItem);
                currTabItem = nextTabItem;
                --i;
            }
        }
    }

    public void swapTabs(@NotNull CTabItem src, @NotNull CTabItem dst) {
        if (src == dst) {
            return;
        }
        Control dragControl = src.getControl();
        String dragText = src.getText();
        Image dragImage = src.getImage();
        String dragToolTip = src.getToolTipText();
        boolean dragShowClose = src.getShowClose();
        Object dragData = src.getData();
        src.setText(dst.getText());
        src.setImage(dst.getImage());
        src.setToolTipText(dst.getToolTipText());
        src.setData(dst.getData());
        src.setShowClose(dst.getShowClose());
        src.setControl(dst.getControl());
        dst.setText(dragText);
        dst.setImage(dragImage);
        dst.setToolTipText(dragToolTip);
        dst.setData(dragData);
        dst.setShowClose(dragShowClose);
        dst.setControl(dragControl);
        this.folder.setSelection(dst);
        Event srcEvent = new Event();
        srcEvent.widget = this.folder;
        srcEvent.item = src;
        this.folder.notifyListeners(1001, srcEvent);
        Event dstEvent = new Event();
        dstEvent.widget = this.folder;
        dstEvent.item = dst;
        this.folder.notifyListeners(1001, dstEvent);
    }

    public static final class TabTransfer
    extends LocalObjectTransfer<CTabItem> {
        public static final TabTransfer INSTANCE = new TabTransfer();
        private static final String TYPE_NAME = "TabTransfer.CTabItem Transfer" + System.currentTimeMillis() + ":" + ((Object)((Object)INSTANCE)).hashCode();
        private static final int TYPEID = TabTransfer.registerType((String)TYPE_NAME);

        private TabTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{TYPEID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }
    }
}

