/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.internal.p2.engine.SharedProfilePreferences;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.internal.p2.engine.SlashEncode;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.BackingStoreException;

public class ProfilePreferences
extends EclipsePreferences {
    private static Set<String> loadedNodes = Collections.synchronizedSet(new HashSet());
    public static final Object PROFILE_SAVE_JOB_FAMILY = new Object();
    private static final long SAVE_SCHEDULE_DELAY = 500L;
    protected IEclipsePreferences loadLevel;
    protected Object profileLock;
    protected String qualifier;
    private SaveJob saveJob;
    protected int segmentCount;

    public ProfilePreferences() {
        this(null, null);
    }

    public ProfilePreferences(EclipsePreferences nodeParent, String nodeName) {
        super(nodeParent, nodeName);
        String path = this.absolutePath();
        this.segmentCount = ProfilePreferences.getSegmentCount((String)path);
        if (this.segmentCount <= 2) {
            return;
        }
        if (this.segmentCount == 3) {
            this.profileLock = new Object();
        }
        if (this.segmentCount < 4) {
            return;
        }
        this.qualifier = this.getQualifierSegment();
    }

    private boolean containsProfile(IProfileRegistry profileRegistry, String profileId) {
        if (profileId == null || profileRegistry == null) {
            return false;
        }
        return profileRegistry.containsProfile(profileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSave(IProvisioningAgent agent) throws BackingStoreException {
        Object object = ((ProfilePreferences)this.parent).profileLock;
        synchronized (object) {
            String profileId = this.getProfileIdSegment();
            IProfileRegistry registry = (IProfileRegistry)agent.getService(IProfileRegistry.class);
            if (registry == null) {
                return;
            }
            if (!this.containsProfile(registry, profileId)) {
                IPath location;
                if ("_SELF_".equals(profileId) && (location = this.getDefaultLocation(agent)) != null) {
                    super.save(location);
                    return;
                }
                if (Tracing.DEBUG_PROFILE_PREFERENCES) {
                    Tracing.debug((String)("Not saving preferences since there is no file for node: " + this.absolutePath()));
                }
                return;
            }
            super.save(this.getProfileLocation(registry, profileId));
        }
    }

    protected IProvisioningAgent getAgent(String segment) throws BackingStoreException {
        String locationString = SlashEncode.decode(segment);
        InvalidSyntaxException failure = null;
        IProvisioningAgent result = null;
        try {
            Collection refs;
            String filter = "(locationURI=" + this.encodeForFilter(locationString) + ')';
            BundleContext context = EngineActivator.getContext();
            if (context != null && !(refs = context.getServiceReferences(IProvisioningAgent.class, filter)).isEmpty()) {
                ServiceReference ref = (ServiceReference)refs.iterator().next();
                result = (IProvisioningAgent)EngineActivator.getContext().getService(ref);
                EngineActivator.getContext().ungetService(ref);
                return result;
            }
        }
        catch (InvalidSyntaxException e) {
            failure = e;
        }
        throw new BackingStoreException("Unable to determine provisioning agent from location: " + segment, (Throwable)failure);
    }

    private String encodeForFilter(String string) {
        char[] input;
        StringBuilder result = new StringBuilder(string.length());
        char[] cArray = input = string.toCharArray();
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            char element = cArray[n2];
            switch (element) {
                case '(': 
                case ')': 
                case '*': 
                case '\\': {
                    result.append('\\');
                }
            }
            result.append(element);
            ++n2;
        }
        return result.toString();
    }

    private IPath getDefaultLocation(IProvisioningAgent agent) {
        IAgentLocation location = (IAgentLocation)agent.getService(IAgentLocation.class);
        if (location == null) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.engine", "Agent location service not available", (Throwable)new RuntimeException()));
            return null;
        }
        Path dataArea = new Path(URIUtil.toFile((URI)location.getDataArea("org.eclipse.equinox.p2.engine")).getAbsolutePath());
        return this.computeLocation((IPath)dataArea, this.qualifier);
    }

    protected IEclipsePreferences getLoadLevel() {
        if (this.loadLevel == null) {
            if (this.qualifier == null) {
                return null;
            }
            ProfilePreferences node = this;
            int i = 4;
            while (i < this.segmentCount) {
                node = (EclipsePreferences)node.parent();
                ++i;
            }
            this.loadLevel = node;
        }
        return this.loadLevel;
    }

    private IPath getProfileLocation(IProfileRegistry registry, String profileId) {
        SimpleProfileRegistry profileRegistry = (SimpleProfileRegistry)registry;
        File profileDataDirectory = profileRegistry.getProfileDataDirectory(profileId);
        return this.computeLocation((IPath)new Path(profileDataDirectory.getAbsolutePath()), this.qualifier);
    }

    protected EclipsePreferences internalCreate(EclipsePreferences nodeParent, String nodeName, Object context) {
        if (nodeName.equals("shared") && this.segmentCount == 1) {
            return new SharedProfilePreferences(nodeParent, nodeName);
        }
        return new ProfilePreferences(nodeParent, nodeName);
    }

    protected boolean isAlreadyLoaded(IEclipsePreferences node) {
        return loadedNodes.contains(node.absolutePath());
    }

    protected boolean isAlreadyLoaded(String path) {
        return loadedNodes.contains(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() throws BackingStoreException {
        Object object = ((ProfilePreferences)this.parent).profileLock;
        synchronized (object) {
            String profileId;
            IProvisioningAgent agent = this.getAgent(this.getAgentLocationSegment());
            if (agent == null) {
                return;
            }
            IProfileRegistry registry = (IProfileRegistry)agent.getService(IProfileRegistry.class);
            if (!this.containsProfile(registry, profileId = this.getProfileIdSegment())) {
                IPath location;
                if ("_SELF_".equals(profileId) && (location = this.getDefaultLocation(agent)) != null) {
                    this.load(location);
                    return;
                }
                if (Tracing.DEBUG_PROFILE_PREFERENCES) {
                    Tracing.debug((String)("Not loading preferences since there is no file for node: " + this.absolutePath()));
                }
                return;
            }
            this.load(this.getProfileLocation(registry, profileId));
        }
    }

    protected void loaded() {
        loadedNodes.add(this.name());
    }

    public void removeNode() throws BackingStoreException {
        super.removeNode();
        loadedNodes.remove(this.absolutePath());
    }

    protected synchronized void save() throws BackingStoreException {
        BundleContext context;
        block7: {
            try {
                IProvisioningAgent agent = this.getAgent(this.getAgentLocationSegment());
                if (this.saveJob == null || this.saveJob.agent != agent) {
                    this.saveJob = new SaveJob(agent);
                }
            }
            catch (BackingStoreException e) {
                if (!Tracing.DEBUG_PROFILE_PREFERENCES) break block7;
                e.printStackTrace();
            }
        }
        if ((context = EngineActivator.getContext()) == null || this.saveJob == null) {
            return;
        }
        try {
            if (context.getBundle().getState() == 32) {
                this.saveJob.schedule(500L);
            }
        }
        catch (IllegalStateException illegalStateException) {}
    }

    protected String getQualifierSegment() {
        return ProfilePreferences.getSegment((String)this.absolutePath(), (int)3);
    }

    protected String getProfileIdSegment() {
        return ProfilePreferences.getSegment((String)this.absolutePath(), (int)2);
    }

    protected String getAgentLocationSegment() {
        return ProfilePreferences.getSegment((String)this.absolutePath(), (int)1);
    }

    private class SaveJob
    extends Job {
        IProvisioningAgent agent;

        SaveJob(IProvisioningAgent agent) {
            super(Messages.ProfilePreferences_saving);
            this.setSystem(true);
            this.agent = agent;
        }

        public boolean belongsTo(Object family) {
            return family == PROFILE_SAVE_JOB_FAMILY;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ProfilePreferences.this.doSave(this.agent);
            }
            catch (IllegalStateException e) {
                if (Tracing.DEBUG_PROFILE_PREFERENCES) {
                    Tracing.debug((String)"Attempt to save preferences after agent has been stopped");
                    e.printStackTrace();
                }
            }
            catch (BackingStoreException e) {
                LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.engine", "Exception saving profile preferences", (Throwable)e));
            }
            catch (RuntimeException e) {
                LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.engine", "Exception saving profile preferences", (Throwable)e));
            }
            return Status.OK_STATUS;
        }
    }
}

