/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions.datasource;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBServiceConnections;
import org.jkiss.dbeaver.runtime.ui.UIServiceConnections;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceHandler;
import org.jkiss.dbeaver.ui.dialogs.connection.EditConnectionDialog;

public class UIServiceConnectionsImpl
implements DBServiceConnections,
UIServiceConnections {
    private static final Log log = Log.getLog(UIServiceConnectionsImpl.class);

    public void openConnectionEditor(@NotNull DBPDataSourceContainer dataSourceContainer, String defaultPageName) {
        EditConnectionDialog.openEditConnectionDialog(UIUtils.getActiveWorkbenchWindow(), dataSourceContainer, defaultPageName);
    }

    public void connectDataSource(@NotNull DBPDataSourceContainer dataSourceContainer, DBRProgressListener onFinish) {
        DataSourceHandler.connectToDataSource(null, dataSourceContainer, onFinish);
    }

    public void disconnectDataSource(@NotNull DBPDataSourceContainer dataSourceContainer) {
        DataSourceHandler.disconnectDataSource(dataSourceContainer, null);
    }

    public void closeActiveTransaction(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, boolean commitTxn) {
        DataSourceHandler.closeActiveTransaction(monitor, context, commitTxn);
    }

    public boolean confirmTransactionsClose(@NotNull DBCExecutionContext[] contexts) {
        return DataSourceHandler.confirmTransactionsClose(contexts);
    }

    public boolean checkAndCloseActiveTransaction(@NotNull DBCExecutionContext[] contexts) {
        return DataSourceHandler.checkAndCloseActiveTransaction(contexts, false);
    }

    public void initConnection(DBRProgressMonitor monitor, DBPDataSourceContainer dataSourceContainer, DBRProgressListener onFinish) {
        DataSourceHandler.connectToDataSource(monitor, dataSourceContainer, onFinish);
    }
}

