/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class DatabaseNavigatorLabelProvider
extends ColumnLabelProvider
implements IFontProvider,
IColorProvider {
    protected Font normalFont;
    protected Font boldFont;
    protected Font italicFont;
    protected Color lockedForeground;
    protected Color transientForeground;
    private ILabelDecorator labelDecorator;

    public DatabaseNavigatorLabelProvider(Viewer viewer) {
        this.normalFont = viewer.getControl().getFont();
        this.boldFont = UIUtils.makeBoldFont((Font)this.normalFont);
        this.italicFont = UIUtils.modifyFont((Font)this.normalFont, (int)2);
        this.lockedForeground = Display.getDefault().getSystemColor(15);
        this.transientForeground = Display.getDefault().getSystemColor(4);
    }

    public void dispose() {
        UIUtils.dispose((Resource)this.boldFont);
        this.boldFont = null;
        UIUtils.dispose((Resource)this.italicFont);
        this.italicFont = null;
        super.dispose();
    }

    ILabelDecorator getLabelDecorator() {
        return this.labelDecorator;
    }

    void setLabelDecorator(ILabelDecorator labelDecorator) {
        this.labelDecorator = labelDecorator;
    }

    public String getText(Object obj) {
        String text = null;
        if (obj instanceof ILabelProvider) {
            text = ((ILabelProvider)obj).getText(obj);
        } else if (obj instanceof DBNNode) {
            String briefInfo;
            text = ((DBNNode)obj).getNodeName();
            if (DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.objects.tips") && !CommonUtils.isEmpty((String)(briefInfo = ((DBNNode)obj).getNodeBriefInfo()))) {
                text = String.valueOf(text) + " (" + briefInfo + ")";
            }
        } else if (obj != null) {
            text = obj.toString();
        }
        if (text == null) {
            text = "?";
        }
        if (this.isFilteredElement(obj)) {
            text = String.valueOf(text) + " (...)";
        }
        return text;
    }

    public Image getImage(Object obj) {
        Image image = null;
        if (obj instanceof ILabelProvider) {
            image = ((ILabelProvider)obj).getImage(obj);
        } else if (obj instanceof DBNNode) {
            image = DBeaverIcons.getImage((DBPImage)((DBNNode)obj).getNodeIconDefault());
        }
        if (this.labelDecorator != null && obj instanceof DBNResource) {
            image = this.labelDecorator.decorateImage(image, obj);
        }
        return image;
    }

    public Font getFont(Object element) {
        DBPDataSourceContainer ds;
        if (DBNUtils.isDefaultElement((Object)element)) {
            return this.boldFont;
        }
        if (element instanceof DBNDataSource && (ds = ((DBNDataSource)element).getDataSourceContainer()) != null && (ds.isProvided() || ds.isTemporary())) {
            return this.italicFont;
        }
        return this.normalFont;
    }

    public Color getForeground(Object element) {
        if (element instanceof DBNNode) {
            DBNNode node = (DBNNode)element;
            if (node instanceof DBNDataSource) {
                DBPDataSourceContainer ds = ((DBNDataSource)element).getDataSourceContainer();
                Color bgColor = UIUtils.getConnectionColor((DBPConnectionConfiguration)ds.getConnectionConfiguration());
                return bgColor == null ? null : UIUtils.getContrastColor((Color)bgColor);
            }
            if (node.isLocked()) {
                return this.lockedForeground;
            }
            if (node instanceof DBSWrapper && ((DBSWrapper)node).getObject() != null && !((DBSWrapper)node).getObject().isPersisted()) {
                return this.transientForeground;
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        DBPDataSourceContainer ds;
        if (element instanceof DBNDataSource && (ds = ((DBNDataSource)element).getDataSourceContainer()) != null) {
            return UIUtils.getConnectionColor((DBPConnectionConfiguration)ds.getConnectionConfiguration());
        }
        return null;
    }

    private boolean isFilteredElement(Object element) {
        return element instanceof DBNNode && ((DBNNode)element).isFiltered();
    }

    public String getToolTipText(Object element) {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.tooltips")) {
            return null;
        }
        if (element instanceof DBNDataSource) {
            DBPDataSourceContainer ds = ((DBNDataSource)element).getDataSourceContainer();
            if (ds != null) {
                StringBuilder info = new StringBuilder();
                info.append("Name: ").append(ds.getName()).append("\n");
                DBPConnectionConfiguration cfg = ds.getConnectionConfiguration();
                if (!CommonUtils.isEmpty((String)cfg.getUrl())) {
                    info.append("URL: ").append(cfg.getUrl()).append("\n");
                } else if (!CommonUtils.isEmpty((String)cfg.getDatabaseName())) {
                    info.append("Database: ").append(cfg.getDatabaseName()).append("\n");
                }
                if (!CommonUtils.isEmpty((String)cfg.getUserName())) {
                    info.append("User: ").append(cfg.getUserName()).append("\n");
                }
                if (!CommonUtils.isEmpty((String)ds.getDescription())) {
                    info.append("Description: ").append(ds.getDescription()).append("\n");
                }
                if (ds.isConnectionReadOnly()) {
                    info.append("Read-only connection\n");
                }
                if (ds.isProvided()) {
                    info.append("Provided connection\n");
                }
                return info.toString().trim();
            }
        } else if (element instanceof DBNNode) {
            if (element instanceof DBNResource && !DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.tooltips.file.contents")) {
                return null;
            }
            String description = ((DBNNode)element).getNodeDescription();
            if (!CommonUtils.isEmptyTrimmed((String)description)) {
                return description;
            }
            return ((DBNNode)element).getNodeName();
        }
        return null;
    }

    public Image getToolTipImage(Object element) {
        if (!DBWorkbench.getPlatform().getPreferenceStore().getBoolean("navigator.show.tooltips")) {
            return null;
        }
        if (element instanceof DBNNode) {
            return DBeaverIcons.getImage((DBPImage)((DBNNode)element).getNodeIconDefault());
        }
        return null;
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 0;
    }

    public int getToolTipStyle(Object object) {
        return super.getToolTipStyle(object);
    }

    public boolean useNativeToolTip(Object object) {
        return true;
    }
}

