/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.generator;

import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.impl.sql.ChangeTableDataStatement;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.generator.SQLGeneratorResultSet;
import org.jkiss.utils.CommonUtils;

public class SQLGeneratorDeleteFromData
extends SQLGeneratorResultSet {
    @Override
    public void generateSQL(DBRProgressMonitor monitor, StringBuilder sql, IResultSetController object) {
        DBSEntity dbsEntity = this.getSingleEntity();
        String entityName = this.getEntityName(dbsEntity);
        for (ResultSetRow firstRow : this.getSelectedRows()) {
            List<DBDAttributeBinding> keyAttributes = this.getKeyAttributes(monitor, object);
            if (dbsEntity instanceof ChangeTableDataStatement) {
                sql.append(((ChangeTableDataStatement)dbsEntity).generateTableDeleteFrom(entityName));
            } else {
                sql.append("DELETE FROM ").append(entityName);
            }
            sql.append(this.getLineSeparator()).append("WHERE ");
            if (CommonUtils.isEmpty(keyAttributes)) {
                Collection<? extends DBSAttributeBase> allAttributes = this.getAllAttributes(monitor, object);
                for (DBSAttributeBase dBSAttributeBase : allAttributes) {
                    DBDAttributeBinding binding;
                    if (DBUtils.isPseudoAttribute((DBSAttributeBase)dBSAttributeBase) || DBUtils.isHiddenObject((Object)dBSAttributeBase) || (binding = this.getController().getModel().getAttributeBinding(dBSAttributeBase)) == null) continue;
                    keyAttributes.add(binding);
                }
            }
            this.appendKeyConditions(sql, keyAttributes, firstRow);
            sql.append(";\n");
        }
    }
}

